/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;

public class RemoteCallParameter
implements IRemoteCallParameter {
    private String name;
    private Object value;

    public RemoteCallParameter(String name, Object value) {
        this.name = name;
        Assert.isNotNull((Object)this.name);
        this.value = value;
    }

    public RemoteCallParameter(String name) {
        this(name, null);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RemoteCallParameter[name=");
        buffer.append(this.name);
        buffer.append(", value=");
        buffer.append(this.value);
        buffer.append("]");
        return buffer.toString();
    }

    public static class Builder {
        private final List<IRemoteCallParameter> parameters = new ArrayList<IRemoteCallParameter>();

        public Builder addParameter(String name, Object defaultValue) {
            if (name == null) {
                return this;
            }
            this.parameters.add(new RemoteCallParameter(name, defaultValue));
            return this;
        }

        public Builder addParameter(String name) {
            return this.addParameter(name, null);
        }

        public Builder addParameter(IRemoteCallParameter param) {
            if (param == null) {
                return this;
            }
            this.parameters.add(param);
            return this;
        }

        public IRemoteCallParameter[] build() {
            return this.parameters.toArray(new IRemoteCallParameter[this.parameters.size()]);
        }
    }
}

