/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.host;

import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.status.SerializableStatus;
import org.eclipse.ecf.mgmt.framework.FrameworkMTO;
import org.eclipse.ecf.mgmt.framework.IFrameworkManager;
import org.eclipse.ecf.mgmt.framework.host.AbstractManager;
import org.eclipse.ecf.mgmt.framework.startlevel.FrameworkStartLevelMTO;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;

public class FrameworkManager
extends AbstractManager
implements IFrameworkManager {
    private static final long DEFAULT_SETSTARTLEVEL_TIMEOUT = new Long(System.getProperty("org.eclipse.ecf.mgmt.framework.host.defaultSetStartLevelTimeout", "30000"));
    private long setStartLevelTimeout = DEFAULT_SETSTARTLEVEL_TIMEOUT;

    public FrameworkMTO getFramework() {
        return this.createFrameworkMTO();
    }

    public FrameworkStartLevelMTO getStartLevel() {
        return new FrameworkStartLevelMTO((FrameworkStartLevelDTO)this.getBundle0(0L).adapt(FrameworkStartLevelDTO.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus setStartLevel(int startLevel) {
        IStatus iStatus;
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.getBundle0(0L).adapt(FrameworkStartLevel.class);
        ManagerFrameworkListener fl = new ManagerFrameworkListener();
        fsl.setStartLevel(startLevel, new FrameworkListener[]{fl});
        long timeoutTime = System.currentTimeMillis() + this.setStartLevelTimeout;
        ManagerFrameworkListener managerFrameworkListener = fl;
        synchronized (managerFrameworkListener) {
            while (!fl.done && timeoutTime - System.currentTimeMillis() > 0L) {
                try {
                    fl.wait(this.setStartLevelTimeout / 20L);
                }
                catch (InterruptedException e) {
                    fl.status = this.createErrorStatus("setStartLevel interrupted", e);
                    fl.done = true;
                }
            }
        }
        if (fl.done) {
            iStatus = fl.status;
            return iStatus;
        }
        iStatus = this.createErrorStatus("setStartLevel timeout after " + this.setStartLevelTimeout + " ms", new TimeoutException());
        return iStatus;
    }

    public void setInitialBundleStartLevel(int initialBundleStartLevel) {
        ((FrameworkStartLevel)this.getFrameworkBundle().adapt(FrameworkStartLevel.class)).setInitialBundleStartLevel(initialBundleStartLevel);
    }

    class ManagerFrameworkListener
    implements FrameworkListener {
        public boolean done = false;
        public IStatus status;

        ManagerFrameworkListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void frameworkEvent(FrameworkEvent event) {
            ManagerFrameworkListener managerFrameworkListener = this;
            synchronized (managerFrameworkListener) {
                this.status = event.getType() == 2 ? FrameworkManager.this.createErrorStatus("Framework error on setStartLevel", event.getThrowable()) : SerializableStatus.OK_STATUS;
                this.done = true;
            }
        }
    }
}

