/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.host;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.ecf.mgmt.framework.IServiceEventHandlerAsync;
import org.eclipse.ecf.mgmt.framework.IServiceManager;
import org.eclipse.ecf.mgmt.framework.ServiceEventMTO;
import org.eclipse.ecf.mgmt.framework.ServiceReferenceMTO;
import org.eclipse.ecf.mgmt.framework.host.AbstractManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

public class ServiceManager
extends AbstractManager
implements IServiceManager,
RemoteServiceAdminListener {
    private final Function<ServiceReferenceDTO, ServiceReferenceMTO> srmapper = srd -> ServiceReferenceMTO.createMTO((ServiceReferenceDTO)srd, (int)this.getServiceReferenceExportImportState(srd.id));
    protected List<IServiceEventHandlerAsync> sehs = new ArrayList<IServiceEventHandlerAsync>();
    private ServiceListener serviceListener = new ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            ArrayList<IServiceEventHandlerAsync> notify = null;
            List<IServiceEventHandlerAsync> list = ServiceManager.this.sehs;
            synchronized (list) {
                notify = new ArrayList<IServiceEventHandlerAsync>(ServiceManager.this.sehs);
            }
            int eventType = event.getType();
            ServiceReference ref = null;
            ServiceReferenceMTO mto = null;
            for (IServiceEventHandlerAsync beh : notify) {
                if (ref == null) {
                    ref = event.getServiceReference();
                }
                if (mto == null) {
                    mto = ServiceReferenceMTO.createMTO((ServiceReference)ref, (int)ServiceManager.this.getServiceReferenceExportImportState((Long)ref.getProperty("service.id")));
                }
                beh.handleServiceEventAsync(new ServiceEventMTO(eventType, mto));
            }
        }
    };

    public ServiceReferenceMTO[] getServiceReferences() {
        List<ServiceReferenceMTO> results = this.selectAndMap(this.getFrameworkDTO().services, null, this.srmapper);
        return results.toArray(new ServiceReferenceMTO[results.size()]);
    }

    public ServiceReferenceMTO getServiceReference(long serviceId) {
        List<ServiceReferenceMTO> results = this.selectAndMap(this.getFrameworkDTO().services, srd -> srd.id == serviceId, this.srmapper);
        return results.size() > 0 ? results.get(0) : null;
    }

    public ServiceReferenceMTO[] getServiceReferences(long bundleId) {
        List<ServiceReferenceMTO> results = this.selectAndMap(this.getFrameworkDTO().services, srd -> srd.bundle == bundleId, this.srmapper);
        return results.toArray(new ServiceReferenceMTO[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServiceChangedEvent(ServiceEvent event) {
        ArrayList<IServiceEventHandlerAsync> notify = null;
        List<IServiceEventHandlerAsync> list = this.sehs;
        synchronized (list) {
            notify = new ArrayList<IServiceEventHandlerAsync>(this.sehs);
        }
        ServiceReferenceMTO mto = this.getServiceReference((Long)event.getServiceReference().getProperty("service.id"));
        if (mto != null) {
            for (IServiceEventHandlerAsync beh : notify) {
                beh.handleServiceEventAsync(new ServiceEventMTO(event.getType(), mto));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addServiceEventHandler(IServiceEventHandlerAsync async) {
        List<IServiceEventHandlerAsync> list = this.sehs;
        synchronized (list) {
            return this.sehs.add(async);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeServiceEventHandler(IServiceEventHandlerAsync async) {
        List<IServiceEventHandlerAsync> list = this.sehs;
        synchronized (list) {
            return this.sehs.remove(async);
        }
    }

    @Override
    protected void activate(BundleContext context) throws Exception {
        super.activate(context);
        this.getContext().addServiceListener(this.serviceListener);
    }

    @Override
    protected void deactivate() throws Exception {
        this.getContext().removeServiceListener(this.serviceListener);
        super.deactivate();
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        ExportReference eRef = event.getExportReference();
        ServiceReference ref = null;
        if (eRef != null) {
            ref = eRef.getExportedService();
        } else {
            ImportReference iRef = event.getImportReference();
            ref = iRef.getImportedService();
        }
        if (ref != null) {
            this.serviceListener.serviceChanged(new ServiceEvent(2, ref));
        }
    }
}

