/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.IPhase;
import org.eclipse.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerManager;
import org.eclipse.rwt.internal.lifecycle.ProcessAction;
import org.eclipse.rwt.internal.lifecycle.ReadData;
import org.eclipse.rwt.internal.lifecycle.Render;
import org.eclipse.rwt.internal.lifecycle.Scope;
import org.eclipse.rwt.internal.lifecycle.UICallBackManager;
import org.eclipse.rwt.internal.lifecycle.UIThread;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Display;

public class RWTLifeCycle
extends LifeCycle {
    private static final Integer ZERO = new Integer(0);
    private static final String CURRENT_PHASE;
    private static final String PHASE_ORDER;
    private static final String UI_THREAD_THROWABLE;
    private static final String REQUEST_THREAD_RUNNABLE;
    private static final IPhase[] PHASE_ORDER_STARTUP;
    private static final IPhase[] PHASE_ORDER_SUBSEQUENT;
    Runnable uiRunnable;
    private final PhaseListenerManager phaseListenerManager = new PhaseListenerManager(this);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CURRENT_PHASE = String.valueOf(clazz.getName()) + ".currentPhase";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PHASE_ORDER = String.valueOf(clazz2.getName()) + ".phaseOrder";
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle$UIThreadController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        UI_THREAD_THROWABLE = String.valueOf(clazz3.getName()) + "#UIThreadThrowable";
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REQUEST_THREAD_RUNNABLE = String.valueOf(clazz4.getName()) + "#requestThreadRunnable";
        PHASE_ORDER_STARTUP = new IPhase[]{new IPhase.IInterruptible(){

            public PhaseId execute(Display display) throws IOException {
                return null;
            }

            public PhaseId getPhaseId() {
                return PhaseId.PREPARE_UI_ROOT;
            }
        }, new Render()};
        PHASE_ORDER_SUBSEQUENT = new IPhase[]{new IPhase(){

            public PhaseId execute(Display display) throws IOException {
                return null;
            }

            public PhaseId getPhaseId() {
                return PhaseId.PREPARE_UI_ROOT;
            }
        }, new ReadData(), new IPhase.IInterruptible(){

            public PhaseId execute(Display display) throws IOException {
                new ProcessAction().execute(display);
                return null;
            }

            public PhaseId getPhaseId() {
                return PhaseId.PROCESS_ACTION;
            }
        }, new Render()};
    }

    public RWTLifeCycle() {
        this.phaseListenerManager.addPhaseListeners(RWTFactory.getPhaseListenerRegistry().get());
        this.uiRunnable = new UIThreadController();
    }

    public void execute() throws IOException {
        if (RWTLifeCycle.getEntryPoint() != null) {
            this.setPhaseOrder(PHASE_ORDER_STARTUP);
        } else {
            this.setPhaseOrder(PHASE_ORDER_SUBSEQUENT);
        }
        Runnable runnable = null;
        do {
            RWTLifeCycle.setRequestThreadRunnable(null);
            this.executeUIThread();
            runnable = RWTLifeCycle.getRequestThreadRunnable();
            if (runnable == null) continue;
            runnable.run();
        } while (runnable != null);
    }

    public void addPhaseListener(PhaseListener listener) {
        this.phaseListenerManager.addPhaseListener(listener);
    }

    public void removePhaseListener(PhaseListener listener) {
        this.phaseListenerManager.removePhaseListener(listener);
    }

    public Scope getScope() {
        return Scope.APPLICATION;
    }

    public void requestThreadExec(Runnable runnable) {
        RWTLifeCycle.setRequestThreadRunnable(runnable);
        RWTLifeCycle.getUIThreadHolder().switchThread();
    }

    private static void setRequestThreadRunnable(Runnable runnable) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        stateInfo.setAttribute(REQUEST_THREAD_RUNNABLE, runnable);
    }

    private static Runnable getRequestThreadRunnable() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return (Runnable)stateInfo.getAttribute(REQUEST_THREAD_RUNNABLE);
    }

    void continueLifeCycle() {
        int start = 0;
        IPhase[] phaseOrder = this.getPhaseOrder();
        if (phaseOrder != null) {
            Integer currentPhase = RWTLifeCycle.getCurrentPhase();
            if (currentPhase != null) {
                int phaseIndex = currentPhase;
                this.phaseListenerManager.notifyAfterPhase(phaseOrder[phaseIndex].getPhaseId());
                start = currentPhase + 1;
            }
            boolean interrupted = false;
            int i = start;
            while (!interrupted && i < phaseOrder.length) {
                IPhase phase = phaseOrder[i];
                this.phaseListenerManager.notifyBeforePhase(phase.getPhaseId());
                if (phase instanceof IPhase.IInterruptible) {
                    IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
                    stateInfo.setAttribute(CURRENT_PHASE, new Integer(i));
                    interrupted = true;
                } else {
                    try {
                        phase.execute(LifeCycleUtil.getSessionDisplay());
                    }
                    catch (Throwable e) {
                        throw new PhaseExecutionError(e);
                    }
                    this.phaseListenerManager.notifyAfterPhase(phase.getPhaseId());
                }
                ++i;
            }
            if (!interrupted) {
                ContextProvider.getStateInfo().setAttribute(CURRENT_PHASE, null);
            }
        }
    }

    static int createUI() {
        String startup;
        int result = -1;
        if (ZERO.equals(RWTLifeCycle.getCurrentPhase()) && (startup = RWTLifeCycle.getEntryPoint()) != null) {
            result = RWTFactory.getEntryPointManager().createUI(startup);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeUIThread() throws IOException {
        ServiceContext context = ContextProvider.getContext();
        ISessionStore session = ContextProvider.getSession();
        IUIThreadHolder uiThread = RWTLifeCycle.getUIThreadHolder();
        if (uiThread == null) {
            uiThread = this.createUIThread();
            uiThread.setServiceContext(context);
            Object object = uiThread.getLock();
            synchronized (object) {
                uiThread.getThread().start();
                uiThread.switchThread();
            }
        } else {
            uiThread.setServiceContext(context);
            uiThread.switchThread();
        }
        if (!uiThread.getThread().isAlive()) {
            LifeCycleUtil.setUIThread(session, null);
        }
        RWTLifeCycle.handleUIThreadException();
    }

    private static void handleUIThreadException() throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Throwable throwable = (Throwable)stateInfo.getAttribute(UI_THREAD_THROWABLE);
        if (throwable != null) {
            if (throwable instanceof PhaseExecutionError) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public void sleep() {
        this.continueLifeCycle();
        IUIThreadHolder uiThread = RWTLifeCycle.getUIThreadHolder();
        UICallBackManager.getInstance().notifyUIThreadEnd();
        uiThread.switchThread();
        uiThread.updateServiceContext();
        UICallBackManager.getInstance().notifyUIThreadStart();
        this.continueLifeCycle();
    }

    private IUIThreadHolder createUIThread() {
        ISessionStore session = ContextProvider.getSession();
        UIThread result = new UIThread(this.uiRunnable);
        result.getThread().setDaemon(true);
        result.getThread().setName("UIThread [" + session.getId() + "]");
        LifeCycleUtil.setUIThread(session, result);
        RWTLifeCycle.setShutdownAdapter(result);
        return result;
    }

    private static Integer getCurrentPhase() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return (Integer)stateInfo.getAttribute(CURRENT_PHASE);
    }

    private static String getEntryPoint() {
        return LifeCycleUtil.getEntryPoint();
    }

    private static void setShutdownAdapter(ISessionShutdownAdapter adapter) {
        ISessionStore sessionStore = ContextProvider.getSession();
        SessionStoreImpl sessionStoreImpl = (SessionStoreImpl)sessionStore;
        sessionStoreImpl.setShutdownAdapter(adapter);
    }

    public void setPhaseOrder(IPhase[] phaseOrder) {
        IServiceStateInfo stateInfo = ContextProvider.getContext().getStateInfo();
        stateInfo.setAttribute(PHASE_ORDER, phaseOrder);
    }

    IPhase[] getPhaseOrder() {
        IServiceStateInfo stateInfo = ContextProvider.getContext().getStateInfo();
        return (IPhase[])stateInfo.getAttribute(PHASE_ORDER);
    }

    public static IUIThreadHolder getUIThreadHolder() {
        return LifeCycleUtil.getUIThread(ContextProvider.getSession());
    }

    private static final class PhaseExecutionError
    extends ThreadDeath {
        private static final long serialVersionUID = 1L;

        public PhaseExecutionError(Throwable cause) {
            this.initCause(cause);
        }
    }

    private final class UIThreadController
    implements Runnable {
        private UIThreadController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IUIThreadHolder uiThread = (IUIThreadHolder)((Object)Thread.currentThread());
            Object object = uiThread.getLock();
            synchronized (object) {
                try {
                    try {
                        uiThread.updateServiceContext();
                        UICallBackManager.getInstance().notifyUIThreadStart();
                        RWTLifeCycle.this.continueLifeCycle();
                        RWTLifeCycle.createUI();
                        RWTLifeCycle.this.continueLifeCycle();
                        UICallBackManager.getInstance().notifyUIThreadEnd();
                    }
                    catch (UIThread.UIThreadTerminatedError thr) {
                        throw thr;
                    }
                    catch (Throwable thr) {
                        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
                        stateInfo.setAttribute(UI_THREAD_THROWABLE, thr);
                    }
                    uiThread.switchThread();
                }
                catch (UIThread.UIThreadTerminatedError uIThreadTerminatedError) {
                    ((ISessionShutdownAdapter)((Object)uiThread)).processShutdown();
                }
            }
        }
    }
}

