/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;

public final class TextSizeStorage {
    public static final int MIN_STORE_SIZE = 1000;
    public static final int DEFAULT_STORE_SIZE = 10000;
    private final Object lock = new Object();
    private final Set fontDatas;
    private final Map data = new HashMap();
    private int maximumStoreSize;
    private int clearRange;
    private long clock;

    public TextSizeStorage() {
        this.fontDatas = new HashSet();
        this.setMaximumStoreSize(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FontData[] getFontList() {
        FontData[] result;
        Object object = this.lock;
        synchronized (object) {
            result = new FontData[this.fontDatas.size()];
            this.fontDatas.toArray(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeFont(FontData fontData) {
        Object object = this.lock;
        synchronized (object) {
            this.fontDatas.add(fontData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point lookupTextSize(Integer key) {
        Point result = null;
        Object object = this.lock;
        synchronized (object) {
            Entry entry = (Entry)this.data.get(key);
            if (entry != null) {
                this.updateTimestamp(entry);
                result = entry.point;
            }
        }
        result = TextSizeStorage.defensiveCopy(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeTextSize(Integer key, Point size) {
        Entry entry = new Entry();
        entry.point = TextSizeStorage.defensiveCopy(size);
        this.updateTimestamp(entry);
        Object object = this.lock;
        synchronized (object) {
            this.data.put(key, entry);
            this.handleOverFlow();
        }
    }

    void setMaximumStoreSize(int maximumStoreSize) {
        this.checkLowerStoreSizeBoundary(maximumStoreSize);
        this.calculateClearRange(maximumStoreSize);
        this.maximumStoreSize = maximumStoreSize;
    }

    int getMaximumStoreSize() {
        return this.maximumStoreSize;
    }

    private void handleOverFlow() {
        if (this.data.size() >= this.maximumStoreSize) {
            Entry[] entries = this.sortEntries();
            int i = 0;
            while (i < this.clearRange) {
                this.data.values().remove(entries[i]);
                ++i;
            }
        }
    }

    private Entry[] sortEntries() {
        Entry[] result = new Entry[this.data.size()];
        this.data.values().toArray(result);
        Arrays.sort(result, new EntryComparator());
        return result;
    }

    private void checkLowerStoreSizeBoundary(int maximumStoreSize) {
        if (maximumStoreSize < 1000) {
            Object[] param = new Object[]{new Integer(1000)};
            String msg = MessageFormat.format("Store size must be >= {0}.", param);
            throw new IllegalArgumentException(msg);
        }
    }

    private static Point defensiveCopy(Point point) {
        Point result = null;
        if (point != null) {
            result = new Point(point.x, point.y);
        }
        return result;
    }

    private void updateTimestamp(Entry entry) {
        entry.timeStamp = this.clock++;
    }

    private void calculateClearRange(int maximumStoreSize) {
        BigDecimal ten = new BigDecimal(10.0);
        BigDecimal bdStoreSize = new BigDecimal((double)maximumStoreSize);
        this.clearRange = bdStoreSize.divide(ten, 0, 4).intValue();
    }

    private static class Entry {
        private Point point;
        private long timeStamp;

        private Entry() {
        }
    }

    private static class EntryComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EntryComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Entry entry1 = (Entry)obj1;
            Entry entry2 = (Entry)obj2;
            int result = 0;
            if (entry1.timeStamp > entry2.timeStamp) {
                result = 1;
            } else if (entry1.timeStamp < entry2.timeStamp) {
                result = -1;
            }
            return result;
        }
    }
}

