/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.List;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.MenuHolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

public class WidgetTreeVisitor {
    static /* synthetic */ Class class$0;

    public static void accept(Widget root, WidgetTreeVisitor visitor) {
        if (root instanceof Composite) {
            Composite composite = (Composite)root;
            if (visitor.visit(composite)) {
                WidgetTreeVisitor.handleMenus(composite, visitor);
                WidgetTreeVisitor.handleDragDrop(root, visitor);
                WidgetTreeVisitor.handleDecorator(root, visitor);
                WidgetTreeVisitor.handleItems(root, visitor);
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    WidgetTreeVisitor.accept(children[i], visitor);
                    ++i;
                }
                WidgetTreeVisitor.handleToolTips(root, visitor);
            }
        } else if (ItemHolder.isItemHolder(root)) {
            if (visitor.visit(root)) {
                WidgetTreeVisitor.handleDragDrop(root, visitor);
                WidgetTreeVisitor.handleDecorator(root, visitor);
                WidgetTreeVisitor.handleItems(root, visitor);
            }
        } else if (visitor.visit(root)) {
            WidgetTreeVisitor.handleDragDrop(root, visitor);
            WidgetTreeVisitor.handleDecorator(root, visitor);
        }
    }

    public boolean visit(Widget widget) {
        return true;
    }

    public boolean visit(Composite composite) {
        return true;
    }

    private static void handleDragDrop(Widget widget, WidgetTreeVisitor visitor) {
        if (widget instanceof Control) {
            Widget dropTarget;
            Widget dragSource = (Widget)widget.getData("DragSource");
            if (dragSource != null) {
                visitor.visit(dragSource);
            }
            if ((dropTarget = (Widget)widget.getData("DropTarget")) != null) {
                visitor.visit(dropTarget);
            }
        }
    }

    private static void handleMenus(Composite composite, WidgetTreeVisitor visitor) {
        if (MenuHolder.isMenuHolder(composite)) {
            Menu[] menus = MenuHolder.getMenus(composite);
            int i = 0;
            while (i < menus.length) {
                WidgetTreeVisitor.accept(menus[i], visitor);
                ++i;
            }
        }
    }

    private static void handleItems(Widget root, WidgetTreeVisitor visitor) {
        if (ItemHolder.isItemHolder(root)) {
            Item[] items = ItemHolder.getItems(root);
            int i = 0;
            while (i < items.length) {
                WidgetTreeVisitor.accept(items[i], visitor);
                ++i;
            }
        }
    }

    private static void handleDecorator(Widget root, WidgetTreeVisitor visitor) {
        List decorations = (List)root.getData("decorations");
        if (decorations != null) {
            Widget[] widgets = new Widget[decorations.size()];
            decorations.toArray(widgets);
            int i = 0;
            while (i < widgets.length) {
                visitor.visit(widgets[i]);
                ++i;
            }
        }
    }

    private static void handleToolTips(Widget root, WidgetTreeVisitor visitor) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IShellAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = root.getAdapter(clazz)) != null) {
            IShellAdapter shellAdapter = (IShellAdapter)adapter;
            ToolTip[] toolTips = shellAdapter.getToolTips();
            int i = 0;
            while (i < toolTips.length) {
                visitor.visit(toolTips[i]);
                ++i;
            }
        }
    }

    public static abstract class AllWidgetTreeVisitor
    extends WidgetTreeVisitor {
        public final boolean visit(Widget widget) {
            return this.doVisit(widget);
        }

        public final boolean visit(Composite composite) {
            return this.doVisit(composite);
        }

        public abstract boolean doVisit(Widget var1);
    }
}

