/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.LoginDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DialogsTab
extends ExampleTab {
    private Label inputDlgResLabel;
    private Label loginDlgResLabel;
    private Label messageDlgResLabel;
    private Label errorDlgResLabel;
    private Label messageBoxDlgResLabel;
    private Button okButton;
    private Button cancelButton;
    private Button yesButton;
    private Button noButton;
    private Button retryButton;
    private Button abortButton;
    private Button ignoreButton;
    private Button iconErrorButton;
    private Button iconInformationButton;
    private Button iconQuestionButton;
    private Button iconWarningButton;
    private Button iconWorkingButton;
    private Button noIconButton;
    private Button showMessageBoxDlgButton;
    private Button showColorDialogButton;
    private Button showFontDialogButton;

    public DialogsTab(CTabFolder topFolder) {
        super(topFolder, "Dialogs");
    }

    protected void createStyleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createMessageBoxStyleControls(parent);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Group group1 = new Group(parent, 0);
        group1.setLayoutData((Object)new GridData(768));
        group1.setText("JFace Dialogs");
        group1.setLayout((Layout)new GridLayout(3, true));
        Button showInputDlgButton = new Button((Composite)group1, 8);
        showInputDlgButton.setText("Input Dialog");
        showInputDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showInputDialog();
            }
        });
        showInputDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        Button showProgressDlgButton = new Button((Composite)group1, 8);
        showProgressDlgButton.setText("ProgressDialog");
        showProgressDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        showProgressDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogsTab.this.showProgressDialog();
            }
        });
        this.insertSpaceLabels(group1, 1);
        this.inputDlgResLabel = new Label((Composite)group1, 64);
        this.inputDlgResLabel.setText("Result:");
        GridData gdInputDlgResLabel = new GridData();
        gdInputDlgResLabel.horizontalSpan = 3;
        this.inputDlgResLabel.setLayoutData((Object)gdInputDlgResLabel);
        Button showMessageInfoDlgButton = new Button((Composite)group1, 8);
        showMessageInfoDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        showMessageInfoDlgButton.setText("Info Message");
        showMessageInfoDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showMessageDialogInfo();
            }
        });
        Button showMessageWarningDlgButton = new Button((Composite)group1, 8);
        showMessageWarningDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        showMessageWarningDlgButton.setText("Warning Dialog");
        showMessageWarningDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showMessageDialogWarning();
            }
        });
        Button showMessageErrorDlgButton = new Button((Composite)group1, 8);
        showMessageErrorDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        showMessageErrorDlgButton.setText("Error Message");
        showMessageErrorDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showMessageDialogError();
            }
        });
        Button showMessageQuestionDlgButton = new Button((Composite)group1, 8);
        showMessageQuestionDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        showMessageQuestionDlgButton.setText("Question Dialog");
        showMessageQuestionDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showMessageDialogQuestion();
            }
        });
        Button showMessageConfirmDlgButton = new Button((Composite)group1, 8);
        showMessageConfirmDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        showMessageConfirmDlgButton.setText("Confirm Message");
        showMessageConfirmDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showMessageDialogConfirm();
            }
        });
        this.insertSpaceLabels(group1, 1);
        this.messageDlgResLabel = new Label((Composite)group1, 64);
        this.messageDlgResLabel.setText("Result:");
        this.insertSpaceLabels(group1, 2);
        Button showErrorDlgButton = new Button((Composite)group1, 8);
        showErrorDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        showErrorDlgButton.setText("Error Dialog");
        showErrorDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showErrorDialog();
            }
        });
        this.insertSpaceLabels(group1, 2);
        this.errorDlgResLabel = new Label((Composite)group1, 64);
        this.errorDlgResLabel.setText("Result:");
        this.insertSpaceLabels(group1, 2);
        Group group2 = new Group(parent, 0);
        group2.setLayoutData((Object)new GridData(768));
        group2.setText("Custom Dialogs");
        group2.setLayout((Layout)new GridLayout(3, true));
        Button showLoginDlgButton = new Button((Composite)group2, 8);
        showLoginDlgButton.setText("Login Dialog");
        showLoginDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showLoginDialog();
            }
        });
        showLoginDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        this.insertSpaceLabels(group2, 2);
        this.loginDlgResLabel = new Label((Composite)group2, 64);
        this.loginDlgResLabel.setText("Result:");
        Group swtDialogsGroup = new Group(parent, 0);
        swtDialogsGroup.setLayoutData((Object)new GridData(768));
        swtDialogsGroup.setText("SWT Dialogs");
        swtDialogsGroup.setLayout((Layout)new GridLayout(3, true));
        this.showMessageBoxDlgButton = new Button((Composite)swtDialogsGroup, 8);
        this.showMessageBoxDlgButton.setText("MessageBox Dialog");
        this.showMessageBoxDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogsTab.this.showMessageBoxDialog();
            }
        });
        this.showMessageBoxDlgButton.setLayoutData((Object)this.createGridDataFillBoth());
        this.showColorDialogButton = new Button((Composite)swtDialogsGroup, 8);
        this.showColorDialogButton.setText("ColorDialog");
        this.showColorDialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogsTab.this.showColorDialog();
            }
        });
        this.showColorDialogButton.setLayoutData((Object)this.createGridDataFillBoth());
        this.showFontDialogButton = new Button((Composite)swtDialogsGroup, 8);
        this.showFontDialogButton.setText("FontDialog");
        this.showFontDialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogsTab.this.showFontDialog();
            }
        });
        this.showFontDialogButton.setLayoutData((Object)this.createGridDataFillBoth());
        this.messageBoxDlgResLabel = new Label((Composite)swtDialogsGroup, 64);
        this.messageBoxDlgResLabel.setText("Result:");
        GridData gdMessageBoxDlgResLabel = new GridData();
        gdMessageBoxDlgResLabel.horizontalSpan = 3;
        this.messageBoxDlgResLabel.setLayoutData((Object)gdMessageBoxDlgResLabel);
    }

    private GridData createGridDataFillBoth() {
        return new GridData(1808);
    }

    private void insertSpaceLabels(Group group, int count) {
        int i = 0;
        while (i < count) {
            new Label((Composite)group, 0);
            ++i;
        }
    }

    private void showInputDialog() {
        IInputValidator val = new IInputValidator(){

            public String isValid(String newText) {
                String result = null;
                if (newText.length() < 5) {
                    result = "Input text too short!";
                }
                return result;
            }
        };
        String title = "Input Dialog";
        String mesg = "Enter at least five characters";
        String def = "default text";
        InputDialog dlg = new InputDialog(this.getShell(), title, mesg, def, val);
        int returnCode = dlg.open();
        String resultText = "Result: " + this.getReturnCodeText(returnCode);
        if (returnCode == 0) {
            resultText = String.valueOf(resultText) + ", value: " + dlg.getValue();
        }
        this.inputDlgResLabel.setText(resultText);
        this.inputDlgResLabel.pack();
    }

    private void showProgressDialog() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Counting from one to 20...", 20);
                    int i = 1;
                    while (!monitor.isCanceled() && i <= 20) {
                        monitor.worked(1);
                        Thread.sleep(1000L);
                        ++i;
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
        }
    }

    private void showMessageDialogInfo() {
        String title = "Information";
        String mesg = "RAP rocks!";
        MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)mesg);
        this.messageDlgResLabel.setText("Result: none");
        this.messageDlgResLabel.pack();
    }

    private void showMessageDialogError() {
        String title = "Error";
        String mesg = "An everyday error occured.\n Nothing to get worried.";
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)mesg);
        this.messageDlgResLabel.setText("Result: none");
        this.messageDlgResLabel.pack();
    }

    private void showMessageDialogQuestion() {
        String title = "Question";
        String mesg = "Do you like the RAP technology?\n\nNote that you can also press <Return> here. The correct answer is automatically selected.";
        boolean result = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)mesg);
        this.messageDlgResLabel.setText("Result: " + result);
        this.messageDlgResLabel.pack();
    }

    private void showMessageDialogConfirm() {
        String title = "Confirmation";
        String mesg = "Nothing will be done. Ok?";
        boolean result = MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)mesg);
        this.messageDlgResLabel.setText("Result: " + result);
        this.messageDlgResLabel.pack();
    }

    private void showMessageDialogWarning() {
        String title = "Warning";
        String mesg = "You have been warned.";
        MessageDialog.openWarning((Shell)this.getShell(), (String)title, (String)mesg);
        this.messageDlgResLabel.setText("Result: none");
        this.messageDlgResLabel.pack();
    }

    private void showErrorDialog() {
        String title = "Error";
        int code = 23;
        String mesg = "An absolutetly weird error occured";
        String reason = "Don't know, it just happened ...";
        RuntimeException exception = new IndexOutOfBoundsException("negative index: -1");
        exception = new RuntimeException(exception);
        Status status = new Status(4, "org.eclipse.rap.demo", code, reason, (Throwable)exception);
        int returnCode = ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)mesg, (IStatus)status);
        this.errorDlgResLabel.setText("Result: " + this.getReturnCodeText(returnCode));
        this.errorDlgResLabel.pack();
    }

    private void showLoginDialog() {
        String message = "Please sign in with your username and password:";
        LoginDialog loginDialog = new LoginDialog(this.getShell(), "Login", message);
        loginDialog.setUsername("john");
        int returnCode = loginDialog.open();
        String resultText = "Result: " + this.getReturnCodeText(returnCode);
        if (returnCode == 0) {
            String username = loginDialog.getUsername();
            String password = loginDialog.getPassword();
            String pwInfo = password == null ? "n/a" : String.valueOf(password.length()) + " chars";
            resultText = String.valueOf(resultText) + ", user: " + username + ", password: " + pwInfo;
        }
        this.loginDlgResLabel.setText(resultText);
        this.loginDlgResLabel.pack();
    }

    private String getReturnCodeText(int code) {
        String result = code == 0 ? "OK" : (code == 1 ? "CANCEL" : String.valueOf(code));
        return result;
    }

    private void showMessageBoxDialog() {
        int style = this.getStyle();
        if (this.okButton.getEnabled() && this.okButton.getSelection()) {
            style |= 0x20;
        }
        if (this.cancelButton.getEnabled() && this.cancelButton.getSelection()) {
            style |= 0x100;
        }
        if (this.yesButton.getEnabled() && this.yesButton.getSelection()) {
            style |= 0x40;
        }
        if (this.noButton.getEnabled() && this.noButton.getSelection()) {
            style |= 0x80;
        }
        if (this.retryButton.getEnabled() && this.retryButton.getSelection()) {
            style |= 0x400;
        }
        if (this.abortButton.getEnabled() && this.abortButton.getSelection()) {
            style |= 0x200;
        }
        if (this.ignoreButton.getEnabled() && this.ignoreButton.getSelection()) {
            style |= 0x800;
        }
        if (this.iconErrorButton.getEnabled() && this.iconErrorButton.getSelection()) {
            style |= 1;
        }
        if (this.iconInformationButton.getEnabled() && this.iconInformationButton.getSelection()) {
            style |= 2;
        }
        if (this.iconQuestionButton.getEnabled() && this.iconQuestionButton.getSelection()) {
            style |= 4;
        }
        if (this.iconWarningButton.getEnabled() && this.iconWarningButton.getSelection()) {
            style |= 8;
        }
        if (this.iconWorkingButton.getEnabled() && this.iconWorkingButton.getSelection()) {
            style |= 0x10;
        }
        String title = "MessageBox Title";
        String mesg = "Lorem ipsum dolor sit amet consectetuer adipiscing elit.";
        MessageBox mb = new MessageBox(this.getShell(), style);
        mb.setText(title);
        mb.setMessage(mesg);
        int result = mb.open();
        String strResult = "";
        switch (result) {
            case 32: {
                strResult = "SWT.OK";
                break;
            }
            case 64: {
                strResult = "SWT.YES";
                break;
            }
            case 128: {
                strResult = "SWT.NO";
                break;
            }
            case 256: {
                strResult = "SWT.CANCEL";
                break;
            }
            case 512: {
                strResult = "SWT.ABORT";
                break;
            }
            case 1024: {
                strResult = "SWT.RETRY";
                break;
            }
            case 2048: {
                strResult = "SWT.IGNORE";
                break;
            }
            default: {
                strResult = "" + result;
            }
        }
        this.messageBoxDlgResLabel.setText("Result: " + strResult);
        this.messageBoxDlgResLabel.pack();
    }

    private void showColorDialog() {
        ColorDialog dialog = new ColorDialog(this.getShell());
        RGB result = dialog.open();
        this.messageBoxDlgResLabel.setText("Result: " + result);
        this.messageBoxDlgResLabel.pack();
    }

    protected void showFontDialog() {
        FontDialog dialog = new FontDialog(this.getShell(), 1264);
        FontData result = dialog.open();
        this.messageBoxDlgResLabel.setText("Result: " + result + " / " + dialog.getRGB());
        this.messageBoxDlgResLabel.pack();
    }

    private void createMessageBoxStyleControls(Composite parent) {
        this.createButtonStyleGroup(parent);
        this.createIconStyleGroup(parent);
    }

    private void createButtonStyleGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 4, false, false);
        group.setLayoutData((Object)layoutData);
        group.setText("SWT MessageBox Styles");
        this.okButton = new Button((Composite)group, 32);
        this.okButton.setText("SWT.OK");
        this.cancelButton = new Button((Composite)group, 32);
        this.cancelButton.setText("SWT.CANCEL");
        this.yesButton = new Button((Composite)group, 32);
        this.yesButton.setText("SWT.YES");
        this.noButton = new Button((Composite)group, 32);
        this.noButton.setText("SWT.NO");
        this.retryButton = new Button((Composite)group, 32);
        this.retryButton.setText("SWT.RETRY");
        this.abortButton = new Button((Composite)group, 32);
        this.abortButton.setText("SWT.ABORT");
        this.ignoreButton = new Button((Composite)group, 32);
        this.ignoreButton.setText("SWT.IGNORE");
    }

    private void createIconStyleGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData iconGroupData = new GridData(4, 4, false, false);
        group.setLayoutData((Object)iconGroupData);
        group.setText("SWT MessageBox Icon Styles");
        this.iconErrorButton = new Button((Composite)group, 16);
        this.iconErrorButton.setText("SWT.ICON_ERROR");
        this.iconInformationButton = new Button((Composite)group, 16);
        this.iconInformationButton.setText("SWT.ICON_INFORMATION");
        this.iconQuestionButton = new Button((Composite)group, 16);
        this.iconQuestionButton.setText("SWT.ICON_QUESTION");
        this.iconWarningButton = new Button((Composite)group, 16);
        this.iconWarningButton.setText("SWT.ICON_WARNING");
        this.iconWorkingButton = new Button((Composite)group, 16);
        this.iconWorkingButton.setText("SWT.ICON_WORKING");
        this.noIconButton = new Button((Composite)group, 16);
        this.noIconButton.setText("No Icon");
        this.noIconButton.setSelection(true);
    }
}

