/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.interactiondesign;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rap.ui.interactiondesign.ConfigurableStack;
import org.eclipse.rap.ui.interactiondesign.IConfigurationChangeListener;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public abstract class ConfigurationAction
extends Action {
    private IStackPresentationSite site;
    private StackPresentation stackPresentation;
    private List configurationChangeListeners = new ArrayList();
    private boolean allActionsVisible = ConfigurationAction.allActionsVisible();

    public static final String getActionIdFromToolItem(ToolItem item) {
        String result = "";
        Object data = item.getData();
        ActionContributionItem toolBarAction = (ActionContributionItem)data;
        result = toolBarAction.getId();
        return result;
    }

    public static boolean allActionsVisible() {
        boolean result = false;
        AbstractBranding branding = BrandingUtil.determineBranding();
        if (branding != null) {
            String brandingId = branding.getId();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint brandingPoint = registry.getExtensionPoint("org.eclipse.rap.ui.branding");
            if (brandingPoint != null) {
                IConfigurationElement[] elements = brandingPoint.getConfigurationElements();
                boolean found = false;
                int i = 0;
                while (i < elements.length && !found) {
                    String tempId = elements[i].getAttribute("id");
                    if (tempId.equals(brandingId)) {
                        String visibility;
                        found = true;
                        IConfigurationElement[] factory = elements[i].getChildren("presentationFactory");
                        if (factory.length > 0 && (visibility = factory[0].getAttribute("viewActionsVisible")) != null && Boolean.valueOf(visibility).booleanValue()) {
                            result = true;
                        }
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public void addConfigurationChangeListener(IConfigurationChangeListener listener) {
        this.configurationChangeListeners.add(listener);
    }

    public void fireLayoutChange(String newId) {
        int i = 0;
        while (i < this.configurationChangeListeners.size()) {
            IConfigurationChangeListener listener = (IConfigurationChangeListener)this.configurationChangeListeners.get(i);
            listener.presentationChanged(newId);
            ++i;
        }
    }

    public void fireToolBarChange() {
        int i = 0;
        while (i < this.configurationChangeListeners.size()) {
            IConfigurationChangeListener listener = (IConfigurationChangeListener)this.configurationChangeListeners.get(i);
            listener.toolBarChanged();
            ++i;
        }
    }

    private String getActionIdentifier(String viewId, String actionId) {
        return "stackPresentationId/" + viewId + "/" + actionId;
    }

    private String getPartMenuIdentifier(String paneId) {
        return "stackPresentationId/" + paneId + "/partMenu";
    }

    public IStackPresentationSite getSite() {
        return this.site;
    }

    public StackPresentation getStackPresentation() {
        return this.stackPresentation;
    }

    public boolean hasPartMenu() {
        boolean result = false;
        IPresentablePart selectedPart = this.site.getSelectedPart();
        if (selectedPart instanceof PresentablePart) {
            PresentablePart part = (PresentablePart)selectedPart;
            result = part.getPane().hasViewMenu();
        }
        return result;
    }

    public void init(IStackPresentationSite site, StackPresentation stackPresentation) {
        this.site = site;
        this.stackPresentation = stackPresentation;
    }

    public boolean isPartMenuVisible() {
        boolean result = true;
        if (!this.allActionsVisible && this.stackPresentation instanceof ConfigurableStack) {
            ConfigurableStack configStack = (ConfigurableStack)this.stackPresentation;
            String paneId = configStack.getPaneId(this.site);
            String identifier = this.getPartMenuIdentifier(paneId);
            result = this.loadPartmenuVisibility(identifier);
        }
        return result;
    }

    private boolean loadPartmenuVisibility(String identifier) {
        boolean result = false;
        IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
        result = preferenceStore.getBoolean(identifier);
        return result;
    }

    public boolean isViewActionVisibile(String viewId, String actionId) {
        boolean result = true;
        if (!this.allActionsVisible) {
            String identifier = this.getActionIdentifier(viewId, actionId);
            ScopedPreferenceStore prefStore = (ScopedPreferenceStore)PrefUtil.getAPIPreferenceStore();
            result = prefStore.getBoolean(identifier);
        }
        return result;
    }

    public void removeLayoutChangeListener(IConfigurationChangeListener listener) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.configurationChangeListeners.size()) {
            IConfigurationChangeListener current = (IConfigurationChangeListener)this.configurationChangeListeners.get(i);
            if (current.equals(listener)) {
                this.configurationChangeListeners.remove(i);
                found = true;
            }
            ++i;
        }
    }

    public void savePartMenuVisibility(boolean visible) {
        IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
        if (this.stackPresentation instanceof ConfigurableStack) {
            ConfigurableStack configStack = (ConfigurableStack)this.stackPresentation;
            String paneId = configStack.getPaneId(this.site);
            String identifier = this.getPartMenuIdentifier(paneId);
            preferenceStore.setValue(identifier, visible);
        }
    }

    public void saveStackPresentationId(String id) {
        if (this.stackPresentation instanceof ConfigurableStack) {
            String layoutPartId = ConfigurableStack.getLayoutPartId(this.site);
            if (this.site != null && layoutPartId != null) {
                ScopedPreferenceStore prefStore = (ScopedPreferenceStore)PrefUtil.getAPIPreferenceStore();
                prefStore.setValue("stackPresentationId/" + layoutPartId, id);
            }
        }
    }

    public void saveViewActionVisibility(String viewId, String actionId, boolean visibility) {
        String identifier = this.getActionIdentifier(viewId, actionId);
        ScopedPreferenceStore prefStore = (ScopedPreferenceStore)PrefUtil.getAPIPreferenceStore();
        prefStore.setValue(identifier, visibility);
    }
}

