/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.interactiondesign.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.ui.interactiondesign.ConfigurableStack;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.presentations.NativeStackPresentation;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IPresentationSerializer;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class ConfigurableStackProxy
extends StackPresentation {
    public static final String STACK_PRESENTATION_ID = "stackPresentationId";
    private IConfigurationElement brandingElement;
    private String currentId;
    private StackPresentation currentStackPresentation;
    private NativeStackPresentation nativeStackPresentation;
    private Composite parent;
    private boolean showTitle = false;
    private IStackPresentationSite site;
    private String type;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConfigurableStackProxy(Composite parent, IStackPresentationSite stackSite, String type) {
        super(stackSite);
        this.parent = parent;
        this.site = stackSite;
        this.type = type;
        this.currentId = "";
        this.nativeStackPresentation = new NativeStackPresentation(parent, stackSite);
        this.currentStackPresentation = this.loadStackPresentations(this.type, this.site, this.parent);
        if (this.currentStackPresentation == null) {
            this.currentStackPresentation = this.nativeStackPresentation;
        }
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
        StackPresentation delegate = this.getDelegate();
        if (delegate instanceof ConfigurableStack) {
            IAdaptable adaptable = this.getConfigAdaptable();
            if (newPart instanceof PresentablePart) {
                PresentablePart part = (PresentablePart)newPart;
                part.setConfigurationAdaptable(adaptable);
            }
        }
        delegate.addPart(newPart, cookie);
    }

    private boolean brandingPresentationFactoryExists() {
        boolean result = false;
        String id = this.getBrandingPresentationFactoryId();
        if (id != null) {
            result = true;
        }
        return result;
    }

    public Point computeMinimumSize() {
        return this.getDelegate().computeMinimumSize();
    }

    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
        return this.getDelegate().computePreferredSize(width, availableParallel, availablePerpendicular, preferredResult);
    }

    private ConfigurableStack createStackById(String stackId) {
        String stackPresentationExtId;
        ConfigurableStack result = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(stackPresentationExtId = "org.eclipse.rap.ui.stackPresentations");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            boolean found = false;
            int i = 0;
            while (i < elements.length && !found) {
                String id = elements[i].getAttribute("id");
                if (id.equals(stackId)) {
                    found = true;
                    try {
                        Object obj = elements[i].createExecutableExtension("class");
                        result = (ConfigurableStack)obj;
                        result.init(this.site, id, this.parent, this);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        return result;
    }

    public void dispose() {
        this.getDelegate().dispose();
    }

    private IConfigurationElement getBrandingElement() {
        AbstractBranding branding;
        if (this.brandingElement == null && (branding = BrandingUtil.determineBranding()) != null) {
            String id;
            String brandingId = branding.getId();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint brandingPoint = registry.getExtensionPoint(id = "org.eclipse.rap.ui.branding");
            if (brandingPoint != null) {
                IConfigurationElement[] elements = brandingPoint.getConfigurationElements();
                boolean found = false;
                int i = 0;
                while (i < elements.length && !found) {
                    String tempId = elements[i].getAttribute("id");
                    if (tempId.equals(brandingId)) {
                        found = true;
                        this.brandingElement = elements[i];
                    }
                    ++i;
                }
            }
        }
        return this.brandingElement;
    }

    private String getBrandingPresentationFactoryId() {
        return this.loadBrandingPresentationFactoryId(this.getBrandingElement());
    }

    private IAdaptable getConfigAdaptable() {
        IAdaptable adaptable = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                Object result = null;
                if (ConfigurableStackProxy.this.currentStackPresentation instanceof ConfigurableStack) {
                    ConfigurableStack stackPresentation = (ConfigurableStack)ConfigurableStackProxy.this.currentStackPresentation;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.swt.widgets.ToolBar");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (adapter == clazz) {
                        result = stackPresentation.createPartToolBar();
                    } else {
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.eclipse.ui.presentations.IPartMenu");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (adapter == clazz2) {
                            result = stackPresentation.createViewMenu();
                        }
                    }
                }
                return result;
            }
        };
        return adaptable;
    }

    public Control getControl() {
        return this.getDelegate().getControl();
    }

    public ConfigurableStack getCurrentStackPresentation() {
        ConfigurableStack result = null;
        if (this.currentStackPresentation instanceof ConfigurableStack) {
            result = (ConfigurableStack)this.currentStackPresentation;
        }
        return result;
    }

    private StackPresentation getDelegate() {
        StackPresentation result = this.currentStackPresentation != null ? this.currentStackPresentation : this.nativeStackPresentation;
        return result;
    }

    public boolean getShowTitle() {
        return this.showTitle;
    }

    public int getSizeFlags(boolean width) {
        return this.getDelegate().getSizeFlags(width);
    }

    public Control[] getTabList(IPresentablePart part) {
        return this.getDelegate().getTabList(part);
    }

    public String getType() {
        return this.type;
    }

    private String loadBrandingPresentationFactoryId(IConfigurationElement element) {
        IConfigurationElement[] factory;
        String result = null;
        if (element != null && (factory = element.getChildren("presentationFactory")).length > 0) {
            result = factory[0].getAttribute("id");
        }
        return result;
    }

    private ConfigurableStack loadDefaultPartStack() {
        IConfigurationElement[] stacks;
        ConfigurableStack result = null;
        IConfigurationElement element = this.getBrandingElement();
        IConfigurationElement[] factory = element.getChildren("presentationFactory");
        if (factory.length > 0 && (stacks = factory[0].getChildren("defaultStackPresentation")).length > 0) {
            String id = stacks[0].getAttribute("id");
            result = this.createStackById(id);
        }
        return result;
    }

    private ConfigurableStack loadLayoutPartStack() {
        IConfigurationElement[] stacks;
        ConfigurableStack result = null;
        IConfigurationElement element = this.getBrandingElement();
        IConfigurationElement[] factory = element.getChildren("presentationFactory");
        if (factory.length > 0 && (stacks = factory[0].getChildren("stackPresentation")).length > 0) {
            String layoutPartId = ConfigurableStack.getLayoutPartId(this.site);
            boolean found = false;
            int i = 0;
            while (i < stacks.length && !found) {
                String partId = stacks[i].getAttribute("partId");
                if (partId.equals(layoutPartId)) {
                    String stackId = stacks[i].getAttribute("id");
                    result = this.createStackById(stackId);
                    found = true;
                }
                ++i;
            }
        }
        return result;
    }

    private ConfigurableStack loadStackFromBranding() {
        ConfigurableStack result = this.loadLayoutPartStack();
        if (result == null) {
            result = this.loadDefaultPartStack();
        }
        return result;
    }

    private ConfigurableStack loadStackPresentations(String type, IStackPresentationSite site, Composite parent) {
        String stackPresentationExtId;
        this.parent = parent;
        ConfigurableStack result = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(stackPresentationExtId = "org.eclipse.rap.ui.stackPresentations");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            String savedStackId = ConfigurableStack.getSavedStackId(site);
            boolean error = false;
            boolean found = false;
            int i = 0;
            while (!error && !found && i < elements.length) {
                String id = elements[i].getAttribute("id");
                String presentationType = elements[i].getAttribute("type");
                if (savedStackId.equals("")) {
                    if (this.brandingPresentationFactoryExists()) {
                        ConfigurableStack tempStack = this.loadStackFromBranding();
                        if (tempStack != null) {
                            result = tempStack;
                            this.currentId = id;
                        } else {
                            result = null;
                        }
                        found = true;
                    } else {
                        result = null;
                        found = true;
                    }
                } else if (id.equals(savedStackId) && presentationType.equals(type)) {
                    result = this.createStackById(id);
                    this.currentId = id;
                    found = true;
                }
                ++i;
            }
        }
        return result;
    }

    public void movePart(IPresentablePart toMove, Object cookie) {
        this.getDelegate().movePart(toMove, cookie);
    }

    public void refreshStack() {
        if (!this.currentId.equals("")) {
            this.setCurrentStackPresentation(this.currentId);
        }
    }

    public void removePart(IPresentablePart oldPart) {
        this.getDelegate().removePart(oldPart);
    }

    public void restoreState(IPresentationSerializer context, IMemento memento) {
        this.getDelegate().restoreState(context, memento);
    }

    public void saveState(IPresentationSerializer context, IMemento memento) {
        this.getDelegate().saveState(context, memento);
    }

    public void selectPart(IPresentablePart toSelect) {
        this.getDelegate().selectPart(toSelect);
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        return null;
    }

    public void setActive(int newState) {
        this.getDelegate().setActive(newState);
    }

    public void setBounds(Rectangle bounds) {
        this.getDelegate().setBounds(bounds);
    }

    public void setCurrentStackPresentation(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        String stackPresentationExtId = "org.eclipse.rap.ui.stackPresentations";
        IExtensionPoint point = registry.getExtensionPoint(stackPresentationExtId);
        IConfigurationElement[] elements = point.getConfigurationElements();
        Object stackObj = null;
        int i = 0;
        while (stackObj == null && i < elements.length) {
            String attributeId = elements[i].getAttribute("id");
            if (attributeId.equals(id)) {
                this.currentId = id;
                try {
                    Rectangle bounds = this.currentStackPresentation.getControl().getBounds();
                    stackObj = elements[i].createExecutableExtension("class");
                    if (stackObj instanceof ConfigurableStack) {
                        ConfigurableStack newStackPresentation = (ConfigurableStack)stackObj;
                        newStackPresentation.init(this.site, id, this.parent, this);
                        Control control = this.currentStackPresentation.getControl();
                        control.dispose();
                        IPresentablePart[] parts = this.site.getPartList();
                        int j = 0;
                        while (j < parts.length) {
                            newStackPresentation.addPart(parts[j], null);
                            this.currentStackPresentation.removePart(parts[j]);
                            ++j;
                        }
                        newStackPresentation.selectPart(this.site.getSelectedPart());
                        this.currentStackPresentation.getControl().dispose();
                        this.currentStackPresentation.dispose();
                        this.currentStackPresentation = newStackPresentation;
                        this.currentStackPresentation.setBounds(bounds);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public void setState(int state) {
        this.getDelegate().setState(state);
    }

    public void setVisible(boolean isVisible) {
        this.getDelegate().setVisible(isVisible);
    }

    public void showPaneMenu() {
        this.getDelegate().showPaneMenu();
    }

    public void showPartList() {
        this.getDelegate().showPartList();
    }

    public void showSystemMenu() {
        this.getDelegate().showSystemMenu();
    }
}

