/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.interactiondesign.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.rap.ui.interactiondesign.layout.model.ILayoutSetInitializer;
import org.eclipse.rap.ui.interactiondesign.layout.model.Layout;
import org.eclipse.rap.ui.interactiondesign.layout.model.LayoutSet;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.ui.internal.util.PrefUtil;

public class LayoutRegistry {
    public static final String DEFAULT_LAYOUT_ID = "org.eclipse.rap.ui.defaultlayout";
    private static final String LAYOUT_EXT_ID = "org.eclipse.rap.ui.layouts";
    public static final String SAVED_LAYOUT_KEY = "org.eclipse.rap.ui.layouts.saved";
    private static Map layoutMap;
    private static Map layoutSetToPluginId;
    private static List overridenLayoutSets;
    private String activeLayoutId = "org.eclipse.rap.ui.defaultlayout";
    private Layout activeLayout;
    private List builders = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        LayoutRegistry.init();
    }

    private LayoutRegistry() {
    }

    public static LayoutRegistry getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rap.ui.interactiondesign.layout.LayoutRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object result = SessionSingletonBase.getInstance((Class)clazz);
        return (LayoutRegistry)result;
    }

    public void saveLayoutId(String id) {
        IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
        preferenceStore.putValue(SAVED_LAYOUT_KEY, id);
        preferenceStore.firePropertyChangeEvent(SAVED_LAYOUT_KEY, (Object)"", (Object)id);
    }

    public void setActiveLayout(String id, boolean save) {
        Object object = layoutMap.get(id);
        Layout newActive = (Layout)object;
        if (newActive != null) {
            this.activeLayoutId = id;
            this.activeLayout = newActive;
            if (save) {
                this.saveLayoutId(this.activeLayoutId);
            }
        }
    }

    public void disposeBuilders() {
        int i = 0;
        while (i < this.builders.size()) {
            ElementBuilder builder = (ElementBuilder)this.builders.get(i);
            builder.dispose();
            ++i;
        }
    }

    public Layout getActiveLayout() {
        Layout result = this.activeLayout;
        if (result == null) {
            this.activeLayout = result = (Layout)layoutMap.get(this.activeLayoutId);
        }
        return result;
    }

    public static IConfigurationElement[] getLayoutExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return registry.getConfigurationElementsFor(LAYOUT_EXT_ID);
    }

    public String getSavedLayoutId() {
        String result = "";
        IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
        result = preferenceStore.getString(SAVED_LAYOUT_KEY);
        return result;
    }

    public void notifyLayoutChanged() {
        this.disposeBuilders();
    }

    static String getPluginIdForLayoutSet(String layoutSetId) {
        return (String)layoutSetToPluginId.get(layoutSetId);
    }

    void registerBuilder(ElementBuilder builder) {
        this.builders.add(builder);
    }

    private static void init() {
        layoutSetToPluginId = new HashMap();
        layoutMap = new HashMap();
        overridenLayoutSets = new ArrayList();
        IConfigurationElement[] elements = LayoutRegistry.getLayoutExtensions();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute("id");
            Layout layout = (Layout)layoutMap.get(id);
            IConfigurationElement[] layoutSets = elements[i].getChildren("layoutSet");
            if (layout == null) {
                layout = LayoutRegistry.initLayout(layoutSets, id);
                layoutMap.put(id, layout);
            } else {
                LayoutRegistry.createLayoutSets(layoutSets, layout);
            }
            ++i;
        }
    }

    private static Layout initLayout(IConfigurationElement[] elements, String id) {
        Layout result = new Layout(id);
        LayoutRegistry.createLayoutSets(elements, result);
        return result;
    }

    private static void createLayoutSets(IConfigurationElement[] layoutSets, Layout layout) {
        if (layoutSets != null && layoutSets.length > 0) {
            int i = 0;
            while (i < layoutSets.length) {
                LayoutSet layoutSet;
                IConfigurationElement layoutSetElement = layoutSets[i];
                String pluginId = layoutSetElement.getContributor().getName();
                String layoutSetId = layoutSetElement.getAttribute("id");
                String overrides = layoutSetElement.getAttribute("overridesId");
                if (overrides != null) {
                    layout.clearLayoutSet(overrides);
                    layoutSet = layout.getLayoutSet(overrides);
                    layoutSetToPluginId.remove(overrides);
                    layoutSetToPluginId.put(overrides, pluginId);
                    LayoutRegistry.initializeLayoutSet(layoutSetElement, layoutSet);
                    LayoutSet overridingLayoutSet = layout.getLayoutSet(layoutSetId);
                    layoutSetToPluginId.put(layoutSetId, pluginId);
                    LayoutRegistry.initializeLayoutSet(layoutSetElement, overridingLayoutSet);
                    overridenLayoutSets.add(overrides);
                } else if (!overridenLayoutSets.contains(layoutSetId)) {
                    layout.clearLayoutSet(layoutSetId);
                    layoutSet = layout.getLayoutSet(layoutSetId);
                    layoutSetToPluginId.put(layoutSetId, pluginId);
                    LayoutRegistry.initializeLayoutSet(layoutSetElement, layoutSet);
                }
                ++i;
            }
        }
    }

    private static void initializeLayoutSet(IConfigurationElement layoutSetElement, LayoutSet layoutSet) {
        try {
            Object initializer = layoutSetElement.createExecutableExtension("class");
            if (initializer instanceof ILayoutSetInitializer) {
                ILayoutSetInitializer layoutInitializer = (ILayoutSetInitializer)initializer;
                layoutInitializer.initializeLayoutSet(layoutSet);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

