/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.textsize.Probe;
import org.eclipse.rap.rwt.internal.textsize.TextSizeStorage;
import org.eclipse.swt.graphics.FontData;

public class ProbeStore {
    private final Map<FontData, Probe> probes;
    private final TextSizeStorage textSizeStorage;

    public ProbeStore(TextSizeStorage textSizeStorage) {
        this.textSizeStorage = textSizeStorage;
        this.probes = new HashMap<FontData, Probe>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Probe[] getProbes() {
        Probe[] result;
        Map<FontData, Probe> map = this.probes;
        synchronized (map) {
            if (this.probes.isEmpty()) {
                FontData[] fontList = this.textSizeStorage.getFontList();
                int i = 0;
                while (i < fontList.length) {
                    this.createProbe(fontList[i]);
                    ++i;
                }
            }
            result = new Probe[this.probes.size()];
            this.probes.values().toArray(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Probe createProbe(FontData fontData) {
        Probe result = new Probe(fontData);
        Map<FontData, Probe> map = this.probes;
        synchronized (map) {
            this.probes.put(fontData, result);
        }
        this.textSizeStorage.storeFont(fontData);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Probe getProbe(FontData font) {
        Map<FontData, Probe> map = this.probes;
        synchronized (map) {
            return this.probes.get(font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSize() {
        Map<FontData, Probe> map = this.probes;
        synchronized (map) {
            return this.probes.size();
        }
    }
}

