/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.Messages;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimPaneLayout;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.EventHandler;

public class TrimStack {
    public static String CONTRIBUTION_URI = "bundleclass://org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.minmax.TrimStack";
    private static final String LAYOUT_ICON_URI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/icons/full/obj16/layout_co.gif";
    private static final String RESTORE_ICON_URI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/icons/full/etool16/fastview_restore.gif";
    public static final String USE_OVERLAYS_KEY = "UseOverlays";
    static final String STATE_XSIZE = "XSize";
    static final String STATE_YSIZE = "YSize";
    public static final String MINIMIZED_AND_SHOWING = "MinimizedAndShowing";
    private Image layoutImage;
    private Image restoreImage;
    private ToolBar trimStackTB;
    private Menu trimStackMenu;
    private boolean cachedUseOverlays = true;
    private boolean isShowing = false;
    private MUIElement minimizedElement;
    private Composite hostPane;
    @Inject
    @Named(value="org.eclipse.e4.ui.workbench.IResourceUtilities")
    private IResourceUtilities<ImageDescriptor> resUtils;
    private Map<String, Image> imageMap = new HashMap<String, Image>();
    ControlListener caResizeListener = new ControlListener(){
        private static final long serialVersionUID = 1L;

        public void controlResized(ControlEvent e) {
            if (TrimStack.this.hostPane != null && TrimStack.this.hostPane.isVisible()) {
                TrimStack.this.setPaneLocation();
            }
        }

        public void controlMoved(ControlEvent e) {
        }
    };
    private Listener escapeListener = new Listener(){
        private static final long serialVersionUID = 1L;

        public void handleEvent(Event event) {
            if (event.character == '\u001b') {
                TrimStack.this.showStack(false);
                TrimStack.this.partService.requestActivation();
            }
        }
    };
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    @Inject
    MWindow window;
    @Inject
    MToolControl toolControl;
    @Inject
    protected IEventBroker eventBroker;
    private EventHandler closeHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MPart innerPart;
            if (!TrimStack.this.isShowing) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement instanceof MPerspectiveStack) {
                TrimStack.this.showStack(false);
                return;
            }
            if (changedElement instanceof MCompositePart && (innerPart = TrimStack.this.getLeafPart(changedElement)) != null) {
                TrimStack.this.fixToolItemSelection();
                return;
            }
            if (changedElement == TrimStack.this.getLeafPart(TrimStack.this.minimizedElement)) {
                TrimStack.this.fixToolItemSelection();
                return;
            }
            TrimStack.this.showStack(false);
        }
    };
    private EventHandler shutdownHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            TrimStack.this.showStack(false);
        }
    };
    private EventHandler openHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.isShowing) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (TrimStack.this.getLeafPart(TrimStack.this.minimizedElement) == changedElement && !(TrimStack.this.minimizedElement instanceof MPerspectiveStack)) {
                TrimStack.this.showStack(true);
                return;
            }
            MUIElement selectedElement = null;
            if (TrimStack.this.minimizedElement instanceof MPlaceholder) {
                selectedElement = ((MPlaceholder)TrimStack.this.minimizedElement).getRef();
            } else if (TrimStack.this.minimizedElement instanceof MPartStack) {
                selectedElement = ((MPartStack)TrimStack.this.minimizedElement).getSelectedElement();
            }
            if (selectedElement == null) {
                return;
            }
            if (selectedElement instanceof MPlaceholder) {
                selectedElement = ((MPlaceholder)selectedElement).getRef();
            }
            if (changedElement != selectedElement) {
                return;
            }
            TrimStack.this.showStack(true);
        }
    };
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.minimizedElement == null || TrimStack.this.trimStackTB == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement == TrimStack.this.minimizedElement && !TrimStack.this.minimizedElement.isToBeRendered()) {
                TrimStack.this.restoreStack();
                return;
            }
            MElementContainer parentElement = changedElement.getParent();
            if (parentElement == TrimStack.this.minimizedElement) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.minimizedElement == null || TrimStack.this.trimStackTB == null) {
                return;
            }
            Object changedObj = event.getProperty("ChangedElement");
            if (changedObj == TrimStack.this.minimizedElement) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private EventHandler widgetHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            if (changedObj != TrimStack.this.minimizedElement) {
                return;
            }
            if (TrimStack.this.minimizedElement.getWidget() != null) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private SelectionListener toolItemSelectionListener = new SelectionListener(){
        private static final long serialVersionUID = 1L;

        public void widgetSelected(SelectionEvent e) {
            ToolItem toolItem = (ToolItem)e.widget;
            MUIElement uiElement = (MUIElement)toolItem.getData();
            if (!toolItem.getSelection()) {
                TrimStack.this.partService.requestActivation();
                TrimStack.this.showStack(false);
                return;
            }
            if (uiElement instanceof MPart) {
                TrimStack.this.partService.activate((MPart)uiElement);
            } else if (uiElement instanceof MPerspective) {
                uiElement.getParent().setSelectedElement(uiElement);
            }
            TrimStack.this.showStack(true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private int fixedSides;
    private Composite originalParent;

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") org.osgi.service.event.Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MToolControl)) {
            return;
        }
        MToolControl changedElement = (MToolControl)changedObj;
        if (changedElement.getObject() != this) {
            return;
        }
        if (UIEvents.isREMOVE((org.osgi.service.event.Event)event) && UIEvents.contains((org.osgi.service.event.Event)event, (String)"OldValue", (Object)MINIMIZED_AND_SHOWING)) {
            this.showStack(false);
        }
    }

    private Image getOverrideImage(MUIElement element) {
        Image result = null;
        Object imageObject = element.getTransientData().get("e4_override_icon_image_key");
        if (imageObject != null && imageObject instanceof Image && !((Image)imageObject).isDisposed()) {
            result = (Image)imageObject;
        }
        return result;
    }

    private String getOverrideTitleToolTip(MUIElement element) {
        String label;
        String result = null;
        Object stringObject = element.getTransientData().get("e4_override_title_tool_tip_key");
        if (stringObject != null && stringObject instanceof String) {
            result = (String)stringObject;
        }
        if (result == null || result.length() == 0) {
            return null;
        }
        if (element instanceof MUILabel && (label = ((MUILabel)element).getLocalizedLabel()) != null && label.length() > 0) {
            result = String.valueOf(label) + ' ' + '(' + result + ')';
        }
        return result;
    }

    @Inject
    @Optional
    private void handleTransientDataEvents(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/transientData/*") org.osgi.service.event.Event event) {
        ToolItem toolItem;
        if (this.trimStackTB == null || this.trimStackTB.isDisposed() || this.minimizedElement.getWidget() == null) {
            return;
        }
        Object changedElement = event.getProperty("ChangedElement");
        if (!(changedElement instanceof MUIElement)) {
            return;
        }
        String key = UIEvents.isREMOVE((org.osgi.service.event.Event)event) ? (String)((Map.Entry)event.getProperty("OldValue")).getKey() : (String)((Map.Entry)event.getProperty("NewValue")).getKey();
        if (key.equals("e4_override_icon_image_key")) {
            ToolItem toolItem2 = this.getChangedToolItem((MUIElement)changedElement);
            if (toolItem2 != null) {
                toolItem2.setImage(this.getImage((MUILabel)toolItem2.getData()));
            }
        } else if (key.equals("e4_override_title_tool_tip_key") && (toolItem = this.getChangedToolItem((MUIElement)changedElement)) != null) {
            toolItem.setToolTipText(this.getLabelText((MUILabel)toolItem.getData()));
        }
    }

    private ToolItem getChangedToolItem(MUIElement changedElement) {
        ToolItem[] toolItems;
        ToolItem[] toolItemArray = toolItems = this.trimStackTB.getItems();
        int n = toolItems.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray[n2];
            if (changedElement.equals(toolItem.getData())) {
                return toolItem;
            }
            ++n2;
        }
        return null;
    }

    private void fixToolItemSelection() {
        if (this.trimStackTB == null || this.trimStackTB.isDisposed()) {
            return;
        }
        if (!this.isShowing) {
            ToolItem[] toolItemArray = this.trimStackTB.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                item.setSelection(false);
                ++n2;
            }
        } else if (this.isEditorStack() || this.minimizedElement instanceof MPlaceholder) {
            this.trimStackTB.getItem(1).setSelection(true);
        } else if (this.isPerspectiveStack()) {
            MPerspectiveStack pStack = (MPerspectiveStack)this.minimizedElement;
            MUIElement selElement = pStack.getSelectedElement();
            ToolItem[] toolItemArray = this.trimStackTB.getItems();
            int n = toolItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                ToolItem item;
                item.setSelection((item = toolItemArray[n3]).getData() == selElement);
                ++n3;
            }
        } else {
            MPartStack partStack = (MPartStack)this.minimizedElement;
            MUIElement selElement = partStack.getSelectedElement();
            if (selElement instanceof MPlaceholder) {
                selElement = ((MPlaceholder)selElement).getRef();
            }
            ToolItem[] toolItemArray = this.trimStackTB.getItems();
            int n = toolItemArray.length;
            int n4 = 0;
            while (n4 < n) {
                ToolItem item = toolItemArray[n4];
                boolean isSel = item.getData() == selElement;
                item.setSelection(isSel);
                ++n4;
            }
        }
    }

    private boolean isEditorStack() {
        if (!(this.minimizedElement instanceof MPlaceholder)) {
            return false;
        }
        MPlaceholder ph = (MPlaceholder)this.minimizedElement;
        return ph.getRef() instanceof MArea;
    }

    private boolean isPerspectiveStack() {
        return this.minimizedElement instanceof MPerspectiveStack;
    }

    private MPart getLeafPart(MUIElement element) {
        if (element instanceof MPlaceholder) {
            return this.getLeafPart(((MPlaceholder)element).getRef());
        }
        if (element instanceof MElementContainer) {
            return this.getLeafPart(((MElementContainer)element).getSelectedElement());
        }
        if (element instanceof MPart) {
            return (MPart)element;
        }
        return null;
    }

    @PostConstruct
    void addListeners() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childrenHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.toBeRenderedHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.widgetHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/bringToTop", this.openHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/activate", this.closeHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appShutdownStarted", this.shutdownHandler);
    }

    private Composite getCAComposite() {
        if (this.trimStackTB == null) {
            return null;
        }
        Shell theShell = this.trimStackTB.getShell();
        if (theShell.getLayout() instanceof TrimmedPartLayout) {
            TrimmedPartLayout tpl = (TrimmedPartLayout)theShell.getLayout();
            if (!tpl.clientArea.isDisposed()) {
                return tpl.clientArea;
            }
        }
        return null;
    }

    @PreDestroy
    void removeListeners() {
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.widgetHandler);
        this.eventBroker.unsubscribe(this.openHandler);
        this.eventBroker.unsubscribe(this.closeHandler);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl me, CSSRenderingUtils cssUtils) {
        MTrimBar bar;
        if (this.minimizedElement == null) {
            this.minimizedElement = this.findElement();
        }
        MElementContainer meParent = me.getParent();
        int orientation = 256;
        if (meParent instanceof MTrimBar && ((bar = (MTrimBar)meParent).getSide() == SideValue.RIGHT || bar.getSide() == SideValue.LEFT)) {
            orientation = 512;
        }
        this.trimStackTB = new ToolBar(parent, orientation | 0x800000 | 0x40);
        this.trimStackTB.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                TrimStack.this.showStack(false);
                TrimStack.this.trimStackTB = null;
                TrimStack.this.trimStackMenu = null;
            }
        });
        this.trimStackTB.addListener(35, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                while (TrimStack.this.trimStackMenu.getItemCount() > 0) {
                    TrimStack.this.trimStackMenu.getItem(0).dispose();
                }
                Point point = TrimStack.this.trimStackTB.getDisplay().map(null, (Control)TrimStack.this.trimStackTB, new Point(event.x, event.y));
                ToolItem selectedToolItem = TrimStack.this.trimStackTB.getItem(point);
                if (selectedToolItem == null) {
                    return;
                }
                Object data = selectedToolItem.getData();
                if (data instanceof MPart) {
                    TrimStack.this.createPartMenu((MPart)data);
                } else if (data instanceof MPerspective) {
                    TrimStack.this.createEmtpyEditorAreaMenu();
                } else if (TrimStack.this.isEditorStack()) {
                    TrimStack.this.createEmtpyEditorAreaMenu();
                } else {
                    TrimStack.this.createUseOverlaysMenu();
                }
            }
        });
        this.trimStackMenu = new Menu((Control)this.trimStackTB);
        this.trimStackTB.setMenu(this.trimStackMenu);
        ToolItem restoreBtn = new ToolItem(this.trimStackTB, 8);
        restoreBtn.setToolTipText(Messages.TrimStack_RestoreText);
        restoreBtn.setImage(this.getRestoreImage());
        restoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                TrimStack.this.minimizedElement.getTags().remove("Minimized");
            }
        });
        this.updateTrimStackItems();
    }

    private void createEmtpyEditorAreaMenu() {
        MenuItem restoreItem = new MenuItem(this.trimStackMenu, 0);
        restoreItem.setText(Messages.TrimStack_RestoreText);
        restoreItem.addListener(13, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                TrimStack.this.minimizedElement.getTags().remove("Minimized");
            }
        });
    }

    private void createUseOverlaysMenu() {
        MenuItem useOverlaysItem = new MenuItem(this.trimStackMenu, 32);
        useOverlaysItem.setText(Messages.TrimStack_Show_In_Original_Location);
        useOverlaysItem.setSelection(!this.useOverlays());
        useOverlaysItem.addListener(13, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                if (TrimStack.this.toolControl != null) {
                    TrimStack.this.toolControl.getPersistedState().put(TrimStack.USE_OVERLAYS_KEY, Boolean.toString(!TrimStack.this.useOverlays()));
                }
            }
        });
    }

    private void createPartMenu(final MPart selectedPart) {
        MenuItem orientationItem = new MenuItem(this.trimStackMenu, 64);
        orientationItem.setText(Messages.TrimStack_OrientationMenu);
        Menu orientationMenu = new Menu(orientationItem);
        orientationItem.setMenu(orientationMenu);
        MenuItem defaultItem = new MenuItem(orientationMenu, 16);
        defaultItem.setText(Messages.TrimStack_DefaultOrientationItem);
        defaultItem.addListener(13, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                boolean doRefresh = TrimStack.this.minimizedElement.getTags().remove("Horizontal");
                if (TrimStack.this.isShowing && (doRefresh |= TrimStack.this.minimizedElement.getTags().remove("Vertical"))) {
                    TrimStack.this.setPaneLocation();
                }
            }
        });
        MenuItem horizontalItem = new MenuItem(orientationMenu, 16);
        horizontalItem.setText(Messages.TrimStack_Horizontal);
        horizontalItem.addListener(13, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                if (!TrimStack.this.minimizedElement.getTags().contains("Horizontal")) {
                    TrimStack.this.minimizedElement.getTags().remove("Vertical");
                    TrimStack.this.minimizedElement.getTags().add("Horizontal");
                    if (TrimStack.this.isShowing) {
                        TrimStack.this.setPaneLocation();
                    }
                }
            }
        });
        MenuItem verticalItem = new MenuItem(orientationMenu, 16);
        verticalItem.setText(Messages.TrimStack_Vertical);
        verticalItem.addListener(13, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                if (!TrimStack.this.minimizedElement.getTags().contains("Vertical")) {
                    TrimStack.this.minimizedElement.getTags().remove("Horizontal");
                    TrimStack.this.minimizedElement.getTags().add("Vertical");
                    if (TrimStack.this.isShowing) {
                        TrimStack.this.setPaneLocation();
                    }
                }
            }
        });
        if (this.minimizedElement.getTags().contains("Horizontal")) {
            horizontalItem.setSelection(true);
        } else if (this.minimizedElement.getTags().contains("Vertical")) {
            verticalItem.setSelection(true);
        } else {
            defaultItem.setSelection(true);
        }
        MenuItem restoreItem = new MenuItem(this.trimStackMenu, 0);
        restoreItem.setText(Messages.TrimStack_RestoreText);
        restoreItem.addListener(13, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                TrimStack.this.minimizedElement.getTags().remove("Minimized");
                TrimStack.this.partService.activate(selectedPart);
            }
        });
        if (!this.isEditorStack()) {
            MenuItem closeItem = new MenuItem(this.trimStackMenu, 0);
            closeItem.setText(Messages.TrimStack_CloseText);
            closeItem.addListener(13, new Listener(){
                private static final long serialVersionUID = 1L;

                public void handleEvent(Event event) {
                    TrimStack.this.partService.hidePart(selectedPart);
                }
            });
        }
    }

    @PreDestroy
    void destroy() {
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        if (this.layoutImage != null) {
            this.layoutImage.dispose();
            this.layoutImage = null;
        }
        if (this.restoreImage != null) {
            this.restoreImage.dispose();
            this.restoreImage = null;
        }
    }

    public MUIElement getMinimizedElement() {
        return this.minimizedElement;
    }

    private MUIElement findElement() {
        MUIElement result;
        List ps = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
        if (ps.size() == 0) {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            result = this.modelService.find(stackId, (MUIElement)this.window);
        } else {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            String perspId = toolControlId.substring(index + 1, toolControlId.length() - 1);
            MPerspective persp = null;
            List perspectives = this.modelService.findElements((MUIElement)ps.get(0), perspId, MPerspective.class, null);
            if (perspectives != null && !perspectives.isEmpty()) {
                persp = (MPerspective)perspectives.get(0);
            }
            result = persp != null ? this.modelService.find(stackId, persp) : this.modelService.find(stackId, (MUIElement)this.window);
        }
        return result;
    }

    private String getLabelText(MUILabel label) {
        String text;
        if (label instanceof MUIElement && (text = this.getOverrideTitleToolTip((MUIElement)label)) != null && text.length() > 0) {
            return text;
        }
        String string = label.getLocalizedLabel();
        return string == null ? "" : string;
    }

    private Image getImage(MUILabel element) {
        Image image;
        if (element instanceof MUIElement && (image = this.getOverrideImage((MUIElement)element)) != null) {
            return image;
        }
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            Image image2 = this.imageMap.get(iconURI);
            if (image2 == null) {
                image2 = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))).createImage();
                this.imageMap.put(iconURI, image2);
            }
            return image2;
        }
        return null;
    }

    private MUILabel getLabelElement(MUIElement element) {
        if (element instanceof MPlaceholder) {
            element = ((MPlaceholder)element).getRef();
        }
        return (MUILabel)(element instanceof MUILabel ? element : null);
    }

    /*
     * Unable to fully structure code
     */
    private void updateTrimStackItems() {
        if (this.trimStackTB != null && !this.trimStackTB.isDisposed() && this.minimizedElement.getWidget() != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.trimStackTB.getItem(this.trimStackTB.getItemCount() - 1).dispose();
lbl4:
            // 2 sources

            ** while (this.trimStackTB.getItemCount() > 1)
        }
lbl5:
        // 1 sources

        if (this.isEditorStack() && this.trimStackTB.getItemCount() == 1) {
            ti = new ToolItem(this.trimStackTB, 32);
            ti.setToolTipText(Messages.TrimStack_SharedAreaTooltip);
            ti.setImage(this.getLayoutImage());
            ti.addSelectionListener(this.toolItemSelectionListener);
        } else if (this.minimizedElement instanceof MPlaceholder) {
            ph = (MPlaceholder)this.minimizedElement;
            if (ph.getRef() instanceof MPart) {
                part = (MPart)ph.getRef();
                ti = new ToolItem(this.trimStackTB, 32);
                ti.setData((Object)part);
                ti.setImage(this.getImage((MUILabel)part));
                ti.setToolTipText(this.getLabelText((MUILabel)part));
                ti.addSelectionListener(this.toolItemSelectionListener);
            }
        } else if (this.minimizedElement instanceof MGenericStack) {
            theStack = (MGenericStack)this.minimizedElement;
            hasRenderedElements = false;
            for (MUIElement stackElement : theStack.getChildren()) {
                if (!stackElement.isToBeRendered()) continue;
                hasRenderedElements = true;
                break;
            }
            if (hasRenderedElements) {
                for (MUIElement stackElement : theStack.getChildren()) {
                    if (!stackElement.isToBeRendered()) continue;
                    labelElement = this.getLabelElement(stackElement);
                    newItem = new ToolItem(this.trimStackTB, 32);
                    newItem.setData((Object)labelElement);
                    newItem.setImage(this.getImage(labelElement));
                    newItem.setToolTipText(this.getLabelText(labelElement));
                    newItem.addSelectionListener(this.toolItemSelectionListener);
                }
            } else if (theStack.getTags().contains("NoAutoCollapse")) {
                ti = new ToolItem(this.trimStackTB, 32);
                ti.setToolTipText(Messages.TrimStack_EmptyStackTooltip);
                ti.setImage(this.getLayoutImage());
                ti.addSelectionListener(this.toolItemSelectionListener);
            } else {
                this.restoreStack();
                return;
            }
        }
        this.trimStackTB.pack();
        this.trimStackTB.getShell().layout(new Control[]{this.trimStackTB}, 4);
    }

    void restoreStack() {
        this.showStack(false);
        this.minimizedElement.setVisible(true);
        this.minimizedElement.getTags().remove("Minimized");
        if (this.minimizedElement instanceof MPartStack) {
            MPartStack theStack = (MPartStack)this.minimizedElement;
            MStackElement curSel = (MStackElement)theStack.getSelectedElement();
            Control ctrl = (Control)this.minimizedElement.getWidget();
            if (ctrl instanceof CTabFolder && ((CTabFolder)ctrl).getSelection() == null) {
                theStack.setSelectedElement(null);
                theStack.setSelectedElement((MUIElement)curSel);
            }
        }
        this.toolControl.setToBeRendered(false);
        if (this.hostPane != null && !this.hostPane.isDisposed()) {
            this.hostPane.dispose();
        }
        this.hostPane = null;
    }

    public void showStack(boolean show) {
        Control ctrl = (Control)this.minimizedElement.getWidget();
        CTabFolder ctf = ctrl instanceof CTabFolder ? (CTabFolder)ctrl : null;
        Composite clientAreaComposite = this.getCAComposite();
        if (clientAreaComposite == null || clientAreaComposite.isDisposed()) {
            return;
        }
        if (show && !this.isShowing) {
            MPlaceholder ph;
            if (this.useOverlays()) {
                this.hostPane = this.getHostPane();
                this.originalParent = ctrl.getParent();
                ctrl.setParent(this.hostPane);
                if (ctf != null) {
                    Rectangle bb = ctf.getBounds();
                    --bb.width;
                    ctf.setBounds(bb);
                }
                clientAreaComposite.addControlListener(this.caResizeListener);
                this.setPaneLocation();
                this.hostPane.addListener(31, this.escapeListener);
                this.hostPane.layout(true);
                this.hostPane.moveAbove(null);
                this.hostPane.setVisible(true);
                this.cachedUseOverlays = true;
            } else {
                this.minimizedElement.setVisible(true);
                ctrl.addListener(31, this.escapeListener);
                this.cachedUseOverlays = false;
            }
            this.isShowing = true;
            this.toolControl.getTags().add(MINIMIZED_AND_SHOWING);
            if (this.minimizedElement instanceof MPartStack) {
                MPlaceholder ph2;
                MPartStack theStack = (MPartStack)this.minimizedElement;
                MStackElement curSel = (MStackElement)theStack.getSelectedElement();
                if (ctf != null && ctf.getSelection() == null) {
                    theStack.setSelectedElement(null);
                    theStack.setSelectedElement((MUIElement)curSel);
                }
                if (curSel instanceof MPart) {
                    this.partService.activate((MPart)curSel);
                } else if (curSel instanceof MPlaceholder && (ph2 = (MPlaceholder)curSel).getRef() instanceof MPart) {
                    this.partService.activate((MPart)ph2.getRef());
                }
            } else if (this.isEditorStack()) {
                MArea area = (MArea)((MPlaceholder)this.minimizedElement).getRef();
                MPart partToActivate = null;
                MUIElement selectedElement = area.getSelectedElement();
                while (partToActivate == null && selectedElement != null) {
                    if (selectedElement instanceof MPart) {
                        partToActivate = (MPart)selectedElement;
                        continue;
                    }
                    if (selectedElement instanceof MPlaceholder) {
                        MPlaceholder ph3 = (MPlaceholder)selectedElement;
                        if (ph3.getRef() instanceof MPart) {
                            partToActivate = (MPart)ph3.getRef();
                            continue;
                        }
                        selectedElement = null;
                        continue;
                    }
                    if (!(selectedElement instanceof MElementContainer)) continue;
                    MElementContainer container = (MElementContainer)selectedElement;
                    selectedElement = container.getSelectedElement();
                }
                if (partToActivate == null) {
                    List parts = this.modelService.findElements((MUIElement)area, null, MPart.class, null);
                    for (MPart part : parts) {
                        if (!this.partService.isPartVisible(part)) continue;
                        partToActivate = part;
                        break;
                    }
                }
                if (partToActivate != null) {
                    this.partService.activate(partToActivate);
                }
            } else if (this.minimizedElement instanceof MPlaceholder && (ph = (MPlaceholder)this.minimizedElement).getRef() instanceof MPart) {
                MPart part = (MPart)ph.getRef();
                this.partService.activate(part);
            }
            this.fixToolItemSelection();
        } else if (!show && this.isShowing) {
            if (this.cachedUseOverlays) {
                if (clientAreaComposite != null) {
                    clientAreaComposite.removeControlListener(this.caResizeListener);
                }
                ctrl.setParent(this.originalParent);
                this.hostPane.dispose();
                this.hostPane = null;
            } else {
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.removeListener(31, this.escapeListener);
                }
                this.minimizedElement.setVisible(false);
            }
            this.isShowing = false;
            this.toolControl.getTags().remove(MINIMIZED_AND_SHOWING);
            this.fixToolItemSelection();
        }
    }

    private boolean useOverlays() {
        if (this.toolControl == null) {
            return true;
        }
        String useOverlays = (String)this.toolControl.getPersistedState().get(USE_OVERLAYS_KEY);
        if (useOverlays == null) {
            useOverlays = "true";
        }
        return Boolean.parseBoolean(useOverlays);
    }

    private void setPaneLocation() {
        Composite clientAreaComposite = this.getCAComposite();
        if (clientAreaComposite == null || clientAreaComposite.isDisposed()) {
            return;
        }
        Rectangle caRect = clientAreaComposite.getBounds();
        Point paneSize = this.hostPane.getSize();
        if (paneSize.x > caRect.width) {
            paneSize.x = caRect.width;
        }
        if (paneSize.y > caRect.height) {
            paneSize.y = caRect.height;
        }
        if (this.minimizedElement.getTags().contains("Horizontal")) {
            paneSize.x = caRect.width;
        }
        if (this.minimizedElement.getTags().contains("Vertical")) {
            paneSize.y = caRect.height;
        }
        Point loc = new Point(0, 0);
        loc.x = this.isFixed(16384) ? caRect.x : caRect.x + caRect.width - paneSize.x;
        loc.y = this.isFixed(128) ? caRect.y : caRect.y + caRect.height - paneSize.y;
        this.hostPane.setSize(paneSize);
        this.hostPane.setLocation(loc);
    }

    private void setHostSize() {
        if (this.hostPane == null || this.hostPane.isDisposed()) {
            return;
        }
        int xSize = 600;
        String xSizeStr = (String)this.toolControl.getPersistedState().get(STATE_XSIZE);
        if (xSizeStr != null) {
            xSize = Integer.parseInt(xSizeStr);
        }
        int ySize = 400;
        String ySizeStr = (String)this.toolControl.getPersistedState().get(STATE_YSIZE);
        if (ySizeStr != null) {
            ySize = Integer.parseInt(ySizeStr);
        }
        this.hostPane.setSize(xSize, ySize);
    }

    private Composite getHostPane() {
        this.hostPane = new Composite((Composite)this.trimStackTB.getShell(), 0);
        this.hostPane.setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        this.hostPane.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                TrimStack.this.hostPane = null;
            }
        });
        this.setHostSize();
        this.fixedSides = this.getFixedSides();
        this.hostPane.setLayout((Layout)new TrimPaneLayout(this.toolControl, this.fixedSides));
        return this.hostPane;
    }

    private int getFixedSides() {
        MElementContainer tcParent = this.toolControl.getParent();
        if (!(tcParent instanceof MTrimBar)) {
            return 0;
        }
        MTrimBar bar = (MTrimBar)tcParent;
        Composite trimComp = (Composite)bar.getWidget();
        Rectangle trimBounds = trimComp.getBounds();
        Point trimCenter = new Point(trimBounds.width / 2, trimBounds.height / 2);
        Control trimCtrl = (Control)this.toolControl.getWidget();
        Rectangle ctrlBounds = trimCtrl.getBounds();
        Point ctrlCenter = new Point(ctrlBounds.x + ctrlBounds.width / 2, ctrlBounds.y + ctrlBounds.height / 2);
        if (bar.getSide() == SideValue.LEFT) {
            int verticalValue = ctrlCenter.y < trimCenter.y ? 128 : 1024;
            return 0x4000 | verticalValue;
        }
        if (bar.getSide() == SideValue.RIGHT) {
            int verticalValue = ctrlCenter.y < trimCenter.y ? 128 : 1024;
            return 0x20000 | verticalValue;
        }
        if (bar.getSide() == SideValue.TOP) {
            int horizontalValue = ctrlCenter.x < trimCenter.x ? 16384 : 131072;
            return 0x80 | horizontalValue;
        }
        if (bar.getSide() == SideValue.BOTTOM) {
            int horizontalValue = ctrlCenter.x < trimCenter.x ? 16384 : 131072;
            return 0x400 | horizontalValue;
        }
        return 132096;
    }

    private Image getLayoutImage() {
        if (this.layoutImage == null) {
            this.layoutImage = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)LAYOUT_ICON_URI))).createImage();
        }
        return this.layoutImage;
    }

    private Image getRestoreImage() {
        if (this.restoreImage == null) {
            this.restoreImage = ((ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)RESTORE_ICON_URI))).createImage();
        }
        return this.restoreImage;
    }

    private boolean isFixed(int swtSide) {
        return (this.fixedSides & swtSide) != 0;
    }
}

