/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.engine;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.rap.rwt.service.UISession;

public class PostDeserialization {
    private static final String ATTR_PROCESSORS = String.valueOf(PostDeserialization.class.getName()) + "#processors";

    public static void runProcessors(UISession uiSession) {
        List<Runnable> processors = PostDeserialization.getProcessors(uiSession);
        if (processors != null) {
            PostDeserialization.clearProcessors(uiSession);
            for (Runnable processor : processors) {
                processor.run();
            }
        }
    }

    public static void addProcessor(UISession uiSession, Runnable processor) {
        List<Runnable> processorsList = PostDeserialization.getProcessors(uiSession);
        if (processorsList == null) {
            processorsList = new LinkedList<Runnable>();
            uiSession.setAttribute(ATTR_PROCESSORS, processorsList);
        }
        processorsList.add(processor);
    }

    private static List<Runnable> getProcessors(UISession uiSession) {
        return (List)uiSession.getAttribute(ATTR_PROCESSORS);
    }

    private static void clearProcessors(UISession uiSession) {
        uiSession.removeAttribute(ATTR_PROCESSORS);
    }

    private PostDeserialization() {
    }
}

