/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;

public class ServiceUse<S> {
    public static final int DEADLOCK = 1001;
    final BundleContextImpl context;
    final ServiceRegistrationImpl<S> registration;
    final Debug debug;
    private int useCount = 0;
    private final ServiceUseLock lock = new ServiceUseLock();

    ServiceUse(BundleContextImpl context, ServiceRegistrationImpl<S> registration) {
        this.registration = registration;
        this.context = context;
        this.debug = context.getContainer().getConfiguration().getDebug();
    }

    S getService() {
        assert (this.isLocked());
        if (this.debug.DEBUG_SERVICES) {
            Debug.println("[" + Thread.currentThread().getName() + "] getService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        this.incrementUse();
        return this.registration.getServiceObject();
    }

    boolean ungetService() {
        assert (this.isLocked());
        if (!this.inUse()) {
            return false;
        }
        if (this.debug.DEBUG_SERVICES) {
            Debug.println("[" + Thread.currentThread().getName() + "] ungetService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        this.decrementUse();
        return true;
    }

    S getCachedService() {
        return this.registration.getServiceObject();
    }

    S newServiceObject() {
        return this.getService();
    }

    boolean releaseServiceObject(S service) {
        if (service == null || service != this.getCachedService() && this.context.isValid()) {
            throw new IllegalArgumentException(Msg.SERVICE_OBJECTS_UNGET_ARGUMENT_EXCEPTION);
        }
        if (this.debug.DEBUG_SERVICES) {
            Debug.println("[" + Thread.currentThread().getName() + "] releaseServiceObject[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        return this.ungetService();
    }

    void release() {
        assert (this.isLocked());
        this.resetUse();
    }

    boolean isEmpty() {
        assert (this.isLocked());
        return !this.inUse();
    }

    boolean inUse() {
        return this.useCount > 0;
    }

    void incrementUse() {
        if (this.useCount == Integer.MAX_VALUE) {
            throw new ServiceException(Msg.SERVICE_USE_OVERFLOW);
        }
        ++this.useCount;
    }

    void decrementUse() {
        assert (this.inUse());
        --this.useCount;
    }

    void resetUse() {
        this.useCount = 0;
    }

    ServiceUseLock getLock() {
        return this.lock;
    }

    protected boolean isLocked() {
        return this.getLock().isHeldByCurrentThread();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ServiceUseLock lock() {
        Thread awaitingThread = null;
        boolean interrupted = false;
        try {
            ServiceUseLock useLock = this.getLock();
            while (true) {
                block10: {
                    ServiceUseLock serviceUseLock;
                    block11: {
                        if (!useLock.tryLock(100000000L, TimeUnit.NANOSECONDS)) break block10;
                        serviceUseLock = useLock;
                        if (awaitingThread == null) break block11;
                        this.registration.getAwaitedUseLocks().remove(awaitingThread);
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return serviceUseLock;
                }
                try {
                    awaitingThread = Thread.currentThread();
                    this.checkDeadLock(awaitingThread, useLock);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                continue;
                break;
            }
        }
        catch (Throwable throwable) {
            if (awaitingThread != null) {
                this.registration.getAwaitedUseLocks().remove(awaitingThread);
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    private void checkDeadLock(Thread currentThread, ServiceUseLock currentLock) {
        ConcurrentMap<Thread, ServiceUseLock> awaitedUseLocks = this.registration.getAwaitedUseLocks();
        awaitedUseLocks.put(currentThread, currentLock);
        ServiceUseLock useLock = currentLock;
        int maxLocks = awaitedUseLocks.size();
        int i = 0;
        while (i < maxLocks) {
            Thread owner = useLock.getOwner();
            if (owner == currentThread) {
                throw new ServiceException(NLS.bind(Msg.SERVICE_USE_DEADLOCK, currentLock), 1001);
            }
            if (owner == null || (useLock = (ServiceUseLock)awaitedUseLocks.get(owner)) == null) break;
            ++i;
        }
    }

    static class ServiceUseLock
    extends ReentrantLock
    implements AutoCloseable {
        private static final long serialVersionUID = 1L;

        ServiceUseLock() {
        }

        @Override
        public void close() {
            this.unlock();
        }

        @Override
        protected Thread getOwner() {
            return super.getOwner();
        }

        @Override
        public String toString() {
            Thread o = this.getOwner();
            if (o != null) {
                try {
                    ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                    ThreadInfo threadInfo = threadMXBean.getThreadInfo(o.getId(), Integer.MAX_VALUE);
                    StackTraceElement[] trace = threadInfo.getStackTrace();
                    StringBuilder sb = new StringBuilder(super.toString()).append(", Details:\n");
                    if (o.isDaemon()) {
                        sb.append("daemon ");
                    }
                    sb.append("prio=").append(o.getPriority()).append(" id=").append(o.getId()).append(" ").append((Object)o.getState());
                    StackTraceElement[] stackTraceElementArray = trace;
                    int n = trace.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement traceElement = stackTraceElementArray[n2];
                        sb.append("\tat ").append(traceElement).append("\n");
                        ++n2;
                    }
                    return sb.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.toString();
        }
    }
}

