/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;

public abstract class AbstractEditPart
implements EditPart,
RequestConstants,
IAdaptable {
    protected static final int FLAG_ACTIVE = 1;
    protected static final int FLAG_FOCUS = 2;
    protected static final int MAX_FLAG = 2;
    private Object model;
    private int flags;
    private EditPart parent;
    private int selected;
    private Object[] policies;
    protected List children;
    EventListenerList eventListeners = new EventListenerList();

    public void activate() {
        this.setFlag(1, true);
        this.activateEditPolicies();
        List c = this.getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).activate();
            ++i;
        }
        this.fireActivated();
    }

    protected void activateEditPolicies() {
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            i.next().activate();
        }
    }

    protected void addChild(EditPart child, int index) {
        Assert.isNotNull((Object)child);
        if (index == -1) {
            index = this.getChildren().size();
        }
        if (this.children == null) {
            this.children = new ArrayList(2);
        }
        this.children.add(index, child);
        child.setParent(this);
        this.addChildVisual(child, index);
        child.addNotify();
        if (this.isActive()) {
            child.activate();
        }
        this.fireChildAdded(child, index);
    }

    protected abstract void addChildVisual(EditPart var1, int var2);

    public void addEditPartListener(EditPartListener listener) {
        this.eventListeners.addListener(EditPartListener.class, (Object)listener);
    }

    public void addNotify() {
        this.register();
        this.createEditPolicies();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            ((EditPart)children.get(i)).addNotify();
            ++i;
        }
        this.refresh();
    }

    protected EditPart createChild(Object model) {
        return this.getViewer().getEditPartFactory().createEditPart(this, model);
    }

    protected abstract void createEditPolicies();

    public void deactivate() {
        List c = this.getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).deactivate();
            ++i;
        }
        this.deactivateEditPolicies();
        this.setFlag(1, false);
        this.fireDeactivated();
    }

    protected void deactivateEditPolicies() {
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            i.next().deactivate();
        }
    }

    protected final void debug(String message) {
    }

    protected final void debugFeedback(String message) {
    }

    public void eraseSourceFeedback(Request request) {
        if (this.isActive()) {
            EditPolicyIterator iter = this.getEditPolicyIterator();
            while (iter.hasNext()) {
                iter.next().eraseSourceFeedback(request);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            EditPolicyIterator iter = this.getEditPolicyIterator();
            while (iter.hasNext()) {
                iter.next().eraseTargetFeedback(request);
            }
        }
    }

    protected void fireActivated() {
        Iterator listeners = this.getEventListeners(EditPartListener.class);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).partActivated(this);
        }
    }

    protected void fireChildAdded(EditPart child, int index) {
        Iterator listeners = this.getEventListeners(EditPartListener.class);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).childAdded(child, index);
        }
    }

    protected void fireDeactivated() {
        Iterator listeners = this.getEventListeners(EditPartListener.class);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).partDeactivated(this);
        }
    }

    protected void fireRemovingChild(EditPart child, int index) {
        Iterator listeners = this.getEventListeners(EditPartListener.class);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).removingChild(child, index);
        }
    }

    protected void fireSelectionChanged() {
        Iterator listeners = this.getEventListeners(EditPartListener.class);
        while (listeners.hasNext()) {
            ((EditPartListener)listeners.next()).selectedStateChanged(this);
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        return null;
    }

    public Object getAdapter(Class key) {
        if (AccessibleEditPart.class == key) {
            return this.getAccessibleEditPart();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, key);
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public Command getCommand(Request request) {
        Command command = null;
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            command = command != null ? command.chain(i.next().getCommand(request)) : i.next().getCommand(request);
        }
        return command;
    }

    protected final Iterator getEventListeners(Class clazz) {
        return this.eventListeners.getListeners(clazz);
    }

    public EditPolicy getEditPolicy(Object key) {
        if (this.policies != null) {
            int i = 0;
            while (i < this.policies.length) {
                if (key.equals(this.policies[i])) {
                    return (EditPolicy)this.policies[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    protected final EditPolicyIterator getEditPolicyIterator() {
        return new EditPolicyIterator(this.policies);
    }

    protected final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public Object getModel() {
        return this.model;
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public EditPart getParent() {
        return this.parent;
    }

    public RootEditPart getRoot() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getRoot();
    }

    public int getSelected() {
        return this.selected;
    }

    public EditPart getTargetEditPart(Request request) {
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            EditPart editPart = i.next().getTargetEditPart(request);
            if (editPart == null) continue;
            return editPart;
        }
        if ("selection" == request.getType() && this.isSelectable()) {
            return this;
        }
        return null;
    }

    public EditPartViewer getViewer() {
        RootEditPart root = this.getRoot();
        if (root == null) {
            return null;
        }
        return root.getViewer();
    }

    public boolean hasFocus() {
        return this.getFlag(2);
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        Assert.isNotNull((Object)key, (String)"Edit Policies must be installed with keys");
        if (this.policies == null) {
            this.policies = new Object[2];
            this.policies[0] = key;
            this.policies[1] = editPolicy;
        } else {
            int index = 0;
            while (index < this.policies.length && !key.equals(this.policies[index])) {
                index += 2;
            }
            if (index < this.policies.length) {
                EditPolicy old;
                if ((old = (EditPolicy)this.policies[++index]) != null && this.isActive()) {
                    old.deactivate();
                }
                this.policies[index] = editPolicy;
            } else {
                Object[] newPolicies = new Object[this.policies.length + 2];
                System.arraycopy(this.policies, 0, newPolicies, 0, this.policies.length);
                this.policies = newPolicies;
                this.policies[index] = key;
                this.policies[index + 1] = editPolicy;
            }
        }
        if (editPolicy != null) {
            editPolicy.setHost(this);
            if (this.isActive()) {
                editPolicy.activate();
            }
        }
    }

    public boolean isActive() {
        return this.getFlag(1);
    }

    public boolean isSelectable() {
        return true;
    }

    public void performRequest(Request req) {
    }

    public void refresh() {
        this.refreshVisuals();
        this.refreshChildren();
    }

    protected void refreshChildren() {
        EditPart editPart;
        int i;
        List children = this.getChildren();
        int size = children.size();
        HashMap<Object, EditPart> modelToEditPart = Collections.EMPTY_MAP;
        if (size > 0) {
            modelToEditPart = new HashMap<Object, EditPart>(size);
            i = 0;
            while (i < size) {
                editPart = (EditPart)children.get(i);
                modelToEditPart.put(editPart.getModel(), editPart);
                ++i;
            }
        }
        List modelObjects = this.getModelChildren();
        i = 0;
        while (i < modelObjects.size()) {
            Object model = modelObjects.get(i);
            if (i >= children.size() || ((EditPart)children.get(i)).getModel() != model) {
                editPart = (EditPart)modelToEditPart.get(model);
                if (editPart != null) {
                    this.reorderChild(editPart, i);
                } else {
                    editPart = this.createChild(model);
                    this.addChild(editPart, i);
                }
            }
            ++i;
        }
        size = children.size();
        if (i < size) {
            ArrayList trash = new ArrayList(size - i);
            while (i < size) {
                trash.add(children.get(i));
                ++i;
            }
            i = 0;
            while (i < trash.size()) {
                EditPart ep = (EditPart)trash.get(i);
                this.removeChild(ep);
                ++i;
            }
        }
    }

    protected void refreshVisuals() {
    }

    protected void register() {
        this.registerModel();
        this.registerVisuals();
        this.registerAccessibility();
    }

    protected final void registerAccessibility() {
        if (this.getAccessibleEditPart() != null) {
            this.getViewer().registerAccessibleEditPart(this.getAccessibleEditPart());
        }
    }

    protected void registerModel() {
        this.getViewer().getEditPartRegistry().put(this.getModel(), this);
    }

    protected void registerVisuals() {
    }

    protected void removeChild(EditPart child) {
        Assert.isNotNull((Object)child);
        int index = this.getChildren().indexOf(child);
        if (index < 0) {
            return;
        }
        this.fireRemovingChild(child, index);
        if (this.isActive()) {
            child.deactivate();
        }
        child.removeNotify();
        this.removeChildVisual(child);
        child.setParent(null);
        this.getChildren().remove(child);
    }

    protected abstract void removeChildVisual(EditPart var1);

    public void removeEditPartListener(EditPartListener listener) {
        this.eventListeners.removeListener(EditPartListener.class, (Object)listener);
    }

    public void removeEditPolicy(Object key) {
        if (this.policies == null) {
            return;
        }
        int i = 0;
        while (i < this.policies.length) {
            if (key.equals(this.policies[i])) {
                EditPolicy policy = (EditPolicy)this.policies[++i];
                this.policies[i] = null;
                if (this.isActive() && policy != null) {
                    policy.deactivate();
                }
            }
            i += 2;
        }
    }

    public void removeNotify() {
        if (this.getSelected() != 0) {
            this.getViewer().deselect(this);
        }
        if (this.hasFocus()) {
            this.getViewer().setFocus(null);
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            ((EditPart)children.get(i)).removeNotify();
            ++i;
        }
        this.unregister();
    }

    protected void reorderChild(EditPart editpart, int index) {
        this.removeChildVisual(editpart);
        List children = this.getChildren();
        children.remove(editpart);
        children.add(index, editpart);
        this.addChildVisual(editpart, index);
    }

    protected final void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public void setFocus(boolean value) {
        Assert.isLegal((this.isSelectable() || !value ? 1 : 0) != 0, (String)"An EditPart has to be selectable (isSelectable() == true) in order to obtain focus.");
        if (this.hasFocus() == value) {
            return;
        }
        this.setFlag(2, value);
        this.fireSelectionChanged();
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public void setParent(EditPart parent) {
        this.parent = parent;
    }

    public void setSelected(int value) {
        Assert.isLegal((this.isSelectable() || value == 0 ? 1 : 0) != 0, (String)"An EditPart has to be selectable (isSelectable() == true) in order to get selected.");
        if (this.selected == value) {
            return;
        }
        this.selected = value;
        this.fireSelectionChanged();
    }

    public void showSourceFeedback(Request request) {
        if (!this.isActive()) {
            return;
        }
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            i.next().showSourceFeedback(request);
        }
    }

    public void showTargetFeedback(Request request) {
        if (!this.isActive()) {
            return;
        }
        EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            i.next().showTargetFeedback(request);
        }
    }

    public String toString() {
        String c = this.getClass().getName();
        c = c.substring(c.lastIndexOf(46) + 1);
        return String.valueOf(c) + "( " + this.getModel() + " )";
    }

    public boolean understandsRequest(Request req) {
        EditPolicyIterator iter = this.getEditPolicyIterator();
        while (iter.hasNext()) {
            if (!iter.next().understandsRequest(req)) continue;
            return true;
        }
        return false;
    }

    protected void unregister() {
        this.unregisterAccessibility();
        this.unregisterVisuals();
        this.unregisterModel();
    }

    protected final void unregisterAccessibility() {
        if (this.getAccessibleEditPart() != null) {
            this.getViewer().unregisterAccessibleEditPart(this.getAccessibleEditPart());
        }
    }

    protected void unregisterModel() {
        Map registry = this.getViewer().getEditPartRegistry();
        if (registry.get(this.getModel()) == this) {
            registry.remove(this.getModel());
        }
    }

    protected void unregisterVisuals() {
    }

    protected static class EditPolicyIterator {
        private Object[] list;
        private int offset = 0;
        private final int length;

        EditPolicyIterator(Object[] list) {
            this.list = list;
            this.length = list == null ? 0 : list.length;
        }

        public EditPolicyIterator(List list) {
            this(list.toArray());
        }

        public EditPolicy next() {
            if (this.offset < this.length) {
                return (EditPolicy)this.list[this.offset++];
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.list != null) ** GOTO lbl4
            return false;
lbl-1000:
            // 1 sources

            {
                ++this.offset;
lbl4:
                // 2 sources

                ** while (this.offset < this.list.length && !(this.list[this.offset] instanceof EditPolicy))
            }
lbl5:
            // 1 sources

            return this.offset < this.list.length;
        }
    }
}

