/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srvext;

import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.server.ServerLogin;
import org.eclipse.statet.rj.server.srvext.Client;

public abstract class ServerAuthMethod {
    private static final Logger LOGGER = Logger.getLogger("org.eclipse.statet.rj.server.auth");
    private final String logPrefix;
    private final String id;
    private Random randomGenerator;
    private final boolean usePubkeyExchange;
    private KeyPairGenerator keyPairGenerator;
    private String pendingLoginClient;
    private long pendingLoginId;
    private KeyPair pendingLoginKeyPair;
    private String expliciteClient;

    protected static void copyAnswer(Callback[] from, Callback[] to) throws UnsupportedCallbackException {
        assert (from.length == to.length);
        int i = 0;
        while (i < from.length) {
            if (!(from[i] instanceof TextOutputCallback)) {
                if (from[i] instanceof NameCallback) {
                    ((NameCallback)to[i]).setName(((NameCallback)from[i]).getName());
                } else if (from[i] instanceof PasswordCallback) {
                    ((PasswordCallback)to[i]).setPassword(((PasswordCallback)from[i]).getPassword());
                    ((PasswordCallback)from[i]).clearPassword();
                } else if (from[i] instanceof TextInputCallback) {
                    ((TextInputCallback)to[i]).setText(((TextInputCallback)from[i]).getText());
                } else if (from[i] instanceof ChoiceCallback) {
                    int[] selectedIndexes = ((ChoiceCallback)from[i]).getSelectedIndexes();
                    if (((ChoiceCallback)from[i]).allowMultipleSelections()) {
                        ((ChoiceCallback)to[i]).setSelectedIndexes(selectedIndexes);
                    } else if (selectedIndexes.length == 1) {
                        ((ChoiceCallback)to[i]).setSelectedIndex(selectedIndexes[0]);
                    }
                } else if (from[i] instanceof ConfirmationCallback) {
                    ((ConfirmationCallback)to[i]).setSelectedIndex(((ConfirmationCallback)from[i]).getSelectedIndex());
                } else if (from[i] instanceof LanguageCallback) {
                    ((LanguageCallback)to[i]).setLocale(Locale.getDefault());
                } else {
                    throw new UnsupportedCallbackException(to[i]);
                }
            }
            ++i;
        }
    }

    protected ServerAuthMethod(String id, boolean usePubkeyExchange) {
        this.usePubkeyExchange = usePubkeyExchange;
        this.id = id;
        this.logPrefix = "[Auth:" + id + "]";
    }

    public void setExpliciteClient(String client) {
        this.expliciteClient = client;
    }

    private String getCallingClient() throws ServerNotActiveException {
        if (this.expliciteClient != null) {
            return this.expliciteClient;
        }
        return RemoteServer.getClientHost();
    }

    public boolean isValid(Client client) {
        try {
            return this.getCallingClient().equals(client.clientId);
        }
        catch (ServerNotActiveException e) {
            return false;
        }
    }

    public final void init(String arg) throws RjException {
        try {
            if (this.usePubkeyExchange) {
                this.keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                this.keyPairGenerator.initialize(2048);
            }
            this.randomGenerator = new SecureRandom();
            this.doInit(arg);
        }
        catch (Exception e) {
            RjException rje = e instanceof RjException ? (RjException)e : new RjInitFailedException("An error occurred when initializing authentication method '" + this.id + "'.", e);
            throw rje;
        }
    }

    protected final Random getRandom() {
        return this.randomGenerator;
    }

    protected abstract void doInit(String var1) throws RjException;

    public final ServerLogin createLogin() throws RjException {
        try {
            long nextId;
            String client = this.getCallingClient();
            boolean same = client.equals(this.pendingLoginClient);
            this.pendingLoginClient = client;
            LOGGER.log(Level.INFO, "{0} creating new login ({1}).", new Object[]{this.logPrefix, client});
            while ((nextId = this.randomGenerator.nextLong()) == this.pendingLoginId) {
            }
            this.pendingLoginId = nextId;
            if (this.usePubkeyExchange && (this.pendingLoginKeyPair == null || !same)) {
                this.pendingLoginKeyPair = this.keyPairGenerator.generateKeyPair();
            }
            return this.createNewLogin(this.doCreateLogin());
        }
        catch (Exception e) {
            RjException rje = e instanceof RjException ? (RjException)e : new RjException("An unexpected error occurred when preparing login process.", e);
            throw rje;
        }
    }

    protected abstract Callback[] doCreateLogin() throws RjException;

    private ServerLogin createNewLogin(Callback[] callbacks) {
        if (this.usePubkeyExchange) {
            return new ServerLogin(this.pendingLoginId, this.pendingLoginKeyPair.getPublic(), callbacks);
        }
        return new ServerLogin(this.pendingLoginId, null, callbacks);
    }

    public final Client performLogin(ServerLogin login) throws RjException, LoginException {
        String client = null;
        try {
            client = this.getCallingClient();
            if (login.getId() != this.pendingLoginId || !client.equals(this.pendingLoginClient)) {
                throw new FailedLoginException("Login process was interrupted by another client.");
            }
            login.readAnswer(this.usePubkeyExchange ? this.pendingLoginKeyPair.getPrivate() : null);
            this.pendingLoginKeyPair = null;
            String name = this.doPerformLogin(login.getCallbacks());
            LOGGER.log(Level.INFO, "{0} performing login completed successfull: {1} ({2}).", new Object[]{this.logPrefix, name, client});
            Client client2 = new Client(name, this.getCallingClient(), 0);
            return client2;
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                LogRecord log = new LogRecord(Level.INFO, "{0} performing login failed ({1}).");
                log.setParameters(new Object[]{this.logPrefix, client});
                log.setThrown(e);
                LOGGER.log(log);
                throw (LoginException)e;
            }
            if (e instanceof RjException) {
                throw (RjException)e;
            }
            throw new RjException("An unexpected error occurred when validating the login credential.", e);
        }
        finally {
            System.gc();
        }
    }

    protected abstract String doPerformLogin(Callback[] var1) throws LoginException, RjException;
}

