/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.rh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.server.RjsException;
import org.eclipse.statet.rj.server.rh.Handle;
import org.eclipse.statet.rj.server.rh.RhDisposable;
import org.eclipse.statet.rj.server.rh.RhEngine;
import org.eclipse.statet.rj.server.rh.RhEnv;
import org.eclipse.statet.rj.server.rh.RhRef;
import org.eclipse.statet.rj.server.rh.RhRefListener;

@NonNullByDefault
public class ObjectManager {
    private static final Logger LOGGER = Logger.getLogger("org.eclipse.statet.rj.server");
    public static final char NO_REF = '0';
    public static final char STRONG_REF = 's';
    public static final char WEAK_REF = 'w';
    private static final String SEARCH_PATH_KEY = "#s:sys.SearchPath";
    private static final String STACK_FRAMES_KEY = "#0:sys.StackFrames";
    protected final RhEngine engine;
    private final Map<Handle, RhEnv> registeredEnvs = new HashMap<Handle, RhEnv>();
    private final RhRefListener envFinalizer;
    private final CopyOnWriteIdentityListSet<EnvListener> envListeners = new CopyOnWriteIdentityListSet();
    private ImList<RhEnv> searchPath = ImCollections.emptyList();
    private final CopyOnWriteIdentityListSet<SearchPathListener> searchPathListeners = new CopyOnWriteIdentityListSet();
    private List<RhEnv> stackFrames = ImCollections.emptyList();
    private final List<RhDisposable> toDispose = new ArrayList<RhDisposable>();

    private boolean isEqualHandles(List<Handle> handles, List<RhEnv> envs) {
        int l = handles.size();
        if (l == envs.size()) {
            int i = 0;
            while (i < l) {
                if (!handles.get(i).equals(envs.get((int)i).handle)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public ObjectManager(RhEngine engine) {
        this.engine = engine;
        this.envFinalizer = new RhRefListener(){

            @Override
            public void onFinalized(RhRef ref) {
                RhEnv env = (RhEnv)ObjectManager.this.registeredEnvs.remove(ref.handle);
                if (env != null) {
                    ObjectManager.this.onEnvRemoved(env, true);
                }
            }
        };
    }

    public RhEnv getEnv(Handle handle) {
        RhEnv env = this.registeredEnvs.get(handle);
        if (env == null) {
            env = new RhEnv(this.engine, handle, this.envFinalizer);
            this.registeredEnvs.put(handle, env);
        }
        return env;
    }

    private void checkEnv(RhEnv env) {
        if (!env.isRegAny() && this.registeredEnvs.remove(env.handle, env)) {
            this.onEnvRemoved(env, false);
        }
    }

    private void checkEnv(RhEnv env, Iterator<?> iter) {
        if (!env.isRegAny()) {
            iter.remove();
            this.onEnvRemoved(env, false);
        }
    }

    private void onEnvRemoved(RhEnv env, boolean finalized) {
        env.dispose();
        for (EnvListener listener : this.envListeners) {
            try {
                listener.onEnvRemoved(env, finalized);
            }
            catch (Exception e) {
                LogRecord record = new LogRecord(Level.SEVERE, "An error occurred in EnvListener.onEnvRemoved({0}, {1}).");
                record.setParameters(new Object[]{env, finalized});
                record.setThrown(e);
                LOGGER.log(record);
            }
        }
    }

    public RhEnv registerEnv(Handle handle, String key) {
        RhEnv env = this.getEnv(handle);
        env.addReg(key);
        return env;
    }

    public @Nullable RhEnv unregisterEnv(Handle handle, String key) {
        RhEnv env = this.registeredEnvs.get(handle);
        if (env != null && env.removeReg(key)) {
            this.checkEnv(env);
            return env;
        }
        return null;
    }

    public void unregisterEnvs(String key) {
        Iterator<RhEnv> iter = this.registeredEnvs.values().iterator();
        while (iter.hasNext()) {
            RhEnv env = iter.next();
            if (!env.removeReg(key)) continue;
            this.checkEnv(env, iter);
        }
    }

    public Collection<RhEnv> getEnvs() {
        return this.registeredEnvs.values();
    }

    public @Nullable RhEnv getParentEnv(RhEnv env) throws RjsException {
        Handle handle = this.engine.getParentEnv(env.handle);
        return handle != null ? this.getEnv(handle) : null;
    }

    public void addEnvListener(EnvListener listener) {
        this.envListeners.add((Object)listener);
    }

    public void removeEnvListener(EnvListener listener) {
        this.envListeners.remove((Object)listener);
    }

    public void clean() {
        Iterator<RhEnv> iter = this.registeredEnvs.values().iterator();
        while (iter.hasNext()) {
            RhEnv env = iter.next();
            this.checkEnv(env, iter);
        }
    }

    public ImList<RhEnv> getSearchPath() {
        return this.searchPath;
    }

    public void updateSearchPath() throws RjsException {
        List<Handle> handles = this.engine.getSearchPath();
        if (this.isEqualHandles(handles, (List<RhEnv>)this.searchPath)) {
            return;
        }
        Object[] envs = new RhEnv[handles.size()];
        ArrayList<RhEnv> addedEnvs = new ArrayList<RhEnv>();
        ArrayList<RhEnv> removedEnvs = new ArrayList<RhEnv>((Collection<RhEnv>)this.searchPath);
        int i = 0;
        while (i < envs.length) {
            Handle handle = handles.get(i);
            RhEnv env = this.getEnv(handle);
            if (env.addReg(SEARCH_PATH_KEY)) {
                addedEnvs.add(env);
            } else {
                removedEnvs.remove(env);
            }
            envs[i] = env;
            ++i;
        }
        this.searchPath = ImCollections.newList((Object[])envs);
        this.onSearchPathChanged((List<RhEnv>)this.searchPath, (List<RhEnv>)addedEnvs, (List<RhEnv>)removedEnvs);
        for (RhEnv env : removedEnvs) {
            if (!env.removeReg(SEARCH_PATH_KEY)) continue;
            this.checkEnv(env);
        }
    }

    private void onSearchPathChanged(List<RhEnv> searchPath, List<RhEnv> added, List<RhEnv> removed) {
        for (SearchPathListener listener : this.searchPathListeners) {
            try {
                listener.onSearchPathChanged(searchPath, added, removed);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "An error occurred.", e);
            }
        }
    }

    public void updateStackFrames() throws RjsException {
        List<Handle> handles = this.engine.getStackFrames();
        if (this.isEqualHandles(handles, this.stackFrames)) {
            return;
        }
        Object[] envs = new RhEnv[handles.size()];
        ArrayList<RhEnv> addedEnvs = new ArrayList<RhEnv>();
        ArrayList<RhEnv> removedEnvs = new ArrayList<RhEnv>(this.stackFrames);
        int i = 0;
        while (i < envs.length) {
            Handle handle = handles.get(i);
            RhEnv env = this.getEnv(handle);
            if (env.addReg(STACK_FRAMES_KEY)) {
                addedEnvs.add(env);
            } else {
                removedEnvs.remove(env);
            }
            envs[i] = env;
            ++i;
        }
        this.stackFrames = ImCollections.newList((Object[])envs);
        for (RhEnv env : removedEnvs) {
            if (!env.removeReg(STACK_FRAMES_KEY)) continue;
            this.checkEnv(env);
        }
    }

    public List<RhEnv> getStackFrames() {
        return this.stackFrames;
    }

    public void update() throws RjsException {
        this.clean();
        this.updateSearchPath();
        this.updateStackFrames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToDispose(RhDisposable disposable) {
        ObjectManager objectManager = this;
        synchronized (objectManager) {
            this.toDispose.add(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJobs() {
        ImList disposables;
        ObjectManager objectManager = this;
        synchronized (objectManager) {
            disposables = ImCollections.clearToList(this.toDispose);
        }
        for (RhDisposable disposable : disposables) {
            disposable.dispose(this.engine);
        }
    }

    public static interface EnvListener {
        public void onEnvRemoved(RhEnv var1, boolean var2);
    }

    public static interface SearchPathListener {
        public void onSearchPathChanged(List<RhEnv> var1, List<RhEnv> var2, List<RhEnv> var3);
    }
}

