/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class CommonmarkLocator
implements Locator {
    private int lineNumber;
    private int lineOffset;
    private int lineLength;
    private int lineSegmentStartOffset;
    private int lineSegmentEndOffset;

    public void setLine(Line line) {
        this.lineNumber = line.getLineNumber() + 1;
        this.lineOffset = line.getStartOffset();
        this.lineLength = line.getLength();
        this.lineSegmentStartOffset = 0;
        this.lineSegmentEndOffset = this.lineLength;
    }

    public void setBlockBegin(SourceBlockItem<?> blockItem) {
        ImList<Line> lines = blockItem.getLines();
        this.setLine((Line)lines.get(0));
    }

    public void setBlockEnd(SourceBlockItem<?> blockItem) {
        ImList<Line> lines = blockItem.getLines();
        Line lastLine = (Line)lines.get(lines.size() - 1);
        this.lineNumber = lastLine.getLineNumber();
        this.lineOffset = lastLine.getStartOffset() + lastLine.getLength();
        this.lineLength = 0;
        this.lineSegmentStartOffset = 0;
        this.lineSegmentEndOffset = 0;
    }

    public void setInline(Inline inline) {
        Line line = inline.getLine();
        this.lineNumber = line.getLineNumber() + 1;
        this.lineOffset = line.getStartOffset();
        this.lineLength = line.getText().length();
        this.lineSegmentStartOffset = inline.getStartOffset() - this.lineOffset;
        this.lineSegmentEndOffset = this.lineSegmentStartOffset + inline.getLength();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineDocumentOffset() {
        return this.lineOffset;
    }

    public int getDocumentOffset() {
        return this.getLineDocumentOffset() + this.getLineCharacterOffset();
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getLineCharacterOffset() {
        return this.lineSegmentStartOffset;
    }

    public int getLineSegmentEndOffset() {
        return this.lineSegmentEndOffset;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(Locator.class, this.getClass());
        sb.addProp("line", this.lineNumber);
        sb.append(" [%1$s, %2$s)", this.lineOffset, this.lineOffset + this.lineLength);
        sb.addProp("lineSegment", "[%1$s, %2$s)", new Object[]{this.lineSegmentStartOffset, this.lineSegmentEndOffset});
        return sb.build();
    }
}

