/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.sourcelookup;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.statet.ecommons.text.ISourceFragment;
import org.eclipse.statet.ecommons.text.core.util.ImmutableDocument;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.rj.renv.core.REnv;

public class RRuntimeSourceFragment
implements ISourceFragment {
    private final RProcess process;
    private final String id;
    private final String name;
    private final String fullName;
    private final AbstractDocument document;

    public RRuntimeSourceFragment(RProcess process, String name, String fullName, String source) {
        this.process = process;
        this.name = name;
        this.fullName = fullName;
        this.document = new ImmutableDocument(source, System.currentTimeMillis());
        this.id = "r:" + this.process.getLabel(0) + '-' + this.process.getStartupTimestamp() + '/' + this.fullName + '-' + source.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public RProcess getProcess() {
        return this.process;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public AbstractDocument getDocument() {
        return this.document;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == ToolProcess.class) {
            return (T)this.process;
        }
        if (adapterType == REnv.class) {
            return (T)this.process.getAdapter(REnv.class);
        }
        return null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RRuntimeSourceFragment)) {
            return false;
        }
        RRuntimeSourceFragment other = (RRuntimeSourceFragment)obj;
        return this.id.equals(other.id) && this.process.equals(other.process) && this.fullName.equals(other.fullName) && this.document.equals(other.document);
    }

    public String toString() {
        return this.fullName;
    }
}

