/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.List;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.elements.ISourceElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.r.core.model.IRLangElement;
import org.eclipse.statet.r.core.model.RChunkElement;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;

public class RSourceCodeAdapter
extends RRefactoringAdapter {
    protected void getSourceCode(ISourceElement element, AbstractDocument doc, BasicHeuristicTokenScanner scanner, List<String> codeFragments) throws BadLocationException, BadPartitioningException {
        if (element instanceof IRLangElement) {
            if (element instanceof RChunkElement) {
                List components = (List)element.getAdapter(SourceComponent.class);
                for (SourceComponent component : components) {
                    TextRegion range = this.expandSourceRange(component.getStartOffset(), component.getEndOffset(), doc, scanner);
                    if (range == null || range.getLength() <= 0) continue;
                    codeFragments.add(doc.get(range.getStartOffset(), range.getLength()));
                }
                return;
            }
            super.getSourceCode(element, doc, scanner, codeFragments);
            return;
        }
        if (element instanceof ISourceStructElement) {
            List children = ((ISourceStructElement)element).getSourceChildren(null);
            for (ISourceStructElement child : children) {
                this.getSourceCode((ISourceElement)child, doc, scanner, codeFragments);
            }
        }
    }
}

