/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.base.ui.contentfilter.IFilterPage;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.ui.dataeditor.CopyDataHandler;
import org.eclipse.statet.internal.r.ui.dataeditor.FindDialogHandler;
import org.eclipse.statet.internal.r.ui.dataeditor.GotoCellHandler;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataEditorOutlinePage;
import org.eclipse.statet.internal.r.ui.dataeditor.RefreshHandler;
import org.eclipse.statet.internal.r.ui.dataeditor.SelectAllHandler;
import org.eclipse.statet.internal.r.ui.datafilterview.RDataFilterPage;
import org.eclipse.statet.r.ui.dataeditor.IRDataEditorInput;
import org.eclipse.statet.r.ui.dataeditor.IRDataTableCallbacks;
import org.eclipse.statet.r.ui.dataeditor.IRDataTableInput;
import org.eclipse.statet.r.ui.dataeditor.RDataTableComposite;
import org.eclipse.statet.r.ui.dataeditor.RDataTableSelection;
import org.eclipse.statet.r.ui.dataeditor.RLiveDataEditorInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class RDataEditor
extends EditorPart {
    private RDataTableComposite table;
    private ContextHandlers handlers;
    private final ActivationListener activationListener = new ActivationListener();
    private RDataEditorOutlinePage outlinePage;
    private RDataFilterPage filterPage;
    private final IRDataTableInput.StateListener inputStateListener = new IRDataTableInput.StateListener(){

        @Override
        public void tableUnavailable() {
            RDataEditor.this.close(false);
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        try {
            this.doSetInput(input);
        }
        catch (CoreException e) {
            throw new PartInitException("The R data editor could not be initialized.");
        }
    }

    public void dispose() {
        this.getEditorSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.activationListener);
        if (this.handlers != null) {
            this.handlers.dispose();
            this.handlers = null;
        }
        this.disposeTableInput();
        super.dispose();
    }

    protected void setInput(IEditorInput input) {
        this.setInputWithNotify(input);
    }

    protected void setInputWithNotify(IEditorInput input) {
        try {
            this.doSetInput(input);
            this.firePropertyChange(258);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", "An error occurred when opening the element.", (Throwable)e));
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (!(input instanceof RLiveDataEditorInput)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, NLS.bind((String)"The element ''{0}'' is not supported by the R data editor.", (Object)input.getName()), null));
        }
        super.setInput(input);
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    public RDataTableComposite getRDataTable() {
        return this.table;
    }

    public boolean isDirty() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void createPartControl(Composite parent) {
        this.table = new RDataTableComposite(parent, new Callbacks());
        this.getEditorSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.activationListener);
        IWorkbenchPartSite site = this.getSite();
        this.handlers = new ContextHandlers((IHandlerService)site.getService(IHandlerService.class));
        this.initActions((IServiceLocator)site, this.handlers);
        this.initStatusLine();
        this.initTableInput();
    }

    private void initTableInput() {
        IRDataTableInput tableInput;
        IRDataEditorInput editorInput = (IRDataEditorInput)this.getEditorInput();
        if (editorInput != null && (tableInput = editorInput.getRDataTableInput()) != null) {
            tableInput.addStateListener(this.inputStateListener);
            if (tableInput.isAvailable()) {
                this.table.setInput(tableInput);
            } else {
                this.close(false);
            }
        }
    }

    private void disposeTableInput() {
        IRDataTableInput tableInput;
        IRDataEditorInput editorInput = (IRDataEditorInput)this.getEditorInput();
        if (editorInput != null && (tableInput = editorInput.getRDataTableInput()) != null) {
            tableInput.removeStateListener(this.inputStateListener);
        }
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        WorkbenchUIUtils.activateContext((IServiceLocator)serviceLocator, (String)"org.eclipse.statet.r.contexts.RDataEditor");
        AbstractHandler handler = new RefreshHandler(this.table);
        handlers.addActivate("org.eclipse.ui.file.refresh", (IHandler2)handler);
        handler = new SelectAllHandler(this.table);
        handlers.addActivate("org.eclipse.ui.edit.selectAll", (IHandler2)handler);
        handler = new CopyDataHandler(this.table);
        handlers.addActivate("org.eclipse.ui.edit.copy", (IHandler2)handler);
        handler = new FindDialogHandler((IWorkbenchPart)this);
        handlers.addActivate("org.eclipse.ui.edit.findReplace", (IHandler2)handler);
        handler = new GotoCellHandler(this.table);
        handlers.addActivate("org.eclipse.ui.edit.text.goto.line", (IHandler2)handler);
    }

    protected void initStatusLine() {
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStatusLineManager manager = RDataEditor.this.getEditorSite().getActionBars().getStatusLineManager();
                RDataTableSelection selection = (RDataTableSelection)event.getSelection();
                RDataEditor.this.updateStatusLine();
                if (selection.getAnchorRowLabel() != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(selection.getAnchorRowLabel());
                    if (!selection.getAnchorRowLabel().isEmpty() && !selection.getAnchorColumnLabel().isEmpty()) {
                        sb.append(", ");
                    }
                    sb.append(selection.getAnchorColumnLabel());
                    if (selection.getLastSelectedCellRowLabel() != null) {
                        sb.append(" (");
                        sb.append(selection.getLastSelectedCellRowLabel());
                        if (!selection.getLastSelectedCellRowLabel().isEmpty() && !selection.getLastSelectedCellColumnLabel().isEmpty()) {
                            sb.append(", ");
                        }
                        sb.append(selection.getLastSelectedCellColumnLabel());
                        sb.append(")");
                    }
                    manager.setMessage(sb.toString());
                } else {
                    manager.setMessage(null);
                }
            }
        });
    }

    private void updateStatusLine() {
        IStatusLineManager manager = this.getEditorSite().getActionBars().getStatusLineManager();
        IContributionItem dimItem = manager.find("data.dimension");
        long[] dimension = this.table.getTableDimension();
        if (dimItem != null) {
            ((StatusLineContributionItem)dimItem).setText(dimension != null ? "Dim: " + dimension[0] + " \u00d7 " + dimension[1] : "");
        }
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                RDataEditor.this.getSite().getPage().closeEditor((IEditorPart)RDataEditor.this, save);
            }
        });
    }

    protected RDataEditorOutlinePage createOutlinePage() {
        return new RDataEditorOutlinePage(this);
    }

    protected RDataFilterPage createFilterPage() {
        return new RDataFilterPage(this);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == RDataTableComposite.class) {
            return (T)((Object)this.table);
        }
        if (adapterType == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
            }
            return (T)((Object)this.outlinePage);
        }
        if (adapterType == IFilterPage.class) {
            if (this.filterPage == null) {
                this.filterPage = this.createFilterPage();
            }
            return (T)((Object)this.filterPage);
        }
        return (T)super.getAdapter(adapterType);
    }

    private class ActivationListener
    implements IPartListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == RDataEditor.this) {
                RDataEditor.this.updateStatusLine();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    }

    private class Callbacks
    implements IRDataTableCallbacks {
        private Callbacks() {
        }

        @Override
        public boolean isCloseSupported() {
            return true;
        }

        @Override
        public void close() {
            RDataEditor.this.close(false);
        }

        @Override
        public IServiceLocator getServiceLocator() {
            return RDataEditor.this.getSite();
        }

        @Override
        public void show(IStatus status) {
            StatusManager.getManager().handle(status);
        }
    }
}

