/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.shared.common.error.StandardException;

public class HarmonySerialBlob
implements Blob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8144641928112860441L;
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;

    public HarmonySerialBlob(Blob blob) throws SQLException {
        if (blob == null) {
            throw new IllegalArgumentException();
        }
        this.blob = blob;
        this.buf = blob.getBytes(1L, (int)blob.length());
        this.origLen = this.len = (long)this.buf.length;
    }

    public HarmonySerialBlob(byte[] buf) {
        this.buf = new byte[buf.length];
        this.origLen = this.len = (long)buf.length;
        System.arraycopy(buf, 0, this.buf, 0, (int)this.len);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L || pos > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{pos});
        }
        if (length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{length});
        }
        if ((long)length > this.len - pos + 1L) {
            length = (int)(this.len - pos + 1L);
        }
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.buf, (int)pos - 1, copiedArray, 0, length);
        return copiedArray;
    }

    @Override
    public long length() throws SQLException {
        return this.len;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(patternBytes, start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (start < 1L || this.len - (start - 1L) < (long)pattern.length) {
            return -1L;
        }
        int i = (int)(start - 1L);
        while ((long)i <= this.len - (long)pattern.length) {
            if (this.match(this.buf, i, pattern)) {
                return i + 1;
            }
            ++i;
        }
        return -1L;
    }

    private boolean match(byte[] bytes, int start, byte[] subBytes) {
        int i = 0;
        while (i < subBytes.length) {
            if (bytes[start++] == subBytes[i++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.blob == null) {
            throw new IllegalStateException();
        }
        OutputStream os = this.blob.setBinaryStream(pos);
        if (os == null) {
            throw new IllegalStateException();
        }
        return os;
    }

    @Override
    public int setBytes(long pos, byte[] theBytes) throws SQLException {
        return this.setBytes(pos, theBytes, 0, theBytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] theBytes, int offset, int length) throws SQLException {
        if (pos < 1L || length < 0 || pos > this.len - (long)length + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{pos});
        }
        if (offset < 0 || length < 0 || offset > theBytes.length - length) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", new Object[]{offset});
        }
        System.arraycopy(theBytes, offset, this.buf, (int)pos - 1, length);
        return length;
    }

    @Override
    public void truncate(long length) throws SQLException {
        if (length > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{this.len});
        }
        this.buf = this.getBytes(1L, (int)length);
        this.len = length;
    }

    @Override
    public void free() throws SQLException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (this.len < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{this.len});
        }
        if (length < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{length});
        }
        if (pos < 1L || pos + length > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ087.S", new Object[]{pos, length});
        }
        return new ByteArrayInputStream(this.buf, (int)(pos - 1L), (int)length);
    }

    public static SQLException makeSQLException(String messageID, Object[] args) {
        StandardException se = StandardException.newException(messageID, args);
        return new SQLException(se.getMessage(), se.getSQLState());
    }
}

