/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.variables.core.DynamicVariable;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DocProcessingConfig {
    public static final String BASE_MAIN_ATTR_QUALIFIER = "org.eclipse.statet.docmlet.base/main";
    public static final String WORKING_DIRECTORY_ATTR_NAME = "org.eclipse.statet.docmlet.base/main/WorkingDirectory.path";
    public static final String BASE_PREVIEW_ATTR_QUALIFIER = "org.eclipse.statet.docmlet.base/preview";
    public static final String STEP_ENABLED_ATTR_KEY = "Run.enabled";
    public static final String STEP_OUTPUT_FORMAT_ATTR_KEY = "Output.Format.key";
    public static final String STEP_OUTPUT_FILE_PATH_ATTR_KEY = "Output.File.path";
    public static final String STEP_OPERATION_ID_ATTR_KEY = "Operation.id";
    public static final String STEP_OPERATION_SETTINGS_ATTR_KEY = "Operation.settings";
    public static final String STEP_POST_CHECK_OUTPUT_ENABLED_ATTR_KEY = "Post.CheckOutput.enabled";
    public static final String STEP_POST_OPEN_OUTPUT_ENABLED_ATTR_KEY = "Post.OpenOutput.enabled";
    public static final String WD_LOC_VAR_NAME = "wd_loc";
    public static final String WD_PATH_VAR_NAME = "wd_path";
    public static final String SOURCE_FILE_PATH_VAR_NAME = "source_file_path";
    public static final String OUT_FILE_PATH_VAR_NAME = "out_file_path";
    public static final String OUT_FILE_EXT_VAR_NAME = "out_file_ext";
    public static final IDynamicVariable SOURCE_FILE_PATH_VAR = new DynamicVariable("source_file_path", Messages.Variable_SourceFilePath_description, false);
    @Deprecated
    public static final IDynamicVariable IN_FILE_PATH_VAR = new DynamicVariable("in_file_path", Messages.Variable_InFilePath_description, false);
    public static final IDynamicVariable OUT_FILE_PATH_VAR = new DynamicVariable("out_file_path", Messages.Variable_OutFilePath_description, false);
    public static final IDynamicVariable OUT_FILE_EXT_VAR = new DynamicVariable("out_file_ext", Messages.Variable_OutFileExt_description, false);
    public static final String SOURCE_FORMAT_KEY = "source";
    public static final String AUTO_YAML_FORMAT_KEY = "auto:by-indoc-yaml";
    public static final String EXT_LTX_FORMAT_KEY = "ext:ltx";
    public static final String EXT_PDF_FORMAT_KEY = "ext:pdf";
    public static final String EXT_HTML_FORMAT_KEY = "ext:html";
    public static final String EXT_OTHER_FORMAT_KEY = "ext:";
    public static final Format AUTO_YAML_FORMAT = new Format("auto:by-indoc-yaml", Messages.Format_AutoByInDocYaml_label, "*"){

        @Override
        public @Nullable String getExt(@Nullable String inputExt) {
            return "* (YAML)";
        }
    };
    public static final Format EXT_LTX_FORMAT = new Format("ext:ltx", "LaTeX", "ltx");
    public static final Format EXT_PDF_FORMAT = new Format("ext:pdf", "PDF", "pdf");
    public static final Format EXT_HTML_FORMAT = new Format("ext:html", "HTML", "html");
    public static final Format EXT_OTHER_FORMAT = new CustomExtFormat("ext:", Messages.Format_Other_label, Messages.Format_Other_Info_label, "");
    public static final Pattern VALID_EXT_PATTERN = Pattern.compile("[\\p{Alnum}\\-,;_~]+");

    public static Format createSourceFormat(String formatLabel) {
        return new Format(SOURCE_FORMAT_KEY, NLS.bind((String)Messages.Format_SourceDoc_label, (Object)formatLabel), ""){

            @Override
            public @Nullable String getExt(@Nullable String inputExt) {
                return inputExt;
            }
        };
    }

    public static Format createOutputFormat(Format format) {
        return new Format(format.getKey(), NLS.bind((String)Messages.Format_Output_label, (Object)format.getInfoLabel()), format.getExt());
    }

    public static @Nullable Format getFormat(List<Format> formats, @Nullable String key) {
        if (key == null) {
            return null;
        }
        for (Format aFormat : formats) {
            if (!aFormat.matches(key)) continue;
            return aFormat;
        }
        return null;
    }

    public static @Nullable Format getFormat(List<Format> formats, @Nullable Format defaultFormat, @Nullable String key) {
        int idx;
        if (key == null) {
            return null;
        }
        Format format = defaultFormat;
        for (Format aFormat : formats) {
            if (!aFormat.matches(key)) continue;
            format = aFormat;
            break;
        }
        if (format instanceof CustomExtFormat && (idx = key.indexOf(58)) >= 0 && idx + 1 < key.length()) {
            format = new CustomExtFormat((CustomExtFormat)format, key.substring(idx + 1));
        }
        return format;
    }

    public static class CustomExtFormat
    extends Format {
        private final String baseKey;

        private static String checkKey(String key, String ext) {
            if (key.isEmpty() || key.charAt(key.length() - 1) != ':') {
                throw new IllegalArgumentException("key= " + key);
            }
            return key + ext;
        }

        public CustomExtFormat(String key, String label, @Nullable String infoLabel, String ext) {
            super(CustomExtFormat.checkKey(key, ext), label, infoLabel, ext);
            this.baseKey = key;
        }

        public CustomExtFormat(CustomExtFormat format, String ext) {
            super(format, format.getBaseKey() + ext, ext);
            this.baseKey = format.getBaseKey();
        }

        public String getBaseKey() {
            return this.baseKey;
        }

        @Override
        boolean matches(String key) {
            return key.startsWith(this.baseKey);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) && this.baseKey.equals(((CustomExtFormat)obj).baseKey);
        }
    }

    public static class Format {
        public static final String SOURCE_TYPE = "source";
        public static final String AUTO_TYPE = "auto";
        public static final String EXT_TYPE = "ext";
        private final String key;
        private final String label;
        private final @Nullable String infoLabel;
        private final String ext;

        public Format(String key, String label, String ext) {
            this(key, label, null, ext);
        }

        public Format(String key, String label, @Nullable String infoLabel, String ext) {
            this.key = key;
            this.label = label;
            this.infoLabel = infoLabel;
            this.ext = ext;
        }

        Format(Format format, String key, String ext) {
            this.key = key;
            this.label = format.label;
            this.infoLabel = format.infoLabel;
            this.ext = ext;
        }

        public String getKey() {
            return this.key;
        }

        boolean matches(String key) {
            return key.equals(this.key);
        }

        public String getExt() {
            return this.ext;
        }

        public String getLabel() {
            return this.label;
        }

        public String getInfoLabel() {
            return this.infoLabel != null ? NLS.bind((String)this.infoLabel, (Object)this.ext) : this.label;
        }

        public @Nullable String getExt(@Nullable String inputExt) {
            return this.ext;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                Format other = (Format)obj;
                return this.key.equals(other.key) && this.label.equals(other.label) && Objects.equals(this.infoLabel, other.infoLabel) && Objects.equals(this.ext, other.ext);
            }
            return false;
        }

        public String toString() {
            return this.getLabel();
        }
    }
}

