/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.NoSuchElementException;
import java.util.stream.LongStream;
import org.eclipse.statet.internal.jcommons.collections.AbstractImLongList;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.collections.LongListIterator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImLongSeqList
extends AbstractImLongList {
    private final long e0;
    private final int length;

    public ImLongSeqList(long e0, int length) {
        this.e0 = e0;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(long e) {
        long index = e - this.e0;
        return index >= 0L && index < (long)this.length;
    }

    @Override
    public long getAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.e0 + (long)index;
    }

    @Override
    public long getFirst() {
        return this.e0;
    }

    @Override
    public long getLast() {
        return this.e0 + (long)this.length - 1L;
    }

    @Override
    public int indexOf(long e) {
        long index = e - this.e0;
        if (index >= 0L && index < (long)this.length) {
            return (int)index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long e) {
        long index = e - this.e0;
        if (index >= 0L && index < (long)this.length) {
            return (int)index;
        }
        return -1;
    }

    @Override
    public LongListIterator iterator() {
        return new Iter(0);
    }

    @Override
    public LongListIterator listIterator(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return new Iter(index);
    }

    @Override
    public LongStream stream() {
        return LongStream.range(this.e0, this.e0 + (long)this.length);
    }

    @Override
    public long[] toArray() {
        long[] dest = new long[this.length];
        long e = this.e0;
        int i = 0;
        while (i < this.length) {
            ++e;
            ++i;
        }
        return dest;
    }

    @Override
    public void toArray(long[] array) {
        long e = this.e0;
        int i = 0;
        while (i < this.length) {
            ++e;
            ++i;
        }
    }

    @Override
    public void copyTo(int srcIndex, long[] dest, int destIndex, int length) {
        long e = this.e0 + (long)srcIndex;
        int i = 0;
        while (i < length) {
            dest[destIndex++] = e++;
            ++i;
        }
    }

    @Override
    public void copyTo(long[] dest, int destIndex) {
        long e = this.e0;
        int i = 0;
        while (i < this.length) {
            dest[destIndex++] = e++;
            ++i;
        }
    }

    public int hashCode() {
        int hashCode = 9;
        int i = 0;
        while (i < this.length) {
            hashCode = 31 * hashCode + Long.hashCode(this.e0 + (long)i);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongList) {
            LongList other = (LongList)obj;
            if (this.length != other.size()) {
                return false;
            }
            int i = 0;
            while (i < this.length) {
                if (this.e0 + (long)i != other.getAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.e0);
        int i = 1;
        while (i < this.length) {
            sb.append(", ");
            sb.append(this.e0 + (long)i);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    private class Iter
    extends AbstractImLongList.AbstractImLongListIter {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ImLongSeqList.this.length;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public long nextLong() {
            if (this.cursor >= ImLongSeqList.this.length) {
                throw new NoSuchElementException();
            }
            return ImLongSeqList.this.e0 + (long)this.cursor++;
        }

        @Override
        public Long next() {
            if (this.cursor >= ImLongSeqList.this.length) {
                throw new NoSuchElementException();
            }
            return ImLongSeqList.this.e0 + (long)this.cursor++;
        }

        @Override
        public long nextLongElse(long elseLong) {
            if (this.cursor >= ImLongSeqList.this.length) {
                return elseLong;
            }
            return ImLongSeqList.this.e0 + (long)this.cursor++;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public long previousLong() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            return ImLongSeqList.this.e0 + (long)(--this.cursor);
        }

        @Override
        public Long previous() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            return ImLongSeqList.this.e0 + (long)(--this.cursor);
        }
    }
}

