/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.text.core.HeuristicTokenScanner;
import org.eclipse.statet.ltk.ui.sourceediting.SmartInsertSettings;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public abstract class AbstractAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy
implements SourceEditorAddon,
VerifyKeyListener {
    private final SourceEditor editor;
    private final @Nullable ITextEditorExtension3 editor3;
    private final DocContentSections documentContentInfo;
    private final SourceViewer viewer;
    private AbstractDocument document;
    private TextRegion validRange;
    private boolean ignoreCommands = false;

    public AbstractAutoEditStrategy(SourceEditor editor) {
        assert (editor != null);
        this.editor = editor;
        this.documentContentInfo = this.editor.getDocumentContentInfo();
        this.viewer = this.editor.getViewer();
        this.editor3 = editor instanceof SourceEditor1 ? (SourceEditor1)editor : null;
    }

    public final SourceEditor getEditor() {
        return this.editor;
    }

    protected final @Nullable ITextEditorExtension3 getEditor3() {
        return this.editor3;
    }

    public final DocContentSections getDocumentContentInfo() {
        return this.documentContentInfo;
    }

    protected final SourceViewer getViewer() {
        return this.viewer;
    }

    protected abstract SmartInsertSettings getSettings();

    protected abstract IIndentSettings getCodeStyleSettings();

    @Override
    public void install(SourceEditor editor) {
        assert (editor.getViewer() == this.viewer);
        this.viewer.prependVerifyKeyListener((VerifyKeyListener)this);
    }

    @Override
    public void uninstall() {
        this.viewer.removeVerifyKeyListener((VerifyKeyListener)this);
    }

    protected TreePartition initCustomization(int offset, int ch) throws BadLocationException, BadPartitioningException {
        assert (this.document != null);
        TreePartition partition = (TreePartition)this.document.getPartition(this.documentContentInfo.getPartitioning(), offset, true);
        this.validRange = this.computeValidRange(offset, partition, ch);
        return this.validRange != null ? partition : null;
    }

    protected TextRegion computeValidRange(int offset, TreePartition partition, int c) {
        return new BasicTextRegion(0, this.document.getLength());
    }

    protected final AbstractDocument getDocument() {
        return this.document;
    }

    protected final TextRegion getValidRange() {
        return this.validRange;
    }

    protected abstract HeuristicTokenScanner getScanner();

    protected IndentUtil createIndentUtil(AbstractDocument doc) {
        return new IndentUtil((IDocument)doc, this.getCodeStyleSettings());
    }

    protected void quitCustomization() {
        this.document = null;
    }

    private final boolean isSmartInsertEnabled() {
        return this.editor3 != null ? this.editor3.getInsertMode() == ITextEditorExtension3.SMART_INSERT : this.getSettings().isSmartInsertEnabledByDefault();
    }

    private final boolean isBlockSelection() {
        StyledText textWidget = this.viewer.getTextWidget();
        return textWidget.getBlockSelection() && textWidget.getSelectionRanges().length > 2;
    }

    public final void verifyKey(VerifyEvent event) {
        char ch;
        if (!event.doit || (ch = this.isCustomizeKey((KeyEvent)event)) == '\u0000' || !this.isSmartInsertEnabled() || !UIAccess.isOkToUse((Viewer)this.viewer) || this.isBlockSelection()) {
            return;
        }
        try {
            this.document = (AbstractDocument)this.viewer.getDocument();
            ITextSelection selection = (ITextSelection)this.viewer.getSelection();
            TreePartition partition = this.initCustomization(selection.getOffset(), ch);
            if (partition == null) {
                return;
            }
            try {
                this.ignoreCommands = true;
                DocumentCommand command = new DocumentCommand(){};
                command.offset = selection.getOffset();
                command.length = selection.getLength();
                command.doit = true;
                command.shiftsCaret = true;
                command.caretOffset = -1;
                this.doCustomizeKeyCommand(ch, command, partition);
                event.doit = command.doit;
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, "An error occurred when customizing action for pressed key in auto edit strategy.", (Throwable)e));
            }
        }
        finally {
            this.ignoreCommands = false;
            this.quitCustomization();
        }
    }

    public final void customizeDocumentCommand(IDocument d, DocumentCommand command) {
        if (this.ignoreCommands || !command.doit || command.text == null) {
            return;
        }
        if (!this.isSmartInsertEnabled() || this.isBlockSelection()) {
            super.customizeDocumentCommand(d, command);
            return;
        }
        try {
            this.document = (AbstractDocument)d;
            TreePartition partition = this.initCustomization(command.offset, -1);
            if (partition == null) {
                return;
            }
            try {
                this.doCustomizeOtherCommand(command, partition);
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, "An error occurred when customizing action for document command in auto edit strategy.", (Throwable)e));
            }
        }
        finally {
            if (!command.doit) {
                command.text = null;
                command.length = 0;
            }
            this.quitCustomization();
        }
    }

    protected abstract char isCustomizeKey(KeyEvent var1);

    protected abstract void doCustomizeKeyCommand(char var1, DocumentCommand var2, TreePartition var3) throws Exception;

    protected abstract void doCustomizeOtherCommand(DocumentCommand var1, TreePartition var2) throws Exception;

    protected final int getChar(int offset) throws BadLocationException {
        TextRegion validRange = this.getValidRange();
        return offset >= validRange.getStartOffset() && offset < validRange.getEndOffset() ? (int)this.getDocument().getChar(offset) : -1;
    }

    protected final boolean isRegularTabCommand(DocumentCommand command) throws BadLocationException {
        return command.length == 0 || this.document.getLineOfOffset(command.offset) == this.document.getLineOfOffset(command.offset + command.length);
    }

    protected final void customizeCommandDefault(DocumentCommand command) {
        super.customizeDocumentCommand((IDocument)this.getDocument(), command);
    }

    protected final void applyCommand(DocumentCommand command) throws BadLocationException {
        this.document.replace(command.offset, command.length, command.text);
        command.doit = false;
    }

    protected final void updateSelection(DocumentCommand command) {
        if (command.caretOffset == -1) {
            command.caretOffset = command.offset + command.text.length();
        }
        TextSelection textSelection = new TextSelection((IDocument)this.document, command.caretOffset, 0);
        this.viewer.setSelection((ISelection)textSelection, true);
        command.shiftsCaret = false;
    }

    protected final boolean endsWithNewLine(String text) {
        int idx = text.length() - 1;
        while (idx >= 0) {
            char c = text.charAt(idx);
            switch (c) {
                case '\n': {
                    return true;
                }
            }
            --idx;
        }
        return false;
    }

    protected final int indexOfNewLine(String text) {
        int idx = 0;
        while (idx < text.length()) {
            char c = text.charAt(idx);
            switch (c) {
                case '\r': {
                    if (idx + 1 >= text.length() || text.charAt(idx + 1) != '\n') break;
                    return idx;
                }
                case '\n': {
                    return idx;
                }
            }
            ++idx;
        }
        return -1;
    }

    protected final boolean containsControl(String text) {
        int idx = 0;
        while (idx < text.length()) {
            if (text.charAt(idx) < ' ') {
                return true;
            }
            ++idx;
        }
        return false;
    }

    protected final SourceContent createSourceContent(AbstractDocument document, TextRegion region, DocumentCommand command) throws BadLocationException {
        StringBuilder sb = new StringBuilder(region.getLength() - command.length + command.text.length());
        sb.append(document.get(region.getStartOffset(), command.offset - region.getStartOffset()));
        sb.append(command.text);
        sb.append(document.get(command.offset + command.length, region.getEndOffset() - (command.offset + command.length)));
        return new SourceContent((long)region.getStartOffset(), sb.toString());
    }

    protected void smartInsertOnTab(DocumentCommand command, boolean indent) throws Exception {
        AbstractDocument doc = this.getDocument();
        IndentUtil indentUtil = this.createIndentUtil(doc);
        int lineNum = doc.getLineOfOffset(command.offset);
        int column = indentUtil.getColumn(lineNum, command.offset);
        if (indent) {
            HeuristicTokenScanner scanner = this.getScanner();
            scanner.configure((IDocument)doc);
            if (scanner.findAnyNonSSpaceBackward(command.offset, doc.getLineOffset(lineNum)) != -1) {
                indent = false;
            }
        }
        if (!indent) {
            if (this.getCodeStyleSettings().getReplaceOtherTabsWithSpaces()) {
                command.text = indentUtil.createTabSpacesCompletionString(column);
            }
            return;
        }
        switch (this.getSettings().getSmartInsertTabAction()) {
            case INSERT_TAB_CHAR: {
                return;
            }
            case INSERT_TAB_LEVEL: {
                command.text = indentUtil.createTabCompletionString(column);
                return;
            }
            case INSERT_INDENT_LEVEL: {
                command.text = indentUtil.createIndentCompletionString(column);
                return;
            }
            case CORRECT_INDENT: {
                command.text = indentUtil.createIndentCompletionString(column);
                this.correctIndent(command, column + 1, indentUtil);
                return;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected void correctIndent(DocumentCommand command, int minColumn, IndentUtil indentUtil) throws Exception {
        throw new UnsupportedOperationException();
    }
}

