/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable;

import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.data.ControlData;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.core.style.VerticalAlignment;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.painter.cell.AbstractTextPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class RTextPainter
extends AbstractTextPainter {
    private final StringBuilder tempText = new StringBuilder();
    private String currentText;
    private int currentTextWidth;

    private static Object getData(LayerCell cell, ConfigRegistry configRegistry) {
        IDisplayConverter displayConverter = (IDisplayConverter)configRegistry.getAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getLabels().getLabels());
        return displayConverter != null ? displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue(0, null)) : "";
    }

    public RTextPainter(int space) {
        super(false, true, space, false, false, 1);
    }

    public long getPreferredWidth(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        Object data = RTextPainter.getData(cell, configRegistry);
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((LayerCell)cell, (ConfigRegistry)configRegistry), data);
        return this.getWidthFromCache(gc, data.toString()) + this.spacing * 2;
    }

    public long getPreferredHeight(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        Object data = RTextPainter.getData(cell, configRegistry);
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((LayerCell)cell, (ConfigRegistry)configRegistry), data);
        return gc.getFontMetrics().getHeight();
    }

    protected void setupGCFromConfig(GC gc, Style cellStyle, Object data) {
        Font font;
        Color fg = (Color)cellStyle.getAttributeValue(CellStyling.FOREGROUND_COLOR);
        if (fg == null) {
            fg = GUIHelper.COLOR_LIST_FOREGROUND;
        }
        if (!(data instanceof ControlData) || (font = (Font)cellStyle.getAttributeValue(CellStyling.CONTROL_FONT)) == null) {
            font = (Font)cellStyle.getAttributeValue(CellStyling.FONT);
        }
        gc.setTextAntialias(-1);
        gc.setFont(font);
        gc.setForeground(fg);
    }

    public void paintCell(LayerCell cell, GC gc, LRectangle lRectangle, ConfigRegistry configRegistry) {
        if (this.paintBg) {
            super.paintCell(cell, gc, lRectangle, configRegistry);
        }
        Rectangle originalClipping = gc.getClipping();
        gc.setClipping(SwtUtils.toSWT((LRectangle)lRectangle).intersection(originalClipping));
        Object data = RTextPainter.getData(cell, configRegistry);
        Style cellStyle = CellStyleUtil.getCellStyle((LayerCell)cell, (ConfigRegistry)configRegistry);
        this.setupGCFromConfig(gc, cellStyle, data);
        String text = data.toString();
        long width = lRectangle.width - (long)(this.spacing * 2);
        if (gc.getFont() == null) {
            gc.setFont(null);
        }
        int contentHeight = gc.getFontMetrics().getHeight();
        text = this.getTextToDisplay(cell, gc, width, text);
        int contentWidth = this.getWidthFromCache(gc, text);
        gc.drawText(text, GraphicsUtils.safe((long)(lRectangle.x + (long)this.spacing + CellStyleUtil.getHorizontalAlignmentPadding((HorizontalAlignment)(data instanceof ControlData ? HorizontalAlignment.LEFT : (HorizontalAlignment)cellStyle.getAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT)), (long)width, (long)contentWidth))), GraphicsUtils.safe((long)(lRectangle.y + CellStyleUtil.getVerticalAlignmentPadding((VerticalAlignment)VerticalAlignment.MIDDLE, (long)lRectangle.height, (long)contentHeight))), this.swtDrawStyle);
        gc.setClipping(originalClipping);
    }
}

