/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.eclipse.statet.internal.rj.servi.APool2;
import org.eclipse.statet.internal.rj.servi.APool2NodeHandler;
import org.eclipse.statet.internal.rj.servi.APool2NodeObjectFactory;
import org.eclipse.statet.internal.rj.servi.Messages;
import org.eclipse.statet.internal.rj.servi.NodeFactory;
import org.eclipse.statet.internal.rj.servi.PoolListener;
import org.eclipse.statet.internal.rj.servi.RServiImpl;
import org.eclipse.statet.internal.rj.servi.Stats;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.server.ServerLogin;
import org.eclipse.statet.rj.servi.RServi;
import org.eclipse.statet.rj.servi.node.RServiNodeFactory;
import org.eclipse.statet.rj.servi.node.RServiPool;
import org.eclipse.statet.rj.servi.pool.PoolConfig;
import org.eclipse.statet.rj.servi.pool.PoolNodeObject;
import org.eclipse.statet.rj.servi.pool.RServiPoolManager;

@NonNullByDefault
public class PoolManager
implements RServiPool,
RServiPoolManager {
    private static final int STOP_ON_ERROR = 0x1000000;
    private final String id;
    private final @Nullable RMIRegistry registry;
    private @Nullable Remote thisRemote;
    private ImList<NodeFactory> nodeFactories = ImCollections.emptyList();
    private final Stats stats;
    private final CopyOnWriteIdentityListSet<PoolListener> poolListeners = new CopyOnWriteIdentityListSet();
    private @Nullable APool2 pool;
    private @Nullable APool2NodeObjectFactory poolObjectFactory;
    private PoolConfig poolConfig;
    private final Object resourceLock = new Object();
    private final ScheduledThreadPoolExecutor executor;
    private volatile int unclosed;

    public PoolManager(String id, @Nullable RMIRegistry registry) {
        this.id = (String)ObjectUtils.nonNullAssert((Object)id);
        this.registry = registry;
        this.stats = new Stats();
        this.poolListeners.add((Object)this.stats);
        this.poolConfig = new PoolConfig();
        this.executor = new ScheduledThreadPoolExecutor(0);
        this.configResources();
        Utils.preLoad();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ImCollection<? extends NodeFactory> getFactories() {
        return this.nodeFactories;
    }

    @Override
    public synchronized void addNodeFactory(RServiNodeFactory factory) {
        ObjectUtils.nonNullAssert((Object)factory);
        if (!this.nodeFactories.isEmpty()) {
            throw new UnsupportedOperationException("Multiple factories are not supported");
        }
        this.nodeFactories = ImCollections.newList((Object)((NodeFactory)factory));
    }

    @Override
    public synchronized void setConfig(PoolConfig config) {
        APool2 pool = this.pool;
        if (pool != null && pool.isOpen()) {
            APool2NodeObjectFactory poolObjectFactory = (APool2NodeObjectFactory)ObjectUtils.nonNullAssert((Object)this.poolObjectFactory);
            pool.setConfig(config);
            poolObjectFactory.setMaxUsageCount(config.getMaxUsageCount());
        }
        this.poolConfig = config;
    }

    @Override
    public PoolConfig getConfig() {
        return this.poolConfig;
    }

    public void addPoolListener(PoolListener listener) {
        this.poolListeners.add((Object)((PoolListener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removePoolListener(PoolListener listener) {
        this.poolListeners.remove((Object)listener);
    }

    @Override
    public synchronized void init() throws RjException {
        APool2 pool;
        APool2NodeObjectFactory poolObjectFactory = new APool2NodeObjectFactory((NodeFactory)this.nodeFactories.get(0), this.registry != null, this.poolListeners, this.executor);
        poolObjectFactory.setMaxUsageCount(this.poolConfig.getMaxUsageCount());
        this.poolObjectFactory = poolObjectFactory;
        this.pool = pool = new APool2(this.id, poolObjectFactory, this.poolConfig){

            @Override
            protected void closeFinally() {
                super.closeFinally();
                PoolManager.this.onPoolClosed(this);
            }
        };
        this.onPoolCreated(pool);
        Utils.logInfo("Publishing pool in registry...");
        RMIRegistry registry = this.registry;
        if (registry != null) {
            SslRMIClientSocketFactory clientSocketFactory = null;
            SslRMIServerSocketFactory serverSocketFactory = null;
            if (registry.getAddress().isSsl()) {
                clientSocketFactory = new SslRMIClientSocketFactory();
                serverSocketFactory = new SslRMIServerSocketFactory(null, null, true);
            }
            try {
                Remote remote;
                this.thisRemote = remote = UnicastRemoteObject.exportObject(this, 0, clientSocketFactory, serverSocketFactory);
                registry.getRegistry().rebind(PoolConfig.getPoolName(this.id), remote);
            }
            catch (Exception e) {
                try {
                    this.stop(0x1000000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Utils.logError("An error occurred when binding the pool in the registry.", e);
                throw new RjInitFailedException("An error occurred when publishing the pool in the registry.");
            }
        }
    }

    public boolean isInitialized() {
        return this.pool != null;
    }

    public void checkInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("not initialized");
        }
    }

    @Override
    public Collection<? extends PoolNodeObject> getPoolNodeObjects() {
        this.checkInitialized();
        APool2NodeObjectFactory poolObjectFactory = (APool2NodeObjectFactory)ObjectUtils.nonNullAssert((Object)this.poolObjectFactory);
        return poolObjectFactory.getAllObjects();
    }

    public boolean isStopped() {
        return this.unclosed == 0 && this.executor.getQueue().isEmpty() && this.executor.getPoolSize() == 0;
    }

    @Override
    public synchronized void stop(int mode) throws RjException {
        block15: {
            block14: {
                Utils.logInfo("Unpublishing pool...");
                RMIRegistry registry = this.registry;
                if (registry != null) {
                    try {
                        registry.getRegistry().unbind(PoolConfig.getPoolName(this.id));
                    }
                    catch (Exception e) {
                        if ((mode & 0x1000000) != 0) break block14;
                        Utils.logError("An error occurred when unbinding the pool from the registry.", e);
                    }
                }
            }
            if (this.thisRemote != null) {
                try {
                    this.thisRemote = null;
                    UnicastRemoteObject.unexportObject(this, true);
                }
                catch (Exception e) {
                    if ((mode & 0x1000000) != 0) break block15;
                    Utils.logError("An error occurred when unexport the pool.", e);
                }
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        APool2 pool = this.pool;
        if (pool != null) {
            Utils.logInfo("Closing R nodes...");
            try {
                try {
                    pool.close(this.poolConfig.getEvictionTimeout());
                }
                catch (Exception e) {
                    Utils.logError("An error occurred when closing the pool.", e);
                    Runtime.getRuntime().gc();
                }
            }
            finally {
                Runtime.getRuntime().gc();
            }
        }
    }

    private void configResources() {
        int unclosed = this.unclosed;
        if (unclosed > 0) {
            this.executor.setKeepAliveTime(60L, TimeUnit.SECONDS);
            this.executor.setCorePoolSize(1);
            this.executor.setMaximumPoolSize(2);
        } else {
            this.executor.setKeepAliveTime(0L, TimeUnit.SECONDS);
            this.executor.setCorePoolSize(0);
            this.executor.setMaximumPoolSize(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPoolCreated(APool2 pool) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.unclosed++ == 0) {
                this.configResources();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPoolClosed(APool2 pool) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (--this.unclosed == 0) {
                this.configResources();
            }
        }
    }

    @Override
    public final RServiPool getPool() {
        return this;
    }

    @Override
    public RServi getRServi(String name, @Nullable ServerLogin login) throws NoSuchElementException, RjException {
        APool2NodeHandler handler = this.getPoolObject(name);
        return new RServiImpl(handler.getAccessId(), handler, handler.getClientHandler());
    }

    private APool2NodeHandler getPoolObject(String client) throws NoSuchElementException, RjException {
        this.checkInitialized();
        APool2 pool = (APool2)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.pool)));
        try {
            return pool.borrowObject(client);
        }
        catch (NoSuchElementException e) {
            this.stats.logServRequestFailed(3);
            throw new NoSuchElementException(Messages.GetRServi_NoInstance_pub_Pool_message);
        }
        catch (Exception e) {
            this.stats.logServRequestFailed(4);
            Utils.logError(Messages.BindClient_error_message, e);
            throw new RjException(Messages.GetRServi_pub_error_message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RServiPoolManager.Counter getCounter() {
        this.checkInitialized();
        APool2 pool = (APool2)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.pool)));
        APool2NodeObjectFactory poolObjectFactory = (APool2NodeObjectFactory)ObjectUtils.nonNullAssert((Object)this.poolObjectFactory);
        RServiPoolManager.Counter counter = new RServiPoolManager.Counter();
        APool2 aPool2 = pool;
        synchronized (aPool2) {
            counter.numIdling = pool.getNumIdle();
            counter.numInUse = pool.getNumActive();
            counter.numTotal = counter.numIdling + counter.numTotal;
            counter.maxIdling = -1;
            counter.maxInUse = poolObjectFactory.getStatMaxAllocated();
            counter.maxTotal = poolObjectFactory.getStatMaxTotal();
        }
        return counter;
    }
}

