/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.snakeyaml.tokens;

import java.util.List;
import java.util.Objects;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SyntaxProblem;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.Token;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class DirectiveToken<T>
extends Token {
    public static final String YAML_DIRECTIVE = "YAML";
    public static final String TAG_DIRECTIVE = "TAG";
    private final String name;
    private final @Nullable List<T> value;

    public DirectiveToken(String name, @Nullable List<T> value, int startIndex, int endIndex, @Nullable SyntaxProblem problem) {
        super(startIndex, endIndex, problem);
        Objects.requireNonNull(name);
        this.name = name;
        if (value != null && value.size() != 2) {
            throw new IllegalArgumentException("Two strings/integers must be provided instead of " + value.size());
        }
        this.value = value;
    }

    @Override
    public Token.ID getTokenId() {
        return Token.ID.Directive;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable List<T> getValue() {
        return this.value;
    }
}

