/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserBookmark;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserView;
import org.eclipse.ui.actions.CompoundContributionItem;

public class ShowBookmarksDropdownContribution
extends CompoundContributionItem {
    private final PageBookBrowserView view;

    public ShowBookmarksDropdownContribution(PageBookBrowserView view) {
        this.view = view;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<ContributionItem> list = new ArrayList<ContributionItem>();
        List<BrowserBookmark> bookmarks = this.view.getBookmarks();
        int i = 0;
        while (i < bookmarks.size()) {
            list.add(this.createPageContribution(bookmarks.get(i), i + 1));
            ++i;
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    private ContributionItem createPageContribution(BrowserBookmark bookmark, int num) {
        Object label = bookmark.getLabel();
        String mnemonic = null;
        if (num < 10) {
            mnemonic = Integer.toString(num);
            label = mnemonic + " " + (String)label;
        }
        return new OpenBookmarkContributionItem(this.view, bookmark, (String)label, mnemonic);
    }

    public static class OpenBookmarkContributionItem
    extends SimpleContributionItem {
        private final PageBookBrowserView view;
        private final BrowserBookmark bookmark;

        public OpenBookmarkContributionItem(PageBookBrowserView view, BrowserBookmark bookmark) {
            super(bookmark.getLabel(), null);
            this.view = view;
            this.bookmark = bookmark;
        }

        public OpenBookmarkContributionItem(PageBookBrowserView view, BrowserBookmark bookmark, String label, String mnemonic) {
            super(label != null ? label : bookmark.getLabel(), mnemonic);
            this.view = view;
            this.bookmark = bookmark;
        }

        @Override
        protected void execute() throws ExecutionException {
            this.view.openBookmark(this.bookmark, (BrowserSession)this.view.getCurrentSession());
        }
    }
}

