/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import java.util.List;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.internal.nico.ui.console.ControlMarker;
import org.eclipse.statet.internal.nico.ui.console.InternArrayList;
import org.eclipse.statet.internal.nico.ui.console.StyleData;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;

@NonNullByDefault
public final class NIConsolePartition
implements ITypedRegion {
    private final String type;
    private int startOffset;
    private int endOffset;
    private final NIConsoleOutputStream stream;
    private @Nullable StyleData initalStyleData;
    private @Nullable List<ControlMarker> controlMarkers;

    public NIConsolePartition(String type, NIConsoleOutputStream stream, int startOffset, int endOffset) {
        this.type = type;
        this.stream = stream;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.initalStyleData = null;
        this.controlMarkers = null;
    }

    NIConsolePartition(String type, NIConsoleOutputStream stream, int startOffset, int endOffset, @Nullable StyleData initalStyleData, @Nullable List<ControlMarker> controlMarkers) {
        this.type = type;
        this.stream = stream;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.initalStyleData = initalStyleData;
        this.controlMarkers = controlMarkers;
    }

    public String getType() {
        return this.type;
    }

    public NIConsoleOutputStream getStream() {
        return this.stream;
    }

    void shiftOffset(int shiftOffset) {
        List<ControlMarker> controlMarkers;
        if (shiftOffset > this.startOffset) {
            int index;
            this.startOffset = 0;
            this.endOffset -= shiftOffset;
            controlMarkers = this.controlMarkers;
            if (controlMarkers != null && (index = ControlMarker.indexOfMarkerBefore(controlMarkers, shiftOffset)) >= 0) {
                this.initalStyleData = this.getLastStyle(controlMarkers, index);
                if (++index < controlMarkers.size()) {
                    ((InternArrayList)controlMarkers).removeHead(index);
                } else {
                    this.controlMarkers = null;
                }
            }
        } else {
            this.startOffset -= shiftOffset;
            this.endOffset -= shiftOffset;
        }
        if ((controlMarkers = this.controlMarkers) != null) {
            for (ControlMarker marker : controlMarkers) {
                marker.shiftOffset(shiftOffset);
            }
        }
    }

    void append(int startOffset, int endOffset, @Nullable List<ControlMarker> addControlMarkers) {
        boolean replacement = startOffset < this.endOffset;
        this.endOffset = endOffset;
        if (addControlMarkers != null) {
            List<ControlMarker> controlMarkers = this.controlMarkers;
            if (controlMarkers != null) {
                int index;
                if (replacement && (index = ControlMarker.indexOfMarkerBefore(controlMarkers, startOffset)) >= 0 && ++index < controlMarkers.size()) {
                    ((InternArrayList)controlMarkers).removeTail(index);
                }
                controlMarkers.addAll(addControlMarkers);
            } else {
                this.controlMarkers = addControlMarkers;
            }
        }
    }

    public int getOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLength() {
        return this.endOffset - this.startOffset;
    }

    public @Nullable StyleData getInitalStyleData() {
        return this.initalStyleData;
    }

    public List<ControlMarker> getControlMarkers() {
        ImList controlMarkers = this.controlMarkers;
        return controlMarkers != null ? controlMarkers : ImCollections.emptyList();
    }

    public NIConsolePartition trim(int startOffset, int endOffset) {
        if (startOffset == this.startOffset && endOffset == this.endOffset) {
            return this;
        }
        startOffset = Math.max(this.startOffset, startOffset);
        endOffset = Math.min(this.endOffset, endOffset);
        return new NIConsolePartition(this.type, this.stream, startOffset, endOffset);
    }

    public NIConsolePartition trimWithStyles(int startOffset, int endOffset) {
        if (startOffset == this.startOffset && endOffset == this.endOffset) {
            return this;
        }
        startOffset = Math.max(this.startOffset, startOffset);
        endOffset = Math.min(this.endOffset, endOffset);
        StyleData initalStyleData = this.initalStyleData;
        List<ControlMarker> controlMarkers = this.controlMarkers;
        if (controlMarkers != null) {
            int markerStart = 0;
            int markerEnd = controlMarkers.size();
            if (startOffset > this.startOffset) {
                int index = ControlMarker.indexOfMarkerBefore(controlMarkers, startOffset);
                if (index >= 0) {
                    initalStyleData = this.getLastStyle(controlMarkers, index);
                }
                markerStart = index + 1;
            }
            if (endOffset < this.endOffset) {
                int mIdx = markerStart;
                while (mIdx < controlMarkers.size()) {
                    ControlMarker m = controlMarkers.get(mIdx);
                    if (m.getOffset() >= endOffset) {
                        markerEnd = mIdx;
                        break;
                    }
                    ++mIdx;
                }
            }
            if (markerStart != 0 || markerEnd != controlMarkers.size()) {
                controlMarkers = controlMarkers.subList(markerStart, markerEnd);
            }
        }
        return new NIConsolePartition(this.type, this.stream, startOffset, endOffset, initalStyleData, controlMarkers);
    }

    private @Nullable StyleData getLastStyle(List<ControlMarker> controlMarkers, int index) {
        while (index >= 0) {
            ControlMarker marker;
            if (!(marker = controlMarkers.get(index--)).isStyleMarker()) continue;
            return marker.getStyle();
        }
        return this.initalStyleData;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(this.getType());
        sb.append(": ");
        sb.append('[', this.startOffset, this.endOffset, ')');
        return sb.toString();
    }
}

