/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.model.rpkg;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.dsl.core.source.ast.SourceComponent;
import org.eclipse.statet.dsl.dcf.core.source.ast.EmbeddingValue;
import org.eclipse.statet.dsl.dcf.core.source.ast.Value;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.model.rpkg.EmbeddingReconcileTask;
import org.eclipse.statet.internal.r.core.model.rpkg.RPkgDescrIssueReporter;
import org.eclipse.statet.internal.r.core.model.rpkg.RPkgDescrSourceAnalyzer;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.RPkgDescrDcfParser;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.RPkgSpecValueParser;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.SpecList;
import org.eclipse.statet.internal.r.core.rmodel.RModelManagerImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.jcommons.text.core.input.RegionParserInput;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.impl.BasicSourceModelStamp;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.build.RPkgDescrSourceUnitModelContainer;
import org.eclipse.statet.r.core.model.rlang.RChunkSrcStrElement;
import org.eclipse.statet.r.core.model.rpkg.RPkgDescrSourceUnitModelInfo;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.core.source.ast.RParser;

@NonNullByDefault
public class RPkgDescrReconciler {
    private final RModelManagerImpl rManager;
    protected boolean stop = false;
    private final Object raLock = new Object();
    private final StringParserInput raInput = new StringParserInput(4096);
    private final RegionParserInput raRegionInput = new RegionParserInput((TextParserInput)this.raInput, "\n");
    private final RPkgDescrDcfParser raParser = new RPkgDescrDcfParser();
    private final List<TextRegion> raRegions = new ArrayList<TextRegion>();
    private final RPkgSpecValueParser raValueParser = new RPkgSpecValueParser();
    private final RParser raRParser = new RParser(4);
    private final Object rmLock = new Object();
    private final RPkgDescrSourceAnalyzer rmSourceAnalyzer = new RPkgDescrSourceAnalyzer();
    private final Object riLock = new Object();
    private final RPkgDescrIssueReporter riReporter = new RPkgDescrIssueReporter();
    private @Nullable RProject project;
    private @Nullable MultiStatus statusCollector;

    public RPkgDescrReconciler(RModelManagerImpl manager) {
        this.rManager = manager;
    }

    public void init(RProject project, MultiStatus statusCollector) {
        this.project = (RProject)ObjectUtils.nonNullAssert((Object)project);
        this.statusCollector = statusCollector;
    }

    void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable RPkgDescrSourceUnitModelInfo reconcile(RPkgDescrSourceUnitModelContainer adapter, int flags, IProgressMonitor monitor) {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
        Data data = new Data(adapter, m);
        if (data == null || !data.isOK()) {
            adapter.clear();
            return null;
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        Object object = this.raLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            this.updateAst(data, flags);
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        if ((flags & 0xF) < 2) {
            return null;
        }
        object = this.rmLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            boolean updated = this.updateModel(data, flags, m);
            if (updated) {
                this.rManager.getEventJob().addUpdate((LtkModelElement)data.sourceUnit, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            object = this.riLock;
            synchronized (object) {
                block18: {
                    if (!this.stop && !m.isCanceled() && data.newModel == data.adapter.getCurrentModel()) break block18;
                    return null;
                }
                this.reportIssues(data, flags);
            }
        }
        return data.newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags) {
        BasicSourceModelStamp stamp = new BasicSourceModelStamp(data.content.getStamp(), ImCollections.newList((Object)data.rSourceConfig));
        AstInfo ast = data.adapter.getCurrentAst();
        if (ast != null && !stamp.equals((Object)ast.getStamp())) {
            ast = null;
        }
        if (ast != null) {
            data.ast = ast;
        } else {
            ImIdentitySet<String> embeddedTypeIds;
            if (data.content.getStartOffset() != 0) {
                OffsetStringParserInput input = new OffsetStringParserInput(data.content.getString(), data.content.getStartOffset());
            } else {
                StringParserInput input = this.raInput.reset(data.content.getString());
            }
            this.raParser.setCommentLevel(1);
            this.raParser.setCollectEmebeddedNodes(true);
            SourceComponent sourceNode = this.raParser.parseSourceUnit(this.raInput.init((TextRegion)data.content));
            List embeddingNodes = this.raParser.getEmbeddingNodes();
            if (!embeddingNodes.isEmpty()) {
                this.raRParser.setRSourceConfig(data.rSourceConfig);
                this.raRParser.setCommentLevel(0);
                embeddedTypeIds = this.updateEmbeddingAst(data.content, embeddingNodes);
            } else {
                embeddedTypeIds = ImCollections.emptyIdentitySet();
            }
            ast = new AstInfo(1, (SourceModelStamp)stamp, (AstNode)sourceNode, (ImIdentitySet)embeddedTypeIds);
            RPkgDescrSourceUnitModelContainer rPkgDescrSourceUnitModelContainer = data.adapter;
            synchronized (rPkgDescrSourceUnitModelContainer) {
                data.adapter.setAst(ast);
            }
            data.ast = ast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags, SubMonitor m) {
        boolean isOK;
        RPkgDescrSourceUnitModelInfo model = (RPkgDescrSourceUnitModelInfo)data.adapter.getCurrentModel();
        if (model != null && !data.getAst().getStamp().equals(model.getStamp())) {
            model = null;
        }
        if (model != null) {
            data.newModel = model;
            return false;
        }
        model = this.rmSourceAnalyzer.createModel(data.adapter.getSourceUnit(), data.getAst());
        boolean bl = isOK = model != null;
        if (isOK) {
            if (!data.ast.getEmbeddedTypes().contains((Object)"R")) {
                this.reconcileEmbeddedRModel(model, this.rmSourceAnalyzer.getEmbeddedItems(), data.adapter, flags, (IProgressMonitor)m);
            }
            RPkgDescrSourceUnitModelContainer rPkgDescrSourceUnitModelContainer = data.adapter;
            synchronized (rPkgDescrSourceUnitModelContainer) {
                data.oldModel = (RPkgDescrSourceUnitModelInfo)data.adapter.getCurrentModel();
                data.adapter.setModel(model);
            }
            data.newModel = model;
            return true;
        }
        return false;
    }

    protected void reportIssues(Data data, int flags) {
        block6: {
            try {
                SourceUnitIssueSupport issueSupport = data.adapter.getIssueSupport();
                if (issueSupport == null) {
                    return;
                }
                IssueRequestor issueRequestor = issueSupport.createIssueRequestor((SourceUnit)data.sourceUnit);
                if (issueRequestor == null) break block6;
                try {
                    this.riReporter.run(data.sourceUnit, data.getModel(), data.content, issueRequestor, flags);
                }
                finally {
                    issueRequestor.finish();
                }
            }
            catch (Exception e) {
                this.handleStatus((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, String.format("An error occurred when reporting issues for source unit %1$s.", data.sourceUnit), (Throwable)e));
            }
        }
    }

    private ImIdentitySet<String> updateEmbeddingAst(SourceContent content, List<EmbeddingValue> embeddingNodes) {
        IdentityHashMap<String, Boolean> ids = new IdentityHashMap<String, Boolean>(4);
        for (EmbeddingValue embeddingNode : embeddingNodes) {
            ids.put(embeddingNode.getForeignTypeId(), Boolean.TRUE);
            this.raRegionInput.reset(this.getCodeRegions(embeddingNode));
            this.raRegionInput.init(embeddingNode.getStartOffset(), embeddingNode.getEndOffset());
            if (embeddingNode.getForeignTypeId() == "RPkg.SpecValue") {
                SpecList strValueNode = this.raValueParser.parseBundleSpecList((TextParserInput)this.raRegionInput, (AstNode)embeddingNode, true);
                embeddingNode.setForeignNode((AstNode)strValueNode);
            }
            if (embeddingNode.getForeignTypeId() != "R") continue;
            org.eclipse.statet.r.core.source.ast.SourceComponent rCodeNode = this.raRParser.parseSourceFragment((TextParserInput)this.raRegionInput, (AstNode)embeddingNode, true);
            embeddingNode.setForeignNode((AstNode)rCodeNode);
        }
        return ImCollections.toIdentitySet(ids.keySet());
    }

    private void reconcileEmbeddedRModel(RPkgDescrSourceUnitModelInfo mainModel, List<EmbeddingReconcileTask> tasks, RPkgDescrSourceUnitModelContainer adapter, int level, IProgressMonitor monitor) {
        if (tasks == null || tasks.isEmpty() || this.rManager == null) {
            return;
        }
        ArrayList<org.eclipse.statet.r.core.source.ast.SourceComponent> inlineNodes = new ArrayList<org.eclipse.statet.r.core.source.ast.SourceComponent>();
        for (EmbeddingReconcileTask task : tasks) {
            if (task.getForeignTypeId() != "R") continue;
            EmbeddingValue embeddingNode = task.getAstNode();
            inlineNodes.add((org.eclipse.statet.r.core.source.ast.SourceComponent)embeddingNode.getForeignNode());
        }
        RSourceUnitModelInfo modelInfo = this.rManager.reconcile((RSourceUnit)adapter.getSourceUnit(), mainModel, (List<? extends RChunkSrcStrElement>)ImCollections.emptyList(), inlineNodes, level, monitor);
    }

    protected void handleStatus(IStatus status) {
        MultiStatus collector = this.statusCollector;
        if (collector != null) {
            collector.add(status);
        } else {
            RCorePlugin.log(status);
        }
    }

    private ImList<TextRegion> getCodeRegions(EmbeddingValue node) {
        ImList textRegions = node.getTextRegions();
        this.raRegions.clear();
        for (TextRegion region : textRegions) {
            if (region instanceof Value.EmptyLine) continue;
            this.raRegions.add(region);
        }
        return this.raRegions.size() == textRegions.size() ? textRegions : ImCollections.toList(this.raRegions);
    }

    protected static final class Data {
        public final RPkgDescrSourceUnitModelContainer adapter;
        public final RSourceUnit sourceUnit;
        public final SourceContent content;
        public final RSourceConfig rSourceConfig;
        @Nullable AstInfo ast;
        @Nullable RPkgDescrSourceUnitModelInfo oldModel;
        @Nullable RPkgDescrSourceUnitModelInfo newModel;

        public Data(RPkgDescrSourceUnitModelContainer adapter, SubMonitor monitor) {
            this.adapter = adapter;
            this.sourceUnit = (RSourceUnit)adapter.getSourceUnit();
            this.content = adapter.getParseContent((IProgressMonitor)monitor);
            this.rSourceConfig = RCore.getContextAccess((IAdaptable)this.sourceUnit).getRSourceConfig();
        }

        public Data(RPkgDescrSourceUnitModelContainer adapter, RSourceConfig rSourceConfig, SubMonitor monitor) {
            this.adapter = adapter;
            this.sourceUnit = (RSourceUnit)adapter.getSourceUnit();
            this.content = adapter.getParseContent((IProgressMonitor)monitor);
            this.rSourceConfig = rSourceConfig;
        }

        boolean isOK() {
            return this.content != null;
        }

        public AstInfo getAst() {
            return this.ast;
        }

        public RPkgDescrSourceUnitModelInfo getModel() {
            return this.newModel;
        }
    }
}

