/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.editors;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.docmlet.tex.core.model.TexModel;
import org.eclipse.statet.docmlet.tex.ui.editors.TexEditorBuild;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.r.ui.editors.REditorBuild;
import org.eclipse.statet.redocs.tex.r.core.model.LtxRweaveSourceUnit;
import org.eclipse.statet.redocs.tex.r.core.source.doc.LtxRweaveDocumentSetupParticipant;

@NonNullByDefault
public class LtxRweaveDocumentProvider
extends SourceDocumentProvider<LtxRweaveSourceUnit>
implements Disposable {
    private static final IssueTypeSet ISSUE_TYPE_SET = new IssueTypeSet("org.eclipse.statet.redocs.tex.r", TexEditorBuild.LTX_ISSUE_TYPE_SET, new IssueTypeSet.ProblemCategory[]{REditorBuild.R_MODEL_PROBLEM_CATEGORY});
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SettingsChangeNotifier.ChangeListener editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

        public void settingsChanged(Set<String> groupIds) {
            if (groupIds.contains("r/r.editor/build.options") || groupIds.contains("Tex/editor/build")) {
                LtxRweaveDocumentProvider.this.updateEditorPrefs();
            }
        }
    };
    private boolean handleTemporaryDocProblems;
    private boolean handleTemporaryRProblems;

    public LtxRweaveDocumentProvider() {
        super("LtxRweave", (PartitionerDocumentSetupParticipant)new LtxRweaveDocumentSetupParticipant(), ISSUE_TYPE_SET);
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(this.editorPrefListener);
        PreferenceAccess access = EPreferences.getInstancePrefs();
        this.handleTemporaryDocProblems = (Boolean)access.getPreferenceValue((Preference)TexEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        this.handleTemporaryRProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        if (this.editorPrefListener != null) {
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(this.editorPrefListener);
            this.editorPrefListener = null;
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = EPreferences.getInstancePrefs();
        boolean newHandleTemporaryTexProblems = (Boolean)access.getPreferenceValue((Preference)TexEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        boolean newHandleTemporaryRProblems = (Boolean)access.getPreferenceValue((Preference)REditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryDocProblems != newHandleTemporaryTexProblems || this.handleTemporaryRProblems != newHandleTemporaryRProblems) {
            this.handleTemporaryDocProblems = newHandleTemporaryRProblems;
            this.handleTemporaryRProblems = newHandleTemporaryRProblems;
            TexModel.getLtxModelManager().refresh(Ltk.EDITOR_CONTEXT);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource, LtxRweaveDocumentProvider.this.getIssueTypeSet());
        }

        protected boolean isHandlingTemporaryProblems(IssueTypeSet.ProblemCategory issueCategory) {
            if (issueCategory != null && issueCategory.getId() == "R") {
                return LtxRweaveDocumentProvider.this.handleTemporaryRProblems;
            }
            return LtxRweaveDocumentProvider.this.handleTemporaryDocProblems;
        }
    }
}

