/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.nio.channels.UnsupportedAddressTypeException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.eclipse.statet.jcommons.collections.IntMap;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public final class IntHashMap<V>
implements IntMap<V> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private @Nullable Entry<V>[] entries;
    private int size;
    private int threshold;
    private final float loadFactor;
    private volatile Set<IntMap.IntEntry<V>> entryIntSet;

    public IntHashMap() {
        this(16, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity= " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor= " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * this.loadFactor);
        this.entries = new Entry[initialCapacity];
    }

    private int idxFor(int key) {
        int compr = key ^ key >>> 23 ^ key >>> 11;
        return ((compr ^ compr >>> 7) & Integer.MAX_VALUE) % this.entries.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(int key) {
        Entry<V> e = this.entries[this.idxFor(key)];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return key instanceof Integer && this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        int i = this.entries.length - 1;
        while (i >= 0) {
            Entry<V> e = this.entries[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
            --i;
        }
        return false;
    }

    @Override
    public @Nullable V get(int key) {
        Entry<V> e = this.entries[this.idxFor(key)];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public @Nullable V get(Object key) {
        return key instanceof Integer ? (V)this.get((Integer)key) : null;
    }

    private void increase() {
        Entry<V>[] oldEntries = this.entries;
        this.entries = new Entry[oldEntries.length * 2 + 1];
        int i = oldEntries.length - 1;
        while (i >= 0) {
            Entry<V> next = oldEntries[i];
            while (next != null) {
                Entry<V> e = next;
                next = next.next;
                int idx = this.idxFor(e.key);
                e.next = this.entries[idx];
                this.entries[idx] = e;
            }
            --i;
        }
        this.threshold = (int)((float)this.entries.length * this.loadFactor);
    }

    @Override
    public @Nullable V put(int key, V value) {
        Entry<V> e = this.entries[this.idxFor(key)];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.size >= this.threshold) {
            this.increase();
        }
        int idx = this.idxFor(key);
        this.entries[idx] = new Entry<V>(key, value, this.entries[idx]);
        ++this.size;
        return null;
    }

    @Override
    public V computeIfAbsent(int key, IntFunction<V> mappingFunction) {
        ObjectUtils.nonNullAssert(mappingFunction);
        Entry<V> e = this.entries[this.idxFor(key)];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        if (this.size >= this.threshold) {
            this.increase();
        }
        V value = mappingFunction.apply(key);
        int idx = this.idxFor(key);
        this.entries[idx] = new Entry<V>(key, value, this.entries[idx]);
        ++this.size;
        return value;
    }

    @Override
    public @Nullable V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> t) {
        for (Map.Entry<Integer, V> entry : t.entrySet()) {
            this.put((int)entry.getKey(), entry.getValue());
        }
    }

    public @Nullable V remove(int key) {
        int idx = this.idxFor(key);
        Entry<V> e = this.entries[idx];
        Entry<V> prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev == null) {
                    this.entries[idx] = e.next;
                } else {
                    prev.next = e.next;
                }
                --this.size;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public @Nullable V remove(@Nullable Object key) {
        return key instanceof Integer ? (V)this.remove((Integer)key) : null;
    }

    @Override
    public void clear() {
        Arrays.fill(this.entries, null);
        this.size = 0;
    }

    public Set<IntMap.IntEntry<V>> entryIntSet() {
        AbstractSet entries = this.entryIntSet;
        return entries != null ? entries : (this.entryIntSet = new AbstractSet<IntMap.IntEntry<V>>(){

            @Override
            public int size() {
                return IntHashMap.this.size;
            }

            @Override
            public boolean contains(@Nullable Object o) {
                return o instanceof IntMap.IntEntry && o.equals(IntHashMap.this.get(((IntMap.IntEntry)o).getIntKey()));
            }

            @Override
            public Iterator<IntMap.IntEntry<V>> iterator() {
                return new IntEntryIterator();
            }

            @Override
            public void clear() {
                IntHashMap.this.clear();
            }
        });
    }

    @Override
    public Set<Integer> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        throw new UnsupportedAddressTypeException();
    }

    private static class Entry<V>
    implements Map.Entry<Integer, V>,
    IntMap.IntEntry<V> {
        final int key;
        V value;
        @Nullable Entry<V> next;

        public Entry(int key, V value, Entry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return this.key + Objects.hashCode(this.value);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            IntMap.IntEntry other;
            return this == obj || obj instanceof IntMap.IntEntry && this.key == (other = (IntMap.IntEntry)obj).getIntKey() && Objects.equals(this.value, other.getValue());
        }
    }

    private class IntEntryIterator
    implements Iterator<IntMap.IntEntry<V>> {
        private @Nullable Entry<V> currentEntry;
        private @Nullable Entry<V> nextEntry;
        private int nextEntryIdx;

        public IntEntryIterator() {
            int idx = 0;
            while (idx < IntHashMap.this.entries.length) {
                if (IntHashMap.this.entries[idx] != null) {
                    this.nextEntryIdx = idx;
                    this.nextEntry = IntHashMap.this.entries[this.nextEntryIdx];
                    break;
                }
                ++idx;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public Entry<V> next() {
            this.currentEntry = this.nextEntry;
            Entry entry = this.currentEntry;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            if (entry.next != null) {
                this.nextEntry = entry.next;
            } else {
                this.nextEntry = null;
                int idx = this.nextEntryIdx + 1;
                while (idx < IntHashMap.this.entries.length) {
                    if (IntHashMap.this.entries[idx] != null) {
                        this.nextEntryIdx = idx;
                        this.nextEntry = IntHashMap.this.entries[this.nextEntryIdx];
                        break;
                    }
                    ++idx;
                }
            }
            return entry;
        }

        @Override
        public void remove() {
            Entry entry = this.currentEntry;
            if (entry == null) {
                throw new IllegalStateException();
            }
            IntHashMap.this.remove(entry.key);
            this.currentEntry = null;
        }
    }
}

