/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.time.Duration;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.core.TunnelClientSocketImpl;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.util.TimeUtils;

@NonNullByDefault
public class RemoteSocket
extends Socket {
    private final TunnelClientSocketImpl impl;
    private volatile @Nullable OutputStream out;

    public RemoteSocket(TunnelClientSocketImpl impl) throws SocketException, IOException {
        super(impl);
        this.impl = impl;
    }

    public void connect(InetSocketAddress targetAddress, @Nullable Duration timeout, ProgressMonitor m) throws IOException, StatusException {
        this.impl.connectMonitor = m;
        try {
            try {
                super.connect(targetAddress, TimeUtils.toMillisInt(timeout, 0));
            }
            catch (IOException e) {
                if (e.getCause() instanceof StatusException) {
                    throw (StatusException)e.getCause();
                }
                this.impl.connectMonitor = null;
            }
        }
        finally {
            this.impl.connectMonitor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream out = this.out;
        if (out == null) {
            RemoteSocket remoteSocket = this;
            synchronized (remoteSocket) {
                out = this.out;
                if (out == null) {
                    this.out = out = new SocketOutputStream(this.impl.getOutputStream());
                }
            }
        }
        return out;
    }

    private class SocketOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        SocketOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            RemoteSocket.this.close();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }
    }
}

