/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.docmlet.tex.core.TexBuildParticipant;
import org.eclipse.statet.internal.docmlet.tex.core.TexProjectNature;
import org.eclipse.statet.internal.docmlet.tex.core.builder.TexProjectBuilder;
import org.eclipse.statet.ltk.model.core.LtkModels;

public abstract class TexProjectTask {
    private static final TexBuildParticipant NO_PARTICIPANT = new TexBuildParticipant();
    private final Map<String, TexBuildParticipant> participants = new HashMap<String, TexBuildParticipant>();
    private final TexProjectBuilder texProjectBuilder;
    private final TexProjectNature texProject;
    private int buildType;

    public TexProjectTask(TexProjectBuilder projectBuilder) {
        this.texProjectBuilder = projectBuilder;
        this.texProject = projectBuilder.getTexProject();
    }

    protected final TexProjectBuilder getTexProjectBuilder() {
        return this.texProjectBuilder;
    }

    public final TexProjectNature getTexProject() {
        return this.texProject;
    }

    public void setBuildType(int buildType) {
        this.buildType = buildType;
    }

    protected final Collection<TexBuildParticipant> getParticipants() {
        Collection<TexBuildParticipant> values = this.participants.values();
        ArrayList<TexBuildParticipant> list = new ArrayList<TexBuildParticipant>(values.size());
        for (TexBuildParticipant participant : values) {
            if (participant == null) continue;
            list.add(participant);
        }
        return list;
    }

    protected final TexBuildParticipant getParticipant(String modelTypeId) {
        if (modelTypeId == null) {
            return null;
        }
        TexBuildParticipant participant = this.participants.get(modelTypeId);
        if (participant == null) {
            participant = this.loadParticipant(modelTypeId);
            this.participants.put(modelTypeId, participant);
        }
        return participant != NO_PARTICIPANT ? participant : null;
    }

    private TexBuildParticipant loadParticipant(String modelTypeId) {
        TexBuildParticipant participant = (TexBuildParticipant)LtkModels.getModelAdapter((String)modelTypeId, TexBuildParticipant.class);
        if (participant == null) {
            return NO_PARTICIPANT;
        }
        participant.texProject = this.getTexProject();
        participant.buildType = this.buildType;
        participant.enabled = false;
        participant.init();
        return participant;
    }
}

