/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.objectbrowser;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.internal.r.objectbrowser.ObjectBrowserView;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;

class SortByTypeComparator
extends ViewerComparator
implements Comparator<Object> {
    private final Collator classNameCollator = Collator.getInstance((Locale)Locale.ENGLISH);

    SortByTypeComparator() {
    }

    public void sort(Viewer viewer, Object[] elements) {
        CombinedRElement parent;
        if (elements != null && elements.length > 0 && elements[0] instanceof CombinedRElement && (parent = ((CombinedRElement)elements[0]).getModelParent()) != null && parent.getRObjectType() == 8) {
            Arrays.sort(elements, this);
        }
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare((CombinedRElement)o1, (CombinedRElement)o2);
    }

    @Override
    public int compare(CombinedRElement e1, CombinedRElement e2) {
        int d2;
        int d1;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if ((cat1 == 2 || cat1 == 3) && (d1 = this.getDataOrder(e1.getData().getStoreType())) != (d2 = this.getDataOrder(e2.getData().getStoreType()))) {
            return d1 - d2;
        }
        int diff = this.classNameCollator.compare(e1.getRClassName(), e2.getRClassName());
        if (diff != 0) {
            return diff;
        }
        RElementName name1 = e1.getElementName();
        RElementName name2 = e2.getElementName();
        if (name1 instanceof RElementName.IndexElementName && name2 instanceof RElementName.IndexElementName) {
            return ((RElementName.IndexElementName)name1).getIndex() - ((RElementName.IndexElementName)name2).getIndex();
        }
        return ObjectBrowserView.ELEMENTNAME_COMPARATOR.compare((RElement)e1, (RElement)e2);
    }

    private int getDataOrder(int dataType) {
        switch (dataType) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 10: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        return 7;
    }

    public int category(CombinedRElement element) {
        RObject realObject;
        int objectType = element.getRObjectType();
        if (objectType == 14 && (realObject = ((RReference)element).getResolvedRObject()) != null) {
            objectType = realObject.getRObjectType();
        }
        if (objectType == 3) {
            objectType = 2;
        }
        return objectType;
    }
}

