/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.DataDim;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.SizeConfig;

public abstract class SizeConfigDim<TLayer extends ILayer>
extends DataDim<ILayer> {
    private final SizeConfig sizeConfig;

    public SizeConfigDim(ILayer layer, Orientation orientation, long idCat, SizeConfig sizeConfig) {
        super(layer, orientation, idCat);
        this.sizeConfig = sizeConfig;
    }

    public void setResizableByDefault(boolean resizableByDefault) {
        this.sizeConfig.setResizableByDefault(resizableByDefault);
    }

    public void setPositionResizable(long rowPosition, boolean resizable) {
        this.sizeConfig.setPositionResizable(rowPosition, resizable);
    }

    @Override
    public long getSize() {
        return this.sizeConfig.getAggregateSize(this.getPositionCount());
    }

    @Override
    public long getPositionStart(long position) {
        return this.sizeConfig.getAggregateSize(position);
    }

    @Override
    public int getPositionSize(long position) {
        return this.sizeConfig.getSize(position);
    }

    @Override
    public boolean isPositionResizable(long position) {
        return this.sizeConfig.isPositionResizable(position);
    }
}

