/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.BackgroundPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ImagePainter
extends BackgroundPainter {
    private final Image image;
    private final boolean paintBg;

    public ImagePainter() {
        this((Image)null);
    }

    public ImagePainter(Image image) {
        this(image, true);
    }

    public ImagePainter(Image image, boolean paintBg) {
        this.image = image;
        this.paintBg = paintBg;
    }

    @Override
    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().width;
        }
        return 0L;
    }

    @Override
    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().height;
        }
        return 0L;
    }

    @Override
    public ICellPainter getCellPainterAt(long x, long y, ILayerCell cell, GC gc, LRectangle bounds, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
            long x0 = bounds.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, bounds, (long)imageBounds.width);
            long y0 = bounds.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, bounds, (long)imageBounds.height);
            if (x >= x0 && x < x0 + (long)imageBounds.width && y >= y0 && y < y0 + (long)imageBounds.height) {
                return super.getCellPainterAt(x, y, cell, gc, bounds, configRegistry);
            }
        }
        return null;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle bounds, IConfigRegistry configRegistry) {
        Image image;
        if (this.paintBg) {
            super.paintCell(cell, gc, bounds, configRegistry);
        }
        if ((image = this.getImage(cell, configRegistry)) != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
            gc.drawImage(image, GraphicsUtils.safe(bounds.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, bounds, (long)imageBounds.width)), GraphicsUtils.safe(bounds.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, bounds, (long)imageBounds.height)));
        }
    }

    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.image != null ? this.image : CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.IMAGE);
    }
}

