/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractFactorStore;
import org.eclipse.statet.rj.data.impl.RCharacterStructStore;

public class RFactorStructStore
extends AbstractFactorStore {
    private final int levelCount;

    public static RFactorStructStore addLevels(RFactorStore store, final RCharacterStore levels) {
        long levelCount = levels.getLength();
        if (levelCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("levelCount > 2^31-1");
        }
        return new RFactorStructStore(store.isOrdered(), (int)levels.getLength()){

            @Override
            public RCharacterStore getLevels() {
                return levels;
            }
        };
    }

    public RFactorStructStore(boolean isOrdered, int levelCount) {
        this.isOrdered = isOrdered;
        this.levelCount = levelCount;
    }

    @Override
    protected final boolean isStructOnly() {
        return true;
    }

    @Override
    public final long getLength() {
        return -1L;
    }

    @Override
    public boolean isNA(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNA(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getLevelCount() {
        return this.levelCount;
    }

    @Override
    public RCharacterStore getLevels() {
        throw new UnsupportedOperationException();
    }

    public void insertLevel(int position, String label) {
        throw new UnsupportedOperationException();
    }

    public void removeLevel(String label) {
        throw new UnsupportedOperationException();
    }

    public void renameLevel(String oldLabel, String newLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RCharacterStore toCharacterData() {
        return new RCharacterStructStore();
    }

    @Override
    public Integer get(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer get(long idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Integer[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long indexOfNA(long fromIdx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long indexOf(int integer, long fromIdx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long indexOf(String character, long fromIdx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean allEqual(RStore<?> other) {
        return 10 == other.getStoreType() && this.isOrdered == ((RFactorStore)other).isOrdered() && this.levelCount == ((RFactorStore)other).getLevelCount() && -1L == other.getLength();
    }
}

