/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.DocumentModelProvider;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IDocumentProviderExtension2;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.texteditor.IDocumentProviderExtension4;
import org.eclipse.ui.texteditor.IDocumentProviderExtension5;
import org.eclipse.ui.texteditor.IElementStateListener;

@NonNullByDefault
public class ForwardSourceDocumentProvider
implements IDocumentProvider,
IDocumentProviderExtension,
IDocumentProviderExtension2,
IDocumentProviderExtension3,
IDocumentProviderExtension4,
IDocumentProviderExtension5,
IStorageDocumentProvider,
DocumentModelProvider {
    private final SourceDocumentProvider<?> parentProvider;
    private final IDocumentSetupParticipant documentSetup;

    public ForwardSourceDocumentProvider(SourceDocumentProvider<?> parentProvider, IDocumentSetupParticipant documentSetup) {
        if (parentProvider == null) {
            throw new NullPointerException("parentProvider");
        }
        if (documentSetup == null) {
            throw new NullPointerException("documentSetup");
        }
        this.parentProvider = parentProvider;
        this.documentSetup = documentSetup;
    }

    public void connect(Object element) throws CoreException {
        IFile file;
        this.parentProvider.connect(element);
        IDocument document = this.getDocument(element);
        if (this.documentSetup instanceof IDocumentSetupParticipantExtension && element instanceof IFileEditorInput && (file = ((IFileEditorInput)element).getFile()) != null) {
            ((IDocumentSetupParticipantExtension)this.documentSetup).setup(document, file.getFullPath(), LocationKind.IFILE);
            return;
        }
        this.documentSetup.setup(document);
    }

    public void disconnect(Object element) {
        this.parentProvider.disconnect(element);
    }

    public @Nullable IDocument getDocument(@Nullable Object element) {
        return this.parentProvider.getDocument(element);
    }

    public void resetDocument(@Nullable Object element) throws CoreException {
        this.parentProvider.resetDocument(element);
    }

    public void saveDocument(@Nullable IProgressMonitor monitor, @Nullable Object element, IDocument document, boolean overwrite) throws CoreException {
        this.parentProvider.saveDocument(monitor, element, document, overwrite);
    }

    public long getModificationStamp(Object element) {
        return this.parentProvider.getModificationStamp(element);
    }

    public long getSynchronizationStamp(Object element) {
        return this.parentProvider.getSynchronizationStamp(element);
    }

    public boolean isDeleted(@Nullable Object element) {
        return this.parentProvider.isDeleted(element);
    }

    public boolean mustSaveDocument(@Nullable Object element) {
        return this.parentProvider.mustSaveDocument(element);
    }

    public boolean canSaveDocument(@Nullable Object element) {
        return this.parentProvider.canSaveDocument(element);
    }

    public @Nullable IAnnotationModel getAnnotationModel(@Nullable Object element) {
        return this.parentProvider.getAnnotationModel(element);
    }

    public void aboutToChange(@Nullable Object element) {
        this.parentProvider.aboutToChange(element);
    }

    public void changed(@Nullable Object element) {
        this.parentProvider.changed(element);
    }

    public void addElementStateListener(IElementStateListener listener) {
        this.parentProvider.addElementStateListener(listener);
    }

    public void removeElementStateListener(IElementStateListener listener) {
        this.parentProvider.removeElementStateListener(listener);
    }

    public boolean isReadOnly(Object element) {
        return this.parentProvider.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        return this.parentProvider.isModifiable(element);
    }

    public void validateState(Object element, @Nullable Object computationContext) throws CoreException {
        this.parentProvider.validateState(element, computationContext);
    }

    public boolean isStateValidated(Object element) {
        return this.parentProvider.isStateValidated(element);
    }

    public void updateStateCache(Object element) throws CoreException {
        this.parentProvider.updateStateCache(element);
    }

    public void setCanSaveDocument(Object element) {
        this.parentProvider.setCanSaveDocument(element);
    }

    public IStatus getStatus(Object element) {
        return this.parentProvider.getStatus(element);
    }

    public boolean isSynchronized(Object element) {
        return this.parentProvider.isSynchronized(element);
    }

    public void synchronize(Object element) throws CoreException {
        this.parentProvider.synchronize(element);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.parentProvider.getProgressMonitor();
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.parentProvider.setProgressMonitor(progressMonitor);
    }

    public @Nullable IContentType getContentType(Object element) throws CoreException {
        return this.parentProvider.getContentType(element);
    }

    public boolean isNotSynchronizedException(Object element, CoreException ex) {
        return this.parentProvider.isNotSynchronizedException(element, ex);
    }

    public String getDefaultEncoding() {
        return this.parentProvider.getDefaultEncoding();
    }

    public @Nullable String getEncoding(Object element) {
        return this.parentProvider.getEncoding(element);
    }

    public void setEncoding(Object element, @Nullable String encoding) {
        this.parentProvider.setEncoding(element, encoding);
    }

    public @Nullable SourceUnit getWorkingCopy(Object element) {
        return this.parentProvider.getWorkingCopy(element);
    }
}

