/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rtm.ggplot.ui.editors;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.databinding.DetailContext;
import org.eclipse.statet.ecommons.emf.ui.forms.EFPropertySection;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.statet.internal.rtm.ggplot.ui.editors.LayerTextStyleFilter;
import org.eclipse.statet.internal.rtm.ggplot.ui.editors.TextStyleSection;
import org.eclipse.statet.rtm.ggplot.GGPlotPackage;
import org.eclipse.statet.rtm.ggplot.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class TextStylePropertySection
extends EFPropertySection {
    private TextStyleSection formSection;
    private IObservableValue value;

    protected TextStylePropertySection() {
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected IFilter getFilter() {
        return null;
    }

    protected abstract String getLabel();

    protected void createContent(Composite parent) {
        this.formSection = new TextStyleSection((IEFFormPage)this, parent, this.getLabel());
        this.formSection.getSection().setLayoutData((Object)new TableWrapData(256, 128));
    }

    protected void initBindings() {
        IEMFEditContext context = this.createContext();
        this.formSection.addBindings(context);
    }

    protected IEMFEditContext createContext() {
        IObservableValue observable;
        IEMFEditContext rootContext = this.getRootContext();
        if (this.getFeature() != null) {
            observable = EMFProperties.value((EStructuralFeature)this.getFeature()).observeDetail(rootContext.getBaseObservable());
        } else {
            observable = new WritableValue(this.getEditor().getDataBinding().getRealm(), null, TextStyle.class);
            observable.setValue((Object)this.getEObject(this.getSelection()));
            this.value = observable;
        }
        return new DetailContext(rootContext, observable);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.value != null) {
            this.value.setValue((Object)this.getEObject(this.getSelection()));
        }
    }

    protected TextStyle getEObject(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof TextStyle) || this.getFilter() != null && !this.getFilter().select(element)) continue;
                return (TextStyle)element;
            }
        }
        return null;
    }

    public static class AxXLabel
    extends TextStylePropertySection {
        @Override
        protected EStructuralFeature getFeature() {
            return GGPlotPackage.Literals.GG_PLOT__AX_XLABEL_STYLE;
        }

        @Override
        protected String getLabel() {
            return "the Label of the x-Axis";
        }
    }

    public static class AxXText
    extends TextStylePropertySection {
        @Override
        protected EStructuralFeature getFeature() {
            return GGPlotPackage.Literals.GG_PLOT__AX_XTEXT_STYLE;
        }

        @Override
        protected String getLabel() {
            return "the Text of the x-Axis";
        }
    }

    public static class AxYLabel
    extends TextStylePropertySection {
        @Override
        protected EStructuralFeature getFeature() {
            return GGPlotPackage.Literals.GG_PLOT__AX_YLABEL_STYLE;
        }

        @Override
        protected String getLabel() {
            return "the Label of the y-Axis";
        }
    }

    public static class AxYText
    extends TextStylePropertySection {
        @Override
        protected EStructuralFeature getFeature() {
            return GGPlotPackage.Literals.GG_PLOT__AX_YTEXT_STYLE;
        }

        @Override
        protected String getLabel() {
            return "the Text of the y-Axis";
        }
    }

    public static class LayerText
    extends TextStylePropertySection {
        @Override
        protected IFilter getFilter() {
            return LayerTextStyleFilter.INSTANCE;
        }

        @Override
        protected String getLabel() {
            return "the Layer";
        }
    }

    public static class MainTitle
    extends TextStylePropertySection {
        @Override
        protected EStructuralFeature getFeature() {
            return GGPlotPackage.Literals.GG_PLOT__MAIN_TITLE_STYLE;
        }

        @Override
        protected String getLabel() {
            return "the Main Title";
        }
    }
}

