/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractLogicalStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;

public class RLogicalByteFix64Store
extends AbstractLogicalStore
implements ExternalizableRStore {
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;
    public static final int SEGMENT_LENGTH = 0x10000000;
    private final long length;
    private final byte[][] boolValues;

    public RLogicalByteFix64Store(long length) {
        this.length = length;
        this.boolValues = RLogicalByteFix64Store.new2dByteArray(length, 0x10000000);
    }

    public RLogicalByteFix64Store(byte[][] values) {
        this.length = RLogicalByteFix64Store.check2dArrayLength(values, 0x10000000);
        this.boolValues = values;
    }

    public RLogicalByteFix64Store(RJIO io, long length) throws IOException {
        this.length = length;
        this.boolValues = RLogicalByteFix64Store.new2dByteArray(length, 0x10000000);
        int i = 0;
        while (i < this.boolValues.length) {
            io.readByteData(this.boolValues[i], this.boolValues[i].length);
            ++i;
        }
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        int i = 0;
        while (i < this.boolValues.length) {
            io.writeByteData(this.boolValues[i], this.boolValues[i].length);
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.boolValues[idx / 0x10000000][idx % 0x10000000] == 2;
    }

    @Override
    public boolean isNA(long idx) {
        return this.boolValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] == 2;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.boolValues[idx / 0x10000000][idx % 0x10000000] == 2;
    }

    @Override
    public boolean isMissing(long idx) {
        return this.boolValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] == 2;
    }

    @Override
    public void setNA(int idx) {
        this.boolValues[idx / 0x10000000][idx % 0x10000000] = 2;
    }

    @Override
    public void setNA(long idx) {
        this.boolValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = 2;
    }

    @Override
    public boolean getLogi(int idx) {
        return this.boolValues[idx / 0x10000000][idx % 0x10000000] == 1;
    }

    @Override
    public boolean getLogi(long idx) {
        return this.boolValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] == 1;
    }

    @Override
    public void setLogi(int idx, boolean value) {
        this.boolValues[idx / 0x10000000][idx % 0x10000000] = value ? (byte)1 : 0;
    }

    @Override
    public void setLogi(long idx, boolean value) {
        this.boolValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = value ? (byte)1 : 0;
    }

    @Override
    public Boolean get(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        switch (this.boolValues[idx / 0x10000000][idx % 0x10000000]) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public Boolean get(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        switch (this.boolValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)]) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public Boolean[] toArray() {
        int l = this.checkToArrayLength();
        @Nullable Boolean[] array = new Boolean[l];
        int i = 0;
        int destIdx = 0;
        while (i < this.boolValues.length) {
            byte[] bools = this.boolValues[i];
            int j = 0;
            while (j < bools.length) {
                switch (bools[j]) {
                    case 1: {
                        array[destIdx] = Boolean.TRUE;
                        break;
                    }
                    case 0: {
                        array[destIdx] = Boolean.FALSE;
                        break;
                    }
                }
                ++j;
                ++destIdx;
            }
            ++i;
        }
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int i = (int)(fromIdx / 0x10000000L);
        int j = (int)(fromIdx % 0x10000000L);
        while (i < this.boolValues.length) {
            byte[] bools = this.boolValues[i];
            while (j < bools.length) {
                if (bools[i] != 2) continue;
                return (long)i * 0x10000000L + (long)j;
            }
            ++i;
            j = 0;
        }
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long indexOf(int integer, long fromIdx) {
        block6: {
            if (integer == -2147483648) {
                return -1L;
            }
            if (fromIdx < 0L) {
                fromIdx = 0L;
            }
            i = (int)(fromIdx / 0x10000000L);
            j = (int)(fromIdx % 0x10000000L);
            if (integer == 0) ** GOTO lbl23
            while (i < this.boolValues.length) {
                bools = this.boolValues[i];
                while (j < bools.length) {
                    if (bools[i] != 1) continue;
                    return (long)i * 0x10000000L + (long)j;
                }
                ++i;
                j = 0;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                bools = this.boolValues[i];
                while (j < bools.length) {
                    if (bools[i] != 0) continue;
                    return (long)i * 0x10000000L + (long)j;
                }
                ++i;
                j = 0;
lbl23:
                // 2 sources

                ** while (i < this.boolValues.length)
            }
        }
        return -1L;
    }
}

