/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.base.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.base.core.StatetProject;
import org.eclipse.statet.ecommons.net.ssh.core.ISshSessionService;
import org.eclipse.statet.internal.ide.core.BaseCorePlugin;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;

public class StatetCore {
    public static final String BUNDLE_ID = "org.eclipse.statet.ide.core";

    public static Set<StatetProject> getStatetProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<StatetProject> collected = new HashSet<StatetProject>();
        try {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                StatetProject sp = (StatetProject)project.getNature("org.eclipse.statet.ide.resourceProjects.Statet");
                if (sp != null) {
                    collected.add(sp);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            StatetCore.logError(e);
            return new HashSet<StatetProject>(0);
        }
        return collected;
    }

    public static StatetProject getStatetProject(SourceUnit su) {
        if (su instanceof WorkspaceSourceUnit) {
            IProject project = ((WorkspaceSourceUnit)su).getResource().getProject();
            try {
                if (project.hasNature("org.eclipse.statet.ide.resourceProjects.Statet")) {
                    return (StatetProject)project.getNature("org.eclipse.statet.ide.resourceProjects.Statet");
                }
            }
            catch (CoreException e) {
                StatetCore.logError(e);
            }
        }
        return null;
    }

    public static ISshSessionService getSshSessionManager() {
        return BaseCorePlugin.getInstance().getSshSessionManager();
    }

    private static void logError(CoreException e) {
        BaseCorePlugin.getInstance().getLog().log((IStatus)new Status(4, BUNDLE_ID, -1, "Error catched", (Throwable)e));
    }

    private StatetCore() {
    }
}

