/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.ui.util.UnterminatedLaunchAlerter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.launching.RConsoleOptionsTab;
import org.eclipse.statet.internal.r.console.ui.launching.RJEngineLaunchDelegate;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.rmi.RMIRegistryManager;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.runtime.ILogOutput;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolRunner;
import org.eclipse.statet.nico.core.util.HistoryTrackingConfiguration;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsoleColorAdapter;
import org.eclipse.statet.nico.ui.util.WorkbenchStatusHandler;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.ui.RConsole;
import org.eclipse.statet.r.console.ui.launching.RConsoleLaunching;
import org.eclipse.statet.r.console.ui.tools.REnvAutoUpdater;
import org.eclipse.statet.r.console.ui.tools.REnvIndexAutoUpdater;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.launching.core.ILaunchDelegateAddon;
import org.eclipse.statet.r.launching.core.RLaunching;
import org.eclipse.statet.r.nico.RWorkspaceConfig;
import org.eclipse.statet.r.nico.impl.RjsController;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RVersion;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.statushandlers.StatusManager;

public class RConsoleRJLaunchDelegate
extends LaunchConfigurationDelegate {
    static final long TIMEOUT = 60000000000L;
    static final RVersion VERSION_2_12_0 = new RVersion(2, 12, 0);
    private ILaunchDelegateAddon addon;

    static RWorkspaceConfig createWorkspaceConfig(ILaunchConfiguration configuration) throws CoreException {
        RWorkspaceConfig config = new RWorkspaceConfig();
        config.setEnableObjectDB(configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.enabled", true));
        config.setEnableAutoRefresh(configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.autorefresh.enabled", true));
        return config;
    }

    static void initConsoleOptions(RjsController controller, REnvConfiguration rEnvConfig, ILaunchConfiguration configuration, String mode, boolean isStartup) throws CoreException {
        if (rEnvConfig != null) {
            IRPkgManager manager = RCore.getRPkgManager((REnv)rEnvConfig.getREnv());
            REnvAutoUpdater.connect(controller, manager);
            REnvIndexAutoUpdater.connect(controller.getTool(), manager);
        }
        controller.addStartupRunnable((ToolRunnable)new ConfigRunnable((Tool)controller.getTool(), rEnvConfig != null && configuration.getAttribute("org.eclipse.statet.r.debug/integrationintegration.rhelp.enabled", true), configuration.getAttribute("org.eclipse.statet.r.debug/integrationintegration.rgraphics.asdefault", true), configuration.getAttribute("org.eclipse.statet.r.debug/integrationintegration.rdbgext.enabled", true), mode.equals("debug")));
        if (isStartup) {
            RConsoleLaunching.scheduleStartupSnippet((AbstractRController)controller, configuration);
        }
    }

    public RConsoleRJLaunchDelegate() {
    }

    public RConsoleRJLaunchDelegate(ILaunchDelegateAddon addon) {
        this.addon = addon;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean requireCodebase;
        RMIRegistry registry;
        SubMonitor m = LaunchUtils.initProgressMonitor((ILaunchConfiguration)configuration, (IProgressMonitor)monitor, (int)25);
        long timestamp = System.currentTimeMillis();
        IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)false);
        m.worked(1);
        if (m.isCanceled()) {
            return;
        }
        List trackingIds = configuration.getAttribute("tracking.enabled.ids", Collections.EMPTY_LIST);
        ArrayList<HistoryTrackingConfiguration> trackingConfigs = new ArrayList<HistoryTrackingConfiguration>(trackingIds.size());
        for (String id : trackingIds) {
            Object trackingConfig = id.equals("history") ? new HistoryTrackingConfiguration(id) : new TrackingConfiguration(id);
            RConsoleOptionsTab.TRACKING_UTIL.load((TrackingConfiguration)trackingConfig, configuration);
            trackingConfigs.add((HistoryTrackingConfiguration)trackingConfig);
        }
        m.worked(1);
        if (m.isCanceled()) {
            return;
        }
        IREnvConfiguration rEnv = RLaunching.getREnvConfig((ILaunchConfiguration)configuration, (boolean)true);
        String s = System.getProperty("org.eclipse.statet.r.console.rmiRegistryPort");
        int port = -1;
        if (s != null && s.length() > 0) {
            try {
                m.subTask(Messages.LaunchDelegate_CheckingRegistry_subtask);
                port = Integer.parseInt(s);
                RMIAddress registryAddress = new RMIAddress(InetAddress.getLoopbackAddress(), port, null);
                registry = new RMIRegistry(registryAddress, true);
                requireCodebase = true;
            }
            catch (NumberFormatException e) {
                throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.ui", 0, "The registry port specified by 'org.eclipse.statet.r.console.rmiRegistryPort' is invalid.", (Throwable)e));
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.ui", 0, "The registry port specified by 'org.eclipse.statet.r.console.rmiRegistryPort' is invalid.", (Throwable)e));
            }
            catch (RemoteException e) {
                throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.console.ui", 0, "Connection setup to the registry specified by 'org.eclipse.statet.r.console.rmiRegistryPort' failed.", (Throwable)e));
            }
        }
        try {
            registry = RMIRegistryManager.INSTANCE.getEmbeddedPrivateRegistry(EStatusUtils.convertChild((IProgressMonitor)m.newChild(1)));
        }
        catch (StatusException e) {
            throw EStatusUtils.convert((StatusException)e);
        }
        requireCodebase = false;
        m.worked(1);
        if (m.isCanceled()) {
            return;
        }
        m.subTask(Messages.LaunchDelegate_StartREngine_subtask);
        try {
            RMIAddress rmiAddress = new RMIAddress(InetAddress.getLoopbackAddress(), registry.getAddress().getPort(), "rjs-local-" + System.currentTimeMillis());
            RJEngineLaunchDelegate engineLaunchDelegate = new RJEngineLaunchDelegate(rmiAddress.getAddress(), requireCodebase, rEnv);
            RjsComConfig.setRMIClientSocketFactory(null);
            engineLaunchDelegate.launch(configuration, mode, launch, (IProgressMonitor)m.newChild(10));
            IProcess[] processes = launch.getProcesses();
            if (processes.length == 0) {
                return;
            }
            m.worked(1);
            if (m.isCanceled()) {
                return;
            }
            Object[] rArgs = LaunchUtils.getProcessArguments((ILaunchConfiguration)configuration, (String)"org.eclipse.statet.r.debug/RConsole/arguments.options");
            m.worked(1);
            if (m.isCanceled()) {
                return;
            }
            UnterminatedLaunchAlerter.registerLaunchType((String)"org.eclipse.statet.r.launchConfigurations.RConsole");
            RProcess process = new RProcess(launch, rEnv, LaunchUtils.createLaunchPrefix((ILaunchConfiguration)configuration), String.valueOf(rEnv.getName()) + " / RJ " + LaunchUtils.createProcessTimestamp((long)timestamp), rmiAddress.toString(), null, timestamp);
            process.setAttribute(IProcess.ATTR_CMDLINE, String.valueOf(rmiAddress.toString()) + '\n' + Arrays.toString(rArgs));
            m.subTask(Messages.LaunchDelegate_WaitForR_subtask);
            long t = System.nanoTime();
            int i = 0;
            block18: while (true) {
                block31: {
                    if (processes[0].isTerminated()) {
                        boolean silent = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
                        IStatus logStatus = ToolRunner.createOutputLogStatus((ILogOutput)((ILogOutput)processes[0].getAdapter(ILogOutput.class)));
                        StringBuilder sb = new StringBuilder();
                        sb.append("Launching the R Console was cancelled, because it seems starting the R engine failed.");
                        sb.append(engineLaunchDelegate.getDebugInfo());
                        StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(silent ? 1 : 4, "org.eclipse.statet.r.console.ui", sb.toString(), (Throwable)(logStatus != null ? new CoreException(logStatus) : null)), silent ? 1 : 3);
                        return;
                    }
                    if (m.isCanceled()) {
                        processes[0].terminate();
                        throw new CoreException(org.eclipse.core.runtime.Status.CANCEL_STATUS);
                    }
                    try {
                        String[] list;
                        String[] stringArray = list = registry.getRegistry().list();
                        int n = list.length;
                        int sb = 0;
                        while (sb < n) {
                            String entry = stringArray[sb];
                            if (entry.equals(rmiAddress.getName())) break block18;
                            ++sb;
                        }
                        if (i > 1 && System.nanoTime() - t > 60000000000L) {
                        }
                        break block31;
                    }
                    catch (RemoteException e) {
                        if (i <= 0 || System.nanoTime() - t <= 20000000000L) break block31;
                    }
                    break;
                }
                try {
                    Thread.sleep(333L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++i;
            }
            m.worked(5);
            RjsController.RjsConnection connection = RjsController.lookup((Registry)registry.getRegistry(), null, (RMIAddress)rmiAddress);
            HashMap<String, Number> rjsProperties = new HashMap<String, Number>();
            rjsProperties.put("rj.data.structs.lists.max_length", configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.lists.max_length", 10000));
            rjsProperties.put("rj.data.structs.envs.max_length", configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.envs.max_length", 10000));
            rjsProperties.put("rj.session.startup.time", timestamp);
            RjsController controller = new RjsController(process, rmiAddress, connection, null, 257, (String[])rArgs, rjsProperties, engineLaunchDelegate.getWorkingDirectory(), RConsoleRJLaunchDelegate.createWorkspaceConfig(configuration), trackingConfigs);
            process.init((ToolController)controller);
            RConsoleLaunching.registerDefaultHandlerTo((AbstractRController)controller);
            m.worked(5);
            RConsoleRJLaunchDelegate.initConsoleOptions(controller, (REnvConfiguration)rEnv, configuration, mode, true);
            if (this.addon != null) {
                this.addon.init(configuration, mode, (AbstractRController)controller, (IProgressMonitor)m);
            }
            RConsole console = new RConsole(process, new NIConsoleColorAdapter());
            NicoUITools.startConsoleLazy((NIConsole)console, (IWorkbenchPage)page, (boolean)configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/console.pin", false));
            new ToolRunner().runInBackgroundThread((ToolProcess)process, (IStatusHandler)new WorkbenchStatusHandler());
        }
        finally {
            RjsComConfig.clearRMIClientSocketFactory();
        }
        m.done();
    }

    static class ConfigRunnable
    implements SystemRunnable {
        private final Tool tool;
        private final boolean enableRHelp;
        private final boolean enableRGraphics;
        private final boolean enableRDbgExt;
        private final boolean enableRDbg;

        public ConfigRunnable(Tool tool, boolean enableRHelp, boolean enableRGraphics, boolean enableRDbgExt, boolean enableRDbg) {
            this.tool = tool;
            this.enableRHelp = enableRHelp;
            this.enableRGraphics = enableRGraphics;
            this.enableRDbgExt = enableRDbgExt;
            this.enableRDbg = enableRDbg;
        }

        public String getTypeId() {
            return "r/integration";
        }

        public String getLabel() {
            return "Initialize R-StatET Tools";
        }

        public boolean canRunIn(Tool tool) {
            return tool == this.tool;
        }

        public boolean changed(int event, Tool process) {
            return (event & 0xFF0) != 288;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            IRDataAdapter r = (IRDataAdapter)service;
            r.briefAboutToChange();
            try {
                FunctionCall fcall;
                RVersion rVersion = r.getPlatform().getRVersion();
                if (rVersion.compareTo(VERSION_2_12_0) < 0) {
                    r.evalVoid("library('rj')", m);
                } else {
                    r.evalVoid("library('rj', quietly= TRUE)", m);
                }
                if (this.enableRHelp) {
                    fcall = r.createFunctionCall(".statet.initHelp");
                    fcall.evalVoid(m);
                }
                if (this.enableRGraphics) {
                    try {
                        fcall = r.createFunctionCall(".rj.initGD");
                        fcall.addLogi("default", true);
                        RDataUtils.checkSingleLogiValue((RObject)fcall.evalData(m));
                    }
                    catch (StatusException | UnexpectedRDataException e) {
                        r.handleStatus((Status)new WarningStatus("org.eclipse.statet.r.console.ui", "The graphic device for the R Graphic view cannot be initialized.", e), m);
                    }
                }
                fcall = r.createFunctionCall(".statet.initDebug");
                fcall.addLogi("mode", this.enableRDbg);
                fcall.addLogi("ext", this.enableRDbgExt);
                fcall.evalVoid(m);
            }
            finally {
                r.briefChanged(2);
            }
        }
    }
}

