/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.snakeyaml.scanner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SimpleKey;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Constant;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.yaml.snakeyaml.tokens.DirectiveToken;
import org.yaml.snakeyaml.tokens.DocumentEndToken;
import org.yaml.snakeyaml.tokens.DocumentStartToken;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.TagTuple;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;
import org.yaml.snakeyaml.util.ArrayStack;

@NonNullByDefault
public class ScannerImpl {
    private StreamReader reader;
    private boolean done = false;
    private int flowLevel = 0;
    private final List<Token> tokens = new ArrayList<Token>(64);
    private int tokensTaken = 0;
    private int indent = -1;
    private final ArrayStack<Integer> indents = new ArrayStack(16);
    private final StringBuilder tmpSB = new StringBuilder(256);
    private final StringBuilder tmpSB2 = new StringBuilder();
    private int tmpInt;
    private boolean createTagText;
    private boolean createAnchorText;
    private boolean createScalarText;
    private boolean allowSimpleKey = true;
    private final Map<Integer, SimpleKey> possibleSimpleKeys;

    private static final boolean isHex(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
    }

    public ScannerImpl(StreamReader reader) {
        this(reader, true, true, true);
    }

    public ScannerImpl(StreamReader reader, boolean createTagText, boolean createAnchorText, boolean createScalarText) {
        this.reader = reader;
        this.possibleSimpleKeys = new LinkedHashMap<Integer, SimpleKey>();
        this.createTagText = createTagText;
        this.createAnchorText = createAnchorText;
        this.createScalarText = createScalarText;
        this.fetchStreamStart();
    }

    public void setCreateTagText(boolean enable) {
        this.createTagText = enable;
    }

    public boolean getCreateTagText() {
        return this.createTagText;
    }

    public void setCreateAnchorText(boolean enable) {
        this.createAnchorText = enable;
    }

    public boolean getCreateAnchorText() {
        return this.createAnchorText;
    }

    public void setCreateScalarText(boolean enable) {
        this.createScalarText = enable;
    }

    public boolean getCreateScalarText() {
        return this.createScalarText;
    }

    public void setCreateText(boolean enable) {
        this.createTagText = enable;
        this.createAnchorText = enable;
        this.createScalarText = enable;
    }

    public void reset(String s, int index) {
        this.reader = new StreamReader(s);
        this.done = false;
        this.flowLevel = 0;
        this.tokens.clear();
        this.tokensTaken = 0;
        this.indent = -1;
        this.indents.clear();
        this.allowSimpleKey = true;
        this.fetchStreamStart();
    }

    public @Nullable Token nextToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            return this.tokens.remove(0);
        }
        return null;
    }

    public boolean checkToken(Token.ID tokenId) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            return this.tokens.get(0).getTokenId() == tokenId;
        }
        return false;
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        return this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private void fetchMoreTokens() {
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        this.unwindIndent(this.reader.getColumn());
        int c = this.reader.peek();
        switch (c) {
            case 0: {
                this.fetchStreamEnd();
                return;
            }
            case 37: {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case 45: {
                if (this.checkDocumentStart()) {
                    this.fetchDocumentStart();
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case 46: {
                if (!this.checkDocumentEnd()) break;
                this.fetchDocumentEnd();
                return;
            }
            case 91: {
                this.fetchFlowSequenceStart();
                return;
            }
            case 123: {
                this.fetchFlowMappingStart();
                return;
            }
            case 93: {
                this.fetchFlowSequenceEnd();
                return;
            }
            case 125: {
                this.fetchFlowMappingEnd();
                return;
            }
            case 44: {
                this.fetchFlowEntry();
                return;
            }
            case 63: {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case 58: {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case 42: {
                this.fetchAlias();
                return;
            }
            case 38: {
                this.fetchAnchor();
                return;
            }
            case 33: {
                this.fetchTag();
                return;
            }
            case 124: {
                if (this.flowLevel != 0) break;
                this.fetchLiteral();
                return;
            }
            case 62: {
                if (this.flowLevel != 0) break;
                this.fetchFolded();
                return;
            }
            case 39: {
                this.fetchSingle();
                return;
            }
            case 34: {
                this.fetchDouble();
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        this.newScannerException((byte)1, null, (byte)1, this.getCharPresentation(c), null, this.reader.getMark());
        this.reader.forward(1);
    }

    private String getCharPresentation(int c) {
        String chRepresentation = new String(Character.toChars(c));
        for (Map.Entry entry : org.yaml.snakeyaml.scanner.ScannerImpl.ESCAPE_REPLACEMENTS.entrySet()) {
            if (!((String)entry.getValue()).equals(chRepresentation)) continue;
            return "\\" + entry.getKey();
        }
        return chRepresentation;
    }

    private int nextPossibleSimpleKey() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            return this.possibleSimpleKeys.values().iterator().next().getTokenNumber();
        }
        return -1;
    }

    private void stalePossibleSimpleKeys() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            Iterator<SimpleKey> iterator = this.possibleSimpleKeys.values().iterator();
            while (iterator.hasNext()) {
                SimpleKey key = iterator.next();
                if (key.getLine() == this.reader.getLine() && this.reader.getIndex() - key.getIndex() <= 1024) continue;
                if (key.isRequired()) {
                    this.newScannerException((byte)7, key.getMark(), (byte)17, this.reader.getMark());
                }
                iterator.remove();
            }
        }
    }

    private void savePossibleSimpleKey() {
        boolean required;
        boolean bl = required = this.flowLevel == 0 && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && required) {
            throw new YAMLException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            Mark mark = this.reader.getMark();
            this.removePossibleSimpleKey(mark);
            int tokenNumber = this.tokensTaken + this.tokens.size();
            SimpleKey key = new SimpleKey(tokenNumber, required, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), mark);
            this.possibleSimpleKeys.put(this.flowLevel, key);
        }
    }

    private void removePossibleSimpleKey(Mark mark) {
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null && key.isRequired()) {
            this.newScannerException((byte)7, key.getMark(), (byte)17, mark);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void unwindIndent(int col) {
        if (this.flowLevel == 0) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            mark = this.reader.getMark();
            this.indent = (Integer)this.indents.pop();
            this.tokens.add((Token)new BlockEndToken(mark, mark));
lbl7:
            // 2 sources

            ** while (this.indent > col)
        }
lbl8:
        // 1 sources

    }

    private boolean addIndent(int column) {
        if (this.indent < column) {
            this.indents.push((Object)this.indent);
            this.indent = column;
            return true;
        }
        return false;
    }

    private void fetchStreamStart() {
        Mark mark = this.reader.getMark();
        StreamStartToken token = new StreamStartToken(mark, mark);
        this.tokens.add((Token)token);
    }

    private void fetchStreamEnd() {
        this.unwindIndent(-1);
        Mark mark = this.reader.getMark();
        this.removePossibleSimpleKey(mark);
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        StreamEndToken token = new StreamEndToken(mark, mark);
        this.tokens.add((Token)token);
        this.done = true;
    }

    private void fetchDirective() {
        this.unwindIndent(-1);
        Mark startMark = this.reader.getMark();
        this.removePossibleSimpleKey(startMark);
        this.allowSimpleKey = false;
        Token tok = this.scanDirective(startMark);
        this.tokens.add(tok);
    }

    private void fetchDocumentStart() {
        this.fetchDocumentIndicator(true);
    }

    private void fetchDocumentEnd() {
        this.fetchDocumentIndicator(false);
    }

    private void fetchDocumentIndicator(boolean isDocumentStart) {
        this.unwindIndent(-1);
        Mark startMark = this.reader.getMark();
        this.removePossibleSimpleKey(startMark);
        this.allowSimpleKey = false;
        this.reader.forward(3);
        Mark endMark = this.reader.getMark();
        Object token = isDocumentStart ? new DocumentStartToken(startMark, endMark) : new DocumentEndToken(startMark, endMark);
        this.tokens.add((Token)token);
    }

    private void fetchFlowSequenceStart() {
        this.fetchFlowCollectionStart(false);
    }

    private void fetchFlowMappingStart() {
        this.fetchFlowCollectionStart(true);
    }

    private void fetchFlowCollectionStart(boolean isMappingStart) {
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        Mark startMark = this.reader.getMark();
        this.reader.forward(1);
        Mark endMark = this.reader.getMark();
        Object token = isMappingStart ? new FlowMappingStartToken(startMark, endMark) : new FlowSequenceStartToken(startMark, endMark);
        this.tokens.add((Token)token);
    }

    private void fetchFlowSequenceEnd() {
        this.fetchFlowCollectionEnd(false);
    }

    private void fetchFlowMappingEnd() {
        this.fetchFlowCollectionEnd(true);
    }

    private void fetchFlowCollectionEnd(boolean isMappingEnd) {
        Mark startMark = this.reader.getMark();
        this.removePossibleSimpleKey(startMark);
        --this.flowLevel;
        this.allowSimpleKey = false;
        this.reader.forward();
        Mark endMark = this.reader.getMark();
        Object token = isMappingEnd ? new FlowMappingEndToken(startMark, endMark) : new FlowSequenceEndToken(startMark, endMark);
        this.tokens.add((Token)token);
    }

    private void fetchFlowEntry() {
        Mark startMark = this.reader.getMark();
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        Mark endMark = this.reader.getMark();
        FlowEntryToken token = new FlowEntryToken(startMark, endMark);
        this.tokens.add((Token)token);
    }

    private void fetchBlockEntry() {
        Mark startMark = this.reader.getMark();
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, (byte)18, startMark);
            }
            if (this.addIndent(this.reader.getColumn())) {
                this.tokens.add((Token)new BlockSequenceStartToken(startMark, startMark));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        Mark endMark = this.reader.getMark();
        BlockEntryToken token = new BlockEntryToken(startMark, endMark);
        this.tokens.add((Token)token);
    }

    private void fetchKey() {
        Mark startMark = this.reader.getMark();
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, (byte)19, startMark);
            }
            if (this.addIndent(this.reader.getColumn())) {
                Mark mark = this.reader.getMark();
                this.tokens.add((Token)new BlockMappingStartToken(mark, mark));
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        Mark endMark = this.reader.getMark();
        KeyToken token = new KeyToken(startMark, endMark);
        this.tokens.add((Token)token);
    }

    private void fetchValue() {
        Mark startMark = this.reader.getMark();
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null) {
            this.tokens.add(key.getTokenNumber() - this.tokensTaken, (Token)new KeyToken(key.getMark(), key.getMark()));
            if (this.flowLevel == 0 && this.addIndent(key.getColumn())) {
                this.tokens.add(key.getTokenNumber() - this.tokensTaken, (Token)new BlockMappingStartToken(key.getMark(), key.getMark()));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, (byte)20, startMark);
            }
            if (this.flowLevel == 0 && this.addIndent(this.reader.getColumn())) {
                Mark mark = this.reader.getMark();
                this.tokens.add((Token)new BlockMappingStartToken(mark, mark));
            }
            this.allowSimpleKey = this.flowLevel == 0;
            this.removePossibleSimpleKey(startMark);
        }
        this.reader.forward();
        Mark endMark = this.reader.getMark();
        ValueToken token = new ValueToken(startMark, endMark);
        this.tokens.add((Token)token);
    }

    private void fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor((byte)9);
        this.tokens.add(tok);
    }

    private void fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor((byte)8);
        this.tokens.add(tok);
    }

    private void fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanTag();
        this.tokens.add(tok);
    }

    private void fetchLiteral() {
        this.fetchBlockScalar('|');
    }

    private void fetchFolded() {
        this.fetchBlockScalar('>');
    }

    private void fetchBlockScalar(char style) {
        Mark startMark = this.reader.getMark();
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        Token tok = this.scanBlockScalar(style, startMark);
        this.tokens.add(tok);
    }

    private void fetchSingle() {
        this.fetchFlowScalar((byte)12);
    }

    private void fetchDouble() {
        this.fetchFlowScalar((byte)13);
    }

    private void fetchFlowScalar(byte context) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanFlowScalar(context);
        this.tokens.add(tok);
    }

    private void fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanPlain();
        this.tokens.add(tok);
    }

    private boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private boolean checkDocumentStart() {
        return this.reader.getColumn() == 0 && "---".equals(this.reader.prefix(3)) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3));
    }

    private boolean checkDocumentEnd() {
        return this.reader.getColumn() == 0 && "...".equals(this.reader.prefix(3)) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3));
    }

    private boolean checkBlockEntry() {
        return Constant.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkKey() {
        if (this.flowLevel != 0) {
            return true;
        }
        return Constant.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkValue() {
        if (this.flowLevel != 0) {
            return true;
        }
        return Constant.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkPlain() {
        int c = this.reader.peek();
        return Constant.NULL_BL_T_LINEBR.hasNo(c, "-?:,[]{}#&*!|>'\"%@`") || Constant.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1)) && (c == 45 || this.flowLevel == 0 && "?:".indexOf(c) != -1);
    }

    private void scanToNextToken() {
        if (this.reader.getIndex() == 0 && this.reader.peek() == 65279) {
            this.reader.forward();
        }
        boolean found = false;
        while (!found) {
            int ff = 0;
            while (this.reader.peek(ff) == 32) {
                ++ff;
            }
            if (ff > 0) {
                this.reader.forward(ff);
            }
            if (this.reader.peek() == 35) {
                this.forwardComment();
            }
            if (this.scanLineBreak().length() != 0) {
                if (this.flowLevel != 0) continue;
                this.allowSimpleKey = true;
                continue;
            }
            found = true;
        }
    }

    private void forwardComment() {
        int beginIndex = this.reader.getIndex();
        while (Constant.NULL_OR_LINEBR.hasNo(this.reader.peek())) {
            this.reader.forward();
        }
        this.handleComment(beginIndex, this.reader.getIndex());
    }

    private Token scanDirective(Mark startMark) {
        Mark endMark;
        this.reader.forward();
        String name = this.scanDirectiveName(startMark);
        List<Object> value = null;
        if ("YAML".equals(name)) {
            value = this.scanYamlDirectiveValue(startMark);
            endMark = this.reader.getMark();
            this.scanIgnoredLineTail((byte)3, startMark);
        } else if ("TAG".equals(name)) {
            value = this.scanTagDirectiveValue(startMark);
            endMark = this.reader.getMark();
            this.scanIgnoredLineTail((byte)3, startMark);
        } else {
            endMark = this.reader.getMark();
            this.forwardToLineEnd();
        }
        return new DirectiveToken(name, value, startMark, endMark);
    }

    private void forwardToLineEnd() {
        while (Constant.NULL_OR_LINEBR.hasNo(this.reader.peek())) {
            this.reader.forward();
        }
    }

    private @Nullable String scanDirectiveName(Mark startMark) {
        int length = 0;
        while (Constant.ALPHA.has(this.reader.peek(length))) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException((byte)3, startMark, (byte)9, this.reader.getMark());
            return null;
        }
        if (Constant.NULL_BL_LINEBR.hasNo(this.reader.peek())) {
            this.newScannerException((byte)3, startMark, (byte)1, this.reader.peek(), null, this.reader.getMark());
        }
        return this.reader.prefixForward(length);
    }

    private List<Integer> scanYamlDirectiveValue(Mark startMark) {
        Integer minor;
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        Integer major = this.scanYamlDirectiveNumber(startMark);
        if (this.reader.peek() != 46) {
            this.newScannerException((byte)4, startMark, (byte)10, this.reader.peek(), null, this.reader.getMark());
            minor = null;
        } else {
            this.reader.forward();
            minor = this.scanYamlDirectiveNumber(startMark);
            if (Constant.NULL_BL_LINEBR.hasNo(this.reader.peek())) {
                this.newScannerException((byte)4, startMark, (byte)10, this.reader.peek(), null, this.reader.getMark());
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        result.add(major);
        result.add(minor);
        return result;
    }

    private @Nullable Integer scanYamlDirectiveNumber(Mark startMark) {
        int c;
        int length = 0;
        while ((c = this.reader.peek(length)) >= 48 && c <= 57) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException((byte)4, startMark, (byte)10, c, null, this.reader.getMark());
            return null;
        }
        Integer value = Integer.parseInt(this.reader.prefixForward(length));
        return value;
    }

    private @Nullable List<String> scanTagDirectiveValue(Mark startMark) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        String handle = this.scanTagDirectiveHandle(startMark);
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        String prefix = this.scanTagDirectivePrefix(startMark);
        if (this.createTagText) {
            ArrayList<String> result = new ArrayList<String>(2);
            result.add(handle);
            result.add(prefix);
            return result;
        }
        return null;
    }

    private @Nullable String scanTagDirectiveHandle(Mark startMark) {
        String value = this.scanTagHandle((byte)5, startMark);
        int c = this.reader.peek();
        if (c != 32) {
            this.newScannerException((byte)5, startMark, (byte)2, c, " ", this.reader.getMark());
        }
        return value;
    }

    private String scanTagDirectivePrefix(Mark startMark) {
        String value = this.scanTagUri((byte)5, startMark);
        int c = this.reader.peek();
        if (Constant.NULL_BL_LINEBR.hasNo(c)) {
            this.newScannerException((byte)5, startMark, (byte)2, c, " ", this.reader.getMark());
        }
        return value;
    }

    private void scanIgnoredLineTail(byte context, Mark startMark) {
        int c;
        String lineBreak;
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        if (this.reader.peek() == 35) {
            this.forwardComment();
        }
        if ((lineBreak = this.scanLineBreak()).isEmpty() && (c = this.reader.peek()) != 0) {
            this.newScannerException(context, startMark, (byte)1, c, null, this.reader.getMark());
            this.forwardToLineEnd();
        }
    }

    private Token scanAnchor(byte context) {
        int c;
        Mark startMark = this.reader.getMark();
        this.reader.peek();
        this.reader.forward();
        int length = 0;
        while (Constant.ALPHA.has(c = this.reader.peek(length))) {
            ++length;
        }
        String value = null;
        if (length == 0) {
            this.newScannerException(context, startMark, (byte)12, this.reader.getMark());
        } else {
            if (this.createAnchorText) {
                value = this.reader.prefixForward(length);
            } else {
                this.reader.forward(length);
            }
            c = this.reader.peek();
            if (Constant.NULL_BL_T_LINEBR.hasNo(c, "?:,]}%@`")) {
                this.newScannerException(context, startMark, (byte)1, c, null, this.reader.getMark());
            }
        }
        Mark endMark = this.reader.getMark();
        Object tok = context == 8 ? new AnchorToken(value, startMark, endMark) : new AliasToken(value, startMark, endMark);
        return tok;
    }

    private Token scanTag() {
        Mark startMark = this.reader.getMark();
        String handle = null;
        String suffix = null;
        int c = this.reader.peek(1);
        if (c == 60) {
            this.reader.forward(2);
            suffix = this.scanTagUri((byte)10, startMark);
            c = this.reader.peek();
            if (c != 62) {
                this.newScannerException((byte)10, startMark, (byte)2, c, ">", this.reader.getMark());
            } else {
                this.reader.forward();
            }
        } else if (Constant.NULL_BL_T_LINEBR.has(c)) {
            suffix = "!";
            this.reader.forward();
        } else {
            int length = 1;
            boolean useHandle = false;
            while (Constant.NULL_BL_LINEBR.hasNo(c)) {
                if (c == 33) {
                    useHandle = true;
                    break;
                }
                c = this.reader.peek(++length);
            }
            if (useHandle) {
                handle = this.scanTagHandle((byte)10, startMark);
            } else {
                handle = "!";
                this.reader.forward();
            }
            suffix = this.scanTagUri((byte)10, startMark);
        }
        c = this.reader.peek();
        if (Constant.NULL_BL_LINEBR.hasNo(c)) {
            this.newScannerException((byte)10, startMark, (byte)2, c, " ", this.reader.getMark());
        }
        TagTuple value = new TagTuple(handle, suffix);
        Mark endMark = this.reader.getMark();
        return new TagToken(value, startMark, endMark);
    }

    private Token scanBlockScalar(char style, Mark startMark) {
        int indent;
        Mark endMark;
        boolean folded = style == '>';
        StringBuilder chunks = this.getScalarSB();
        this.reader.forward();
        Chomping chompi = this.scanBlockScalarIndicators(startMark);
        this.scanIgnoredLineTail((byte)11, startMark);
        int minIndent = this.indent + 1;
        if (minIndent < 1) {
            minIndent = 1;
        }
        if (chompi.getIncrement() == -1) {
            endMark = this.scanBlockScalarIndentation();
            int maxIndent = this.tmpInt;
            indent = Math.max(minIndent, maxIndent);
        } else {
            indent = minIndent + chompi.getIncrement() - 1;
            endMark = this.scanBlockScalarBreaks(indent);
        }
        String lineBreak = "";
        while (this.reader.getColumn() == indent && this.reader.peek() != 0) {
            if (chunks != null) {
                chunks.append(this.getBreaks());
            }
            boolean leadingNonSpace = " \t".indexOf(this.reader.peek()) == -1;
            int length = 0;
            while (Constant.NULL_OR_LINEBR.hasNo(this.reader.peek(length))) {
                ++length;
            }
            if (chunks != null) {
                chunks.append(this.reader.prefix(length));
            }
            this.reader.forward(length);
            lineBreak = this.scanLineBreak();
            endMark = this.scanBlockScalarBreaks(indent);
            if (this.reader.getColumn() != indent || this.reader.peek() == 0) break;
            if (chunks == null) continue;
            if (folded && "\n".equals(lineBreak) && leadingNonSpace && " \t".indexOf(this.reader.peek()) == -1) {
                if (this.getBreaks().length() != 0) continue;
                chunks.append(" ");
                continue;
            }
            chunks.append(lineBreak);
        }
        if (chunks != null) {
            if (chompi.chompTailIsNotFalse()) {
                chunks.append(lineBreak);
            }
            if (chompi.chompTailIsTrue()) {
                chunks.append(this.getBreaks());
            }
        }
        return new ScalarToken(chunks != null ? chunks.toString() : null, false, startMark, endMark, DumperOptions.ScalarStyle.createStyle((Character)Character.valueOf(style)));
    }

    private Chomping scanBlockScalarIndicators(Mark startMark) {
        Boolean chomping = null;
        int increment = -1;
        int c = this.reader.peek();
        if (c == 45 || c == 43) {
            chomping = c == 43 ? Boolean.TRUE : Boolean.FALSE;
            this.reader.forward();
            c = this.reader.peek();
        }
        if (c >= 49 && c <= 57) {
            increment = Integer.parseInt(String.valueOf((char)c));
            this.reader.forward();
        }
        if (increment != -1 && chomping == null && ((c = this.reader.peek()) == 45 || c == 43)) {
            chomping = c == 43 ? Boolean.TRUE : Boolean.FALSE;
            this.reader.forward();
        }
        return new Chomping(chomping, increment);
    }

    private Mark scanBlockScalarIndentation() {
        StringBuilder chunks = this.getBreaksSB();
        int maxIndent = 0;
        Mark endMark = this.reader.getMark();
        while (Constant.LINEBR.has(this.reader.peek(), " \r")) {
            if (this.reader.peek() != 32) {
                chunks.append(this.scanLineBreak());
                endMark = this.reader.getMark();
                continue;
            }
            this.reader.forward();
            if (this.reader.getColumn() <= maxIndent) continue;
            maxIndent = this.reader.getColumn();
        }
        this.tmpInt = maxIndent;
        return endMark;
    }

    private Mark scanBlockScalarBreaks(int indent) {
        StringBuilder chunks = this.getBreaksSB();
        Mark endMark = this.reader.getMark();
        int col = this.reader.getColumn();
        while (col < indent && this.reader.peek() == 32) {
            this.reader.forward();
            ++col;
        }
        String lineBreak = null;
        while ((lineBreak = this.scanLineBreak()).length() != 0) {
            chunks.append(lineBreak);
            endMark = this.reader.getMark();
            col = this.reader.getColumn();
            while (col < indent && this.reader.peek() == 32) {
                this.reader.forward();
                ++col;
            }
        }
        return endMark;
    }

    private Token scanFlowScalar(byte context) {
        boolean doubleQuoted;
        DumperOptions.ScalarStyle style;
        switch (context) {
            case 13: {
                style = DumperOptions.ScalarStyle.DOUBLE_QUOTED;
                doubleQuoted = true;
                break;
            }
            case 12: {
                style = DumperOptions.ScalarStyle.SINGLE_QUOTED;
                doubleQuoted = false;
                break;
            }
            default: {
                throw new IllegalStateException(Integer.toString(context));
            }
        }
        StringBuilder chunks = this.getScalarSB();
        Mark startMark = this.reader.getMark();
        char quote = style.getChar().charValue();
        if (this.reader.peek() != quote) {
            throw new IllegalStateException(new String(Character.toChars(this.reader.peek())));
        }
        this.reader.forward();
        this.scanFlowScalarNonSpaces(doubleQuoted, startMark, chunks);
        while (true) {
            if (this.reader.peek() == quote) {
                this.reader.forward();
                break;
            }
            if (!this.scanFlowScalarSpaces(context, startMark, chunks)) {
                this.newScannerException(context, startMark, (byte)4, this.reader.getMark());
                break;
            }
            this.scanFlowScalarNonSpaces(doubleQuoted, startMark, chunks);
        }
        Mark endMark = this.reader.getMark();
        return new ScalarToken(chunks != null ? chunks.toString() : null, false, startMark, endMark, style);
    }

    private void scanFlowScalarNonSpaces(boolean doubleQuoted, Mark startMark, @Nullable StringBuilder chunks) {
        while (true) {
            Character ch;
            int length = 0;
            while (Constant.NULL_BL_T_LINEBR.hasNo(this.reader.peek(length), "'\"\\")) {
                ++length;
            }
            if (length != 0) {
                if (chunks != null) {
                    chunks.append(this.reader.prefix(length));
                }
                this.reader.forward(length);
            }
            int c = this.reader.peek();
            if (!doubleQuoted && c == 39 && this.reader.peek(1) == 39) {
                if (chunks != null) {
                    chunks.append("'");
                }
                this.reader.forward(2);
                continue;
            }
            if (doubleQuoted && c == 39 || !doubleQuoted && "\"\\".indexOf(c) != -1) {
                if (chunks != null) {
                    chunks.appendCodePoint(c);
                }
                this.reader.forward();
                continue;
            }
            if (!doubleQuoted || c != 92) break;
            this.reader.forward();
            c = this.reader.peek();
            Character c2 = ch = Character.isBmpCodePoint(c) ? Character.valueOf((char)c) : null;
            if (ch != null && org.yaml.snakeyaml.scanner.ScannerImpl.ESCAPE_REPLACEMENTS.containsKey(ch)) {
                this.reader.forward();
                if (chunks == null) continue;
                chunks.append((String)org.yaml.snakeyaml.scanner.ScannerImpl.ESCAPE_REPLACEMENTS.get(ch));
                continue;
            }
            if (ch != null && org.yaml.snakeyaml.scanner.ScannerImpl.ESCAPE_CODES.containsKey(ch)) {
                this.reader.forward();
                int expLength = (Integer)org.yaml.snakeyaml.scanner.ScannerImpl.ESCAPE_CODES.get(ch);
                length = 0;
                while (length < expLength) {
                    c = this.reader.peek(length);
                    if (!ScannerImpl.isHex(c)) break;
                    ++length;
                }
                if (length != expLength) {
                    this.newScannerException((byte)13, startMark, (byte)3, this.reader.prefix(length), null, this.reader.getMark());
                    chunks = null;
                } else if (chunks != null) {
                    int codePoint = Integer.parseInt(this.reader.prefix(length), 16);
                    chunks.appendCodePoint(codePoint);
                }
                this.reader.forward(length);
                continue;
            }
            if (this.scanLineBreak().length() != 0) {
                this.scanFlowScalarBreaks((byte)13, startMark);
                if (chunks == null) continue;
                chunks.append(this.getBreaks());
                continue;
            }
            this.newScannerException((byte)13, startMark, (byte)3, c, null, this.reader.getMark());
        }
    }

    private boolean scanFlowScalarSpaces(byte context, Mark startMark, @Nullable StringBuilder chunks) {
        int length = 0;
        while (" \t".indexOf(this.reader.peek(length)) != -1) {
            ++length;
        }
        String whitespaces = chunks != null ? this.reader.prefix(length) : null;
        this.reader.forward(length);
        if (this.reader.peek() == 0) {
            return false;
        }
        String lineBreak = this.scanLineBreak();
        if (lineBreak.length() != 0) {
            if (!this.scanFlowScalarBreaks(context, startMark)) {
                return false;
            }
            if (chunks != null) {
                String breaks = this.getBreaks();
                if (!"\n".equals(lineBreak)) {
                    chunks.append(lineBreak);
                } else if (breaks.length() == 0) {
                    chunks.append(" ");
                }
                chunks.append(breaks);
            }
        } else if (chunks != null) {
            chunks.append(whitespaces);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean scanFlowScalarBreaks(byte context, Mark startMark) {
        chunks = this.getBreaksSB();
        while (true) {
            if (!"---".equals(prefix = this.reader.prefix(3)) && !"...".equals(prefix) || !Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                this.reader.forward();
lbl6:
                // 2 sources

                ** while (" \t".indexOf((int)this.reader.peek()) != -1)
            }
lbl7:
            // 1 sources

            lineBreak = this.scanLineBreak();
            if (lineBreak.length() == 0) break;
            chunks.append(lineBreak);
        }
        return true;
    }

    private Token scanPlain() {
        Mark startMark;
        StringBuilder chunks = this.getScalarSB();
        Mark endMark = startMark = this.reader.getMark();
        int indent = this.indent + 1;
        String spaces = "";
        do {
            int c;
            int length = 0;
            if (this.reader.peek() == 35) break;
            while (!(Constant.NULL_BL_T_LINEBR.has(c = this.reader.peek(length)) || c == 58 && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(length + 1), this.flowLevel != 0 ? ",[]{}" : "") || this.flowLevel != 0 && ",?[]{}".indexOf(c) != -1)) {
                ++length;
            }
            if (this.flowLevel != 0 && c == 58 && Constant.NULL_BL_T_LINEBR.hasNo(this.reader.peek(length + 1), ",[]{}")) {
                this.reader.forward(length);
                this.newScannerException((byte)14, startMark, (byte)1, ":", null, this.reader.getMark());
                break;
            }
            if (length == 0) break;
            this.allowSimpleKey = false;
            if (chunks != null) {
                chunks.append(spaces);
                chunks.append(this.reader.prefix(length));
            }
            this.reader.forward(length);
            endMark = this.reader.getMark();
        } while ((spaces = this.scanPlainSpaces()).length() != 0 && this.reader.peek() != 35 && (this.flowLevel != 0 || this.reader.getColumn() >= indent));
        return new ScalarToken(chunks != null ? chunks.toString() : null, startMark, endMark, true);
    }

    private String scanPlainSpaces() {
        int length = 0;
        while (this.reader.peek(length) == 32 || this.reader.peek(length) == 9) {
            ++length;
        }
        String whitespaces = this.reader.prefixForward(length);
        String lineBreak = this.scanLineBreak();
        if (lineBreak.length() != 0) {
            StringBuilder breaks;
            block7: {
                this.allowSimpleKey = true;
                String prefix = this.reader.prefix(3);
                if ("---".equals(prefix) || "...".equals(prefix) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                    return "";
                }
                breaks = this.getBreaksSB();
                while (true) {
                    if (this.reader.peek() == 32) {
                        this.reader.forward();
                        continue;
                    }
                    String lb = this.scanLineBreak();
                    if (lb.length() == 0) break block7;
                    breaks.append(lb);
                    prefix = this.reader.prefix(3);
                    if ("---".equals(prefix) || "...".equals(prefix) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) break;
                }
                return "";
            }
            if (!"\n".equals(lineBreak)) {
                return String.valueOf(lineBreak) + breaks;
            }
            if (breaks.length() == 0) {
                return " ";
            }
            return breaks.toString();
        }
        return whitespaces;
    }

    private @Nullable String scanTagHandle(byte context, Mark startMark) {
        String value = null;
        int c = this.reader.peek();
        if (c != 33) {
            this.newScannerException(context, startMark, (byte)1, c, "!", this.reader.getMark());
            return "";
        }
        int length = 1;
        c = this.reader.peek(length);
        if (c != 32) {
            while (Constant.ALPHA.has(c)) {
                c = this.reader.peek(++length);
            }
            if (c == 33) {
                ++length;
            } else {
                this.newScannerException(context, startMark, (byte)1, c, null, this.reader.getMark());
            }
        }
        if (this.createTagText) {
            value = this.reader.prefix(length);
        }
        this.reader.forward(length);
        return value;
    }

    private String scanTagUri(byte context, Mark startMark) {
        int length = 0;
        while (Constant.URI_CHARS.has(this.reader.peek(length))) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException(context, startMark, (byte)11, this.reader.getMark());
        }
        return this.reader.prefixForward(length);
    }

    private String scanLineBreak() {
        switch (this.reader.peek()) {
            case 10: 
            case 133: {
                this.reader.forward();
                return "\n";
            }
            case 13: {
                if (10 == this.reader.peek(1)) {
                    this.reader.forward(2);
                } else {
                    this.reader.forward();
                }
                return "\n";
            }
            case 8232: {
                this.reader.forward();
                return "\u2028";
            }
            case 8233: {
                this.reader.forward();
                return "\u2029";
            }
        }
        return "";
    }

    private @Nullable StringBuilder getScalarSB() {
        if (this.createScalarText) {
            this.tmpSB.setLength(0);
            return this.tmpSB;
        }
        return null;
    }

    private StringBuilder getBreaksSB() {
        this.tmpSB2.setLength(0);
        return this.tmpSB2;
    }

    private String getBreaks() {
        return this.tmpSB2.toString();
    }

    private void newScannerException(byte context, Mark contextMark, byte problem, Mark problemMark) {
        this.handleSyntaxProblem(context, contextMark, problem, problemMark, null, null);
    }

    private void newScannerException(byte context, @Nullable Mark contextMark, byte problem, String problemArg1, @Nullable String problemArg2, Mark problemMark) {
        this.handleSyntaxProblem(context, contextMark, problem, problemMark, problemArg1, null);
    }

    private void newScannerException(byte context, Mark contextMark, byte problem, int problemArg1, @Nullable String problemArg2, Mark problemMark) {
        this.handleSyntaxProblem(context, contextMark, problem, problemMark, String.valueOf(problemArg1), problemArg2);
    }

    protected void handleSyntaxProblem(byte context, @Nullable Mark contextMark, byte problem, @Nullable Mark problemMark, @Nullable String problemArg1, @Nullable String problemArg2) {
    }

    protected void handleComment(int startIndex, int endIndex) {
    }

    private static class Chomping {
        private final @Nullable Boolean value;
        private final int increment;

        public Chomping(@Nullable Boolean value, int increment) {
            this.value = value;
            this.increment = increment;
        }

        public boolean chompTailIsNotFalse() {
            return this.value == null || this.value != false;
        }

        public boolean chompTailIsTrue() {
            return this.value != null && this.value != false;
        }

        public int getIncrement() {
            return this.increment;
        }
    }
}

