/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.sourcelookup;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.internal.r.debug.core.model.RStackFrame;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.r.console.core.RDbg;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.model.RLangMethod;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.rsource.ast.Block;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAsts;
import org.eclipse.statet.r.debug.core.sourcelookup.IRSourceContainer;
import org.eclipse.statet.r.debug.core.sourcelookup.IRSourceLookupMatch;
import org.eclipse.statet.r.debug.core.sourcelookup.RRuntimeSourceFragment;
import org.eclipse.statet.r.nico.IRSrcref;
import org.eclipse.statet.rj.server.dbg.FrameContext;
import org.eclipse.statet.rj.server.dbg.Srcfiles;

public class RSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private static final boolean DEBUG_LOG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.r.debug/debug/SourceLookup/log"));
    private static final int QUALITY_EXACT_FILE_TIMESTAMP = 23;
    private static final int QUALITY_EXACT_FILE_CONTENT = 22;
    private static final int QUALITY_EXACT_FUNCTION_CONTENT = 13;
    private static final int QUALITY_POSITION_FOUND = 10;

    public String getSourceName(Object object) throws CoreException {
        RStackFrame frame;
        FrameContext context;
        if (object instanceof RStackFrame && (context = (frame = (RStackFrame)object).getContext()).getFileName() != null) {
            return context.getFileName();
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        if (object instanceof RStackFrame) {
            ArrayList<RSourceLookupMatch> matches = new ArrayList<RSourceLookupMatch>();
            LookupData data = new LookupData((RStackFrame)object);
            try {
                RSourceLookupMatch match;
                boolean addedFile = false;
                int bestQuality = -1;
                boolean findDuplicates = this.isFindDuplicates();
                if (DEBUG_LOG) {
                    data.addStatus((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"Beginning R source lookup for {0}.", (Object)object), null));
                }
                if (data.context == null) {
                    if (DEBUG_LOG) {
                        data.addStatus((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, "Context with detail is not available.", null));
                    }
                    Object[] objectArray = new Object[]{IRSourceLookupMatch.NO_CONTEXT_INFORMATION};
                    return objectArray;
                }
                if (data.context.getFileName() == null && data.context.getSourceCode() == null) {
                    if (DEBUG_LOG) {
                        data.addStatus((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, "Context with detail is not available.", null));
                    }
                    Object[] objectArray = new Object[]{IRSourceLookupMatch.NO_CONTEXT_INFORMATION};
                    return objectArray;
                }
                URI fileUri = null;
                if (data.context.getFileName() != null) {
                    RSourceLookupMatch match2;
                    IFileStore fileStore;
                    IFile wsFile;
                    block61: {
                        List<Object> elements;
                        wsFile = null;
                        fileStore = null;
                        try {
                            RProcess process = ((RDebugTarget)data.frame.getDebugTarget()).getProcess();
                            fileStore = process.getWorkspaceData().isRemote() ? process.getWorkspaceData().toFileStore(data.context.getFileName()) : FileUtil.getFileStore((String)data.context.getFileName());
                        }
                        catch (Exception e) {
                            data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occured when looking up R sources ({0}).", (Object)data.context.getFileName()), (Throwable)e));
                        }
                        try {
                            if (fileStore != null) {
                                fileUri = fileStore.toURI();
                            }
                            if (fileUri == null) {
                                fileUri = URIUtil.toURI((String)data.context.getFileName());
                            }
                        }
                        catch (Exception e) {
                            data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occured when looking up R sources ({0}).", (Object)data.context.getFileName()), (Throwable)e));
                        }
                        if (fileUri != null && !fileUri.isAbsolute()) {
                            fileUri = null;
                        }
                        if (DEBUG_LOG) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Resolved filenames:");
                            sb.append("\n\tfileStore= ").append(fileStore != null ? fileStore.toString() : "<missing>");
                            sb.append("\n\tfileUri=   ").append(fileUri != null ? fileUri.toString() : "<missing>");
                            data.addStatus((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, sb.toString(), null));
                        }
                        IPath path = data.context.getFilePath() != null ? Path.fromPortableString((String)data.context.getFilePath()) : null;
                        boolean addedPath = false;
                        try {
                            if (fileUri != null) {
                                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(fileUri, 8);
                                elements = null;
                                if (files.length > 0 && path != null) {
                                    int i = 0;
                                    while (i < files.length) {
                                        if (path.equals((Object)files[i].getFullPath())) {
                                            addedPath = true;
                                            elements = this.findSourceElement(fileUri, new IFile[]{files[i]}, data);
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                                if (elements == null) {
                                    elements = this.findSourceElement(fileUri, files, data);
                                }
                                if (elements != null) {
                                    addedFile = true;
                                    RSourceLookupMatch match3 = new RSourceLookupMatch(data.frame, elements.get(0));
                                    this.checkPosition(data, match3);
                                    matches.add(match3);
                                    bestQuality = Math.max(bestQuality, match3.quality);
                                } else if (files.length > 0) {
                                    wsFile = files[0];
                                }
                            }
                        }
                        catch (Exception e) {
                            data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occured when looking up R sources ({0}).", (Object)fileUri.toString()), (Throwable)e));
                        }
                        if (!addedPath && path != null) {
                            try {
                                if (fileUri == null) break block61;
                                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                                addedPath = true;
                                elements = null;
                                if (file.exists()) {
                                    elements = this.findSourceElement(file.getLocationURI(), new IFile[]{file}, data);
                                }
                                if (elements == null) {
                                    elements = this.findSourceElement(path, data);
                                }
                                if (elements == null) break block61;
                                int i = 0;
                                while (i < elements.size()) {
                                    RSourceLookupMatch match4 = new RSourceLookupMatch(data.frame, elements.get(i));
                                    this.checkPosition(data, match4);
                                    matches.add(match4);
                                    bestQuality = Math.max(bestQuality, match4.quality);
                                    if (bestQuality < 22) {
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Exception e) {
                                data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occured when looking up R sources ({0}).", (Object)path), (Throwable)e));
                            }
                        }
                    }
                    if ((bestQuality <= 0 || findDuplicates) && !addedFile && wsFile != null) {
                        try {
                            if (wsFile.exists()) {
                                addedFile = true;
                                match2 = new RSourceLookupMatch(data.frame, wsFile);
                                this.checkPosition(data, match2);
                                matches.add(match2);
                                bestQuality = Math.max(bestQuality, match2.quality);
                            }
                        }
                        catch (Exception e) {
                            if (!findDuplicates && !matches.isEmpty()) {
                                matches.clear();
                            }
                            data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occured when looking up R sources ({0}).", (Object)wsFile.toString()), (Throwable)e));
                        }
                    }
                    if ((bestQuality <= 0 || findDuplicates) && !addedFile && fileStore != null) {
                        try {
                            if (fileStore.fetchInfo().exists()) {
                                addedFile = true;
                                match2 = new RSourceLookupMatch(data.frame, fileStore);
                                this.checkPosition(data, match2);
                                matches.add(match2);
                                bestQuality = Math.max(bestQuality, match2.quality);
                            }
                        }
                        catch (Exception e) {
                            if (!findDuplicates && !matches.isEmpty()) {
                                matches.clear();
                            }
                            data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occured when looking up R sources ({0}).", (Object)fileStore.toString()), (Throwable)e));
                        }
                    }
                }
                if (data.context.getSourceCode() != null && (bestQuality <= 0 || findDuplicates)) {
                    try {
                        this.createFragment(data);
                        match = new RSourceLookupMatch(data.frame, (Object)data.fragment);
                        this.checkPosition(data, match);
                        matches.add(match);
                        bestQuality = Math.max(bestQuality, match.quality);
                    }
                    catch (Exception e) {
                        if (!findDuplicates && !matches.isEmpty()) {
                            matches.clear();
                        }
                        data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occured when looking up R sources ({0}).", (Object)data.context.getSourceType()), (Throwable)e));
                    }
                }
                if (matches.isEmpty() && data.context.getPosition() <= 0) {
                    throw new DebugException((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 5011, "Not supported.", null));
                }
                if (DEBUG_LOG) {
                    if (matches.isEmpty()) {
                        RDebugCorePlugin.log((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"Could not find R sources ({0}, {1}).", (Object)data.context.getSourceType(), (Object)data.context.getFileName()), null));
                    } else {
                        RDebugCorePlugin.log((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"Could not find R sources ({0}, {1}).", (Object)data.context.getSourceType(), (Object)data.context.getFileName()), null));
                    }
                }
                if (!(matches.size() <= 0 || findDuplicates && matches.size() != 1)) {
                    match = null;
                    int i = 0;
                    while (i < matches.size()) {
                        if (((RSourceLookupMatch)matches.get(i)).quality >= bestQuality) {
                            match = (RSourceLookupMatch)matches.get(i);
                            break;
                        }
                        ++i;
                    }
                    if (!findDuplicates && matches.size() > 1) {
                        matches.clear();
                        matches.add(match);
                    }
                    match.install();
                } else {
                    data.frame.setPositionResolver(data.context, null);
                }
                Object[] objectArray = matches.toArray();
                return objectArray;
            }
            finally {
                if (data.status != null) {
                    RDebugCorePlugin.log((IStatus)new MultiStatus("org.eclipse.statet.r.debug.core", 0, data.status.toArray(new IStatus[data.status.size()]), "R source lookup report.", null));
                }
            }
        }
        return null;
    }

    protected void createFragment(LookupData data) {
        if (data.fragment == null) {
            String fullName;
            String name;
            if (data.context.getSourceCode() == null) {
                throw new IllegalStateException();
            }
            if (data.context.getSourceType() == 2 && data.context.getFileName() != null) {
                fullName = name = data.context.getFileName();
                int idx = name.lastIndexOf(47);
                int idx2 = name.lastIndexOf(92);
                if (idx2 > idx) {
                    idx = idx2;
                }
                if (idx >= 0) {
                    name = name.substring(idx + 1);
                }
            } else if (data.context.getCall() != null) {
                fullName = name = data.context.getCall();
                int idx = name.indexOf(40);
                if (idx > 0) {
                    name = name.substring(0, idx);
                }
            } else {
                fullName = name = "Frame #" + data.context.getPosition();
            }
            data.fragment = new RRuntimeSourceFragment(((RDebugTarget)data.frame.getDebugTarget()).getProcess(), name, fullName, data.context.getSourceCode());
        }
    }

    protected List<Object> findSourceElement(URI fileUri, IFile[] fileInWorkspace, LookupData data) {
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            if (containers[i] instanceof IRSourceContainer) {
                try {
                    Object element = ((IRSourceContainer)containers[i]).findSourceElement(fileUri, fileInWorkspace);
                    if (element != null) {
                        if (DEBUG_LOG) {
                            data.addStatus((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"Source element found in ''{0}'': {1}", (Object)containers[i].getName(), (Object)element.toString()), null));
                        }
                        ArrayList<Object> list = new ArrayList<Object>(1);
                        list.add(element);
                        return list;
                    }
                }
                catch (Exception e) {
                    data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occurred when the finding source element ''{0}'' in ''{1}''.", (Object)(fileUri != null ? fileUri.toString() : "<missing>"), (Object)containers[i].getName()), (Throwable)e));
                }
            }
            ++i;
        }
        return null;
    }

    protected List<Object> findSourceElement(IPath path, LookupData data) {
        ISourceContainer[] containers = this.getSourceContainers();
        ArrayList<Object> elements = new ArrayList<Object>();
        int i = 0;
        while (i < containers.length) {
            int j = 0;
            if (containers[i] instanceof IRSourceContainer) {
                try {
                    ((IRSourceContainer)containers[i]).findSourceElement(path, elements);
                    if (DEBUG_LOG) {
                        while (j < elements.size()) {
                            data.addStatus((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"Source element found in ''{0}'': {1}", (Object)containers[i].getName(), (Object)elements.get(j).toString()), null));
                            ++j;
                        }
                    }
                }
                catch (Exception e) {
                    data.addStatus((IStatus)new Status(2, "org.eclipse.statet.r.debug.core", 0, NLS.bind((String)"An error occurred when finding the source element ''{0}'' in ''{1}''.", (Object)(path != null ? path.toString() : "<missing>"), (Object)containers[i].getName()), (Throwable)e));
                }
            }
            ++i;
        }
        if (elements.size() > 0) {
            return elements;
        }
        return null;
    }

    private RSourceUnit getSourceUnit(RSourceLookupMatch match, IProgressMonitor monitor) {
        SourceUnitManager suManager = LtkModels.getSourceUnitManager();
        SourceUnit su = suManager.getSourceUnit(Ltk.PERSISTENCE_CONTEXT, match.sourceElement, null, true, monitor);
        SourceUnit editorSu = LtkModels.getSourceUnitManager().getSourceUnit(Ltk.EDITOR_CONTEXT, su != null ? su : match.sourceElement, null, true, monitor);
        if (editorSu != null) {
            su = editorSu;
        }
        return (RSourceUnit)(su instanceof RSourceUnit ? su : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected int checkPosition(LookupData data, RSourceLookupMatch match) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            match.currentContext = data.context;
            match.quality = -1;
            match.charStart = -1;
            match.charEnd = -1;
            match.lineNumber = -1;
            RSourceUnit su = this.getSourceUnit(match, (IProgressMonitor)monitor);
            SourceUnit fragmentSu = null;
            if (su != null) {
                try {
                    AbstractDocument suDocument = su.getDocument((IProgressMonitor)monitor);
                    Object object = suDocument instanceof ISynchronizable ? ((ISynchronizable)suDocument).getLockObject() : new Object();
                    synchronized (object) {
                        IRSrcref exprSrcref;
                        SourceCorrection corr = new SourceCorrection();
                        AbstractDocument bDocument = null;
                        IRSrcref iRSrcref = exprSrcref = data.context.getExprSrcref() != null ? RDbg.createStatetSrcref((int[])data.context.getExprSrcref()) : null;
                        if (data.context.getFileTimestamp() != 0L && Srcfiles.equalsTimestamp((long)RDbg.getTimestamp((SourceUnit)su, (IProgressMonitor)monitor), (long)data.context.getFileTimestamp())) {
                            match.quality = 23;
                            bDocument = suDocument;
                            IRSrcref sourceSrcref = RDbg.createStatetSrcref((int[])data.context.getSourceSrcref());
                            if (sourceSrcref != null) {
                                corr.suLineShift = corr.bLineShift = sourceSrcref.getFirstLine();
                                corr.suFirstColumnCharOffset = corr.bFirstColumnCharOffset = this.computeOffset(sourceSrcref.getFirstLine(), sourceSrcref.getFirstColumn(), bDocument, bDocument, null, 0);
                            }
                        } else {
                            IRSrcref lastSrcref;
                            IRSrcref firstSrcref = data.context.getFirstSrcref() != null ? RDbg.createStatetSrcref((int[])data.context.getFirstSrcref()) : null;
                            IRSrcref iRSrcref2 = lastSrcref = data.context.getLastSrcref() != null ? RDbg.createStatetSrcref((int[])data.context.getLastSrcref()) : null;
                            if (data.context.getSourceType() < 3) {
                                String suCode = suDocument.get();
                                if (suCode.equals(data.context.getSourceCode())) {
                                    match.quality = 22;
                                    bDocument = suDocument;
                                } else {
                                    bDocument = new Document(data.context.getSourceCode());
                                    int end = -1;
                                    if (firstSrcref != null && lastSrcref != null && firstSrcref.hasBeginDetail() && lastSrcref.hasEndDetail()) {
                                        corr.firstLine = firstSrcref.getFirstLine();
                                        corr.firstColumn = firstSrcref.getFirstColumn();
                                        corr.bFirstLineCharOffset = bDocument.getLineOffset(corr.firstLine);
                                        corr.bFirstColumnCharOffset = this.computeOffset(firstSrcref.getFirstLine(), firstSrcref.getFirstColumn(), bDocument, bDocument, null, 0);
                                        end = this.computeOffset(lastSrcref.getLastLine(), lastSrcref.getLastColumn(), bDocument, bDocument, null, 1);
                                    } else if (exprSrcref != null && exprSrcref.hasBeginDetail() && exprSrcref.hasEndDetail()) {
                                        corr.firstLine = exprSrcref.getFirstLine();
                                        corr.firstColumn = exprSrcref.getFirstColumn();
                                        corr.bFirstLineCharOffset = bDocument.getLineOffset(corr.firstLine);
                                        corr.bFirstColumnCharOffset = this.computeOffset(exprSrcref.getFirstLine(), exprSrcref.getFirstColumn(), bDocument, bDocument, null, 0);
                                        end = this.computeOffset(exprSrcref.getLastLine(), exprSrcref.getLastColumn(), bDocument, bDocument, null, 1);
                                    }
                                    if (end >= 0) {
                                        String bCode = bDocument.get(corr.bFirstColumnCharOffset, end - corr.bFirstColumnCharOffset);
                                        match.quality = this.searchCode(data, corr, suDocument, suCode, bDocument, bCode);
                                    }
                                }
                            } else if (data.context.getSourceType() == 3) {
                                SourceUnitModelInfo modelInfo;
                                Block body;
                                this.createFragment(data);
                                fragmentSu = LtkModels.getSourceUnitManager().getSourceUnit("R", Ltk.EDITOR_CONTEXT, (Object)data.fragment, true, (IProgressMonitor)monitor);
                                if (fragmentSu != null && firstSrcref != null && firstSrcref.hasBeginDetail() && (body = this.findFBody(modelInfo = fragmentSu.getModelInfo("R", 2, (IProgressMonitor)monitor))) != null) {
                                    bDocument = fragmentSu.getDocument((IProgressMonitor)monitor);
                                    corr.firstLine = firstSrcref.getFirstLine();
                                    corr.firstColumn = firstSrcref.getFirstColumn();
                                    corr.bFirstLineCharOffset = bDocument.getLineOffset(corr.firstLine);
                                    corr.bFirstColumnCharOffset = body.getStartOffset();
                                    corr.bLineShift = bDocument.getLineOfOffset(body.getStartOffset()) - corr.firstLine;
                                    String bCode = bDocument.get(body.getStartOffset(), body.getLength());
                                    match.quality = this.searchCode(data, corr, suDocument, suDocument.get(), bDocument, bCode);
                                }
                            }
                        }
                        if (exprSrcref != null) {
                            match.lineNumber = exprSrcref.getFirstLine() + corr.suLineShift;
                            if (match.quality >= 10 && exprSrcref.hasBeginDetail() && exprSrcref.hasEndDetail()) {
                                match.charStart = this.computeOffset(exprSrcref.getFirstLine(), exprSrcref.getFirstColumn(), bDocument, suDocument, corr, 0);
                                match.charEnd = this.computeOffset(exprSrcref.getLastLine(), exprSrcref.getLastColumn(), bDocument, suDocument, corr, 1);
                            }
                        }
                        int n = match.quality;
                        return n;
                    }
                }
                finally {
                    su.disconnect((IProgressMonitor)monitor);
                    if (fragmentSu != null) {
                        fragmentSu.disconnect((IProgressMonitor)monitor);
                    }
                }
            }
        }
        catch (Exception e) {
            data.addStatus((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred in advanced position detection.", (Throwable)e));
        }
        return 0;
    }

    private int searchCode(LookupData data, SourceCorrection corr, AbstractDocument suDocument, String suCode, AbstractDocument bDocument, String bCode) throws BadLocationException {
        int offset2;
        IRegion line;
        int offset = suCode.indexOf(bCode);
        if (offset < 0 && bDocument.getDefaultLineDelimiter() != suDocument.getDefaultLineDelimiter()) {
            bCode = bCode.replace(bDocument.getDefaultLineDelimiter(), suDocument.getDefaultLineDelimiter());
            offset = suCode.indexOf(bCode);
        }
        if (offset < 0) {
            return 0;
        }
        int firstLine = corr.firstLine;
        if (data.context.getSourceSrcref() != null && data.context.getSourceSrcref()[0] > 0) {
            firstLine += data.context.getSourceSrcref()[0] - 1;
        }
        if (offset >= 0 && offset < suDocument.getLength() && firstLine < suDocument.getNumberOfLines() && offset < (line = suDocument.getLineInformation(firstLine)).getOffset() && (offset2 = suCode.indexOf(bCode, line.getOffset())) >= 0 && offset2 < line.getOffset() + line.getLength()) {
            offset = offset2;
        }
        if (offset >= 0) {
            int suLine = suDocument.getLineOfOffset(offset);
            corr.suLineShift = suLine - corr.firstLine;
            corr.suFirstLineCharOffset = suDocument.getLineOffset(suLine);
            corr.suFirstColumnCharOffset = offset;
            return 13;
        }
        return 0;
    }

    private Block findFBody(SourceUnitModelInfo modelInfo) {
        if (modelInfo instanceof RSourceUnitModelInfo && modelInfo.getSourceElement() != null) {
            RAstNode body;
            LtkModelElement modelElement;
            FDef fDef = null;
            List children = modelInfo.getSourceElement().getSourceChildren(null);
            if (children.size() == 1 && (modelElement = (LtkModelElement)children.get(0)) instanceof RLangMethod) {
                fDef = (FDef)modelElement.getAdapter(FDef.class);
            }
            if (fDef == null && modelInfo.getAst().getRoot() instanceof RAstNode) {
                RAsts.AssignExpr assign;
                RAstNode node = ((RAstNode)modelInfo.getAst().getRoot()).getChild(0);
                if (node.getNodeType() == NodeType.F_DEF) {
                    fDef = (FDef)node;
                }
                if (fDef == null && (assign = RAsts.checkAssign((RAstNode)node)) != null && assign.valueNode != null && assign.valueNode.getNodeType() == NodeType.F_DEF) {
                    fDef = (FDef)assign.valueNode;
                }
            }
            if (fDef != null && (body = fDef.getContChild()).getNodeType() == NodeType.BLOCK) {
                return (Block)body;
            }
        }
        return null;
    }

    private int computeOffset(int line, int column, AbstractDocument bDocument, AbstractDocument suDocument, SourceCorrection corr, int shift) throws BadLocationException {
        int charOffset = 0;
        int bLine = line;
        if (corr != null) {
            bLine += corr.bLineShift;
        }
        IRegion lineInfo = bDocument.getLineInformation(bLine);
        int currentColumn = 0;
        if (corr != null && line == corr.firstLine) {
            if ((currentColumn += corr.firstColumn) > column) {
                return -1;
            }
            charOffset += corr.bFirstColumnCharOffset - lineInfo.getOffset();
        }
        while (currentColumn < column && charOffset < lineInfo.getLength()) {
            char c = bDocument.getChar(lineInfo.getOffset() + charOffset++);
            if (c == '\t') {
                currentColumn += 8 - currentColumn % 8;
                continue;
            }
            ++currentColumn;
        }
        int suLine = line;
        if (corr != null) {
            suLine += corr.suLineShift;
        }
        lineInfo = suDocument.getLineInformation(suLine);
        if (corr != null && line == corr.firstLine) {
            charOffset += corr.suFirstColumnCharOffset - corr.suFirstLineCharOffset - (corr.bFirstColumnCharOffset - corr.bFirstLineCharOffset);
        }
        return lineInfo.getOffset() + Math.min(charOffset += shift, lineInfo.getLength());
    }

    protected static class LookupData {
        final RStackFrame frame;
        final FrameContext context;
        RRuntimeSourceFragment fragment;
        List<IStatus> status;

        public LookupData(RStackFrame frame) {
            this.frame = frame;
            this.context = this.frame.getContext();
        }

        public void addStatus(IStatus status) {
            if (this.status == null) {
                this.status = new ArrayList<IStatus>();
            }
            this.status.add(status);
        }
    }

    protected class RSourceLookupMatch
    implements RStackFrame.PositionResolver,
    IRSourceLookupMatch {
        private final RStackFrame frame;
        private final Object sourceElement;
        private FrameContext currentContext;
        private int quality;
        private int lineNumber;
        private int charStart;
        private int charEnd;

        public RSourceLookupMatch(RStackFrame frame, Object sourceElement) {
            this.frame = frame;
            this.sourceElement = sourceElement;
        }

        @Override
        public Object getElement() {
            return this.sourceElement;
        }

        @Override
        public synchronized int getLineNumber() {
            if (this.currentContext != this.frame.getContext()) {
                this.update();
            }
            return this.lineNumber;
        }

        @Override
        public synchronized int getCharStart() {
            if (this.currentContext != this.frame.getContext()) {
                this.update();
            }
            return this.charStart;
        }

        @Override
        public synchronized int getCharEnd() {
            if (this.currentContext != this.frame.getContext()) {
                this.update();
            }
            return this.charEnd;
        }

        public void install() {
            if (DEBUG_LOG) {
                RDebugCorePlugin.log((IStatus)new Status(1, "org.eclipse.statet.r.debug.core", 0, "Installing " + this.toString(), null));
            }
            this.frame.setPositionResolver(this.currentContext, this);
        }

        @Override
        public void select() {
            this.install();
        }

        public void update() {
            LookupData data = new LookupData(this.frame);
            if (data.context != null) {
                RSourceLookupParticipant.this.checkPosition(data, this);
            }
        }

        public int hashCode() {
            return this.frame.hashCode() + this.sourceElement.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RSourceLookupMatch)) {
                return false;
            }
            RSourceLookupMatch other = (RSourceLookupMatch)obj;
            return this.frame == other.frame && this.sourceElement.equals(other.sourceElement);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append("\nfor ").append(this.frame.toString());
            sb.append("\nsource lookup result:");
            sb.append("\n\tsourceElement= ").append(this.sourceElement);
            sb.append("\n\tlineNumber= ").append(this.lineNumber);
            sb.append("\n\tcharStart= ").append(this.charStart);
            sb.append("\n\tcharEnd= ").append(this.charEnd);
            return sb.toString();
        }
    }

    private static class SourceCorrection {
        int firstLine;
        int firstColumn;
        int bLineShift;
        int bFirstLineCharOffset;
        int bFirstColumnCharOffset;
        int suLineShift;
        int suFirstLineCharOffset;
        int suFirstColumnCharOffset;

        private SourceCorrection() {
        }
    }
}

