/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net;

import java.io.Serializable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class Port
implements Serializable {
    private static final long serialVersionUID = -3612703291136601800L;
    private final int num;

    public static Port valueOf(String s) throws IllegalArgumentException {
        return new Port(Integer.parseInt(s));
    }

    static final boolean isValidPortNum(int num) {
        return num >= 0 && num <= 65535;
    }

    public Port(int num) {
        if (!Port.isValidPortNum(num)) {
            throw new IllegalArgumentException("num= " + num);
        }
        this.num = num;
    }

    public int get() {
        return this.num;
    }

    public String getText() {
        return Integer.toString(this.num);
    }

    public int hashCode() {
        return this.num ^ this.num << 8;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Port && this.num == ((Port)obj).num;
    }

    public String toString() {
        return Integer.toString(this.num);
    }
}

