/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.jcommons.ts.core.util.ToolCommandHandlerUtils;
import org.eclipse.statet.nico.core.runtime.IToolEventHandler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

public class RunBlockingHandler
implements IToolEventHandler {
    public Status execute(String id, final ToolService service, Map<String, Object> data, ProgressMonitor m) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        final ToolRunnable toolRunnable = (ToolRunnable)ToolCommandHandlerUtils.getCheckedData(data, (String)"runnable", ToolRunnable.class, (boolean)true);
        try {
            progressService.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ProgressMonitor m = EStatusUtils.convert((IProgressMonitor)monitor, (int)1);
                    try {
                        toolRunnable.run(service, m);
                    }
                    catch (StatusException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return Statuses.OK_STATUS;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getCause();
            if (targetException instanceof StatusException && ((StatusException)targetException).getStatus().getSeverity() == 8) {
                return Statuses.CANCEL_STATUS;
            }
            return this.handleError((Status)new ErrorStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.ExecuteHandler_error_message, (Object)toolRunnable.getLabel()), targetException));
        }
        catch (InterruptedException e) {
            return Statuses.CANCEL_STATUS;
        }
    }

    protected Status handleError(Status status) {
        StatusManager.getManager().handle(EStatusUtils.convert((Status)status), 3);
        return status;
    }
}

