/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.sourceediting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpContextProvider;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpView;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistComputer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IEditorStatusLine;

@NonNullByDefault
public class MarkupHelpComputer
implements QuickAssistComputer {
    public void computeAssistProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        MarkupHelpContextProvider contextProvider = (MarkupHelpContextProvider)context.getEditor().getAdapter(MarkupHelpContextProvider.class);
        if (contextProvider != null) {
            proposals.add((AssistProposal)new ShowHelpProposal(context.getEditor()));
        }
    }

    private static class ShowHelpProposal
    implements AssistProposal {
        private final ISourceEditor editor;

        public ShowHelpProposal(ISourceEditor editor) {
            this.editor = editor;
        }

        public int getRelevance() {
            return 50;
        }

        public Image getImage() {
            return DocmlBaseUIResources.INSTANCE.getImage("org.eclipse.statet.docmlet.base/image/view/MarkupHelp");
        }

        public String getDisplayString() {
            return "Show Markup Cheat Sheet";
        }

        public String getSortingString() {
            return this.getDisplayString();
        }

        public @Nullable String getAdditionalProposalInfo() {
            return null;
        }

        public boolean validate(IDocument document, int offset, @Nullable DocumentEvent event) {
            return true;
        }

        public void apply(@Nullable IDocument document) {
            MarkupHelpContextProvider contextProvider = (MarkupHelpContextProvider)this.editor.getAdapter(MarkupHelpContextProvider.class);
            String contentId = contextProvider.getHelpContentId();
            if (contentId != null) {
                IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
                if (page != null) {
                    try {
                        MarkupHelpView view = (MarkupHelpView)page.showView("org.eclipse.statet.docmlet.views.MarkupHelp");
                        view.show(contentId);
                    }
                    catch (PartInitException e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, "An error occurred while opening the Markup Help View to show a cheat sheet.", (Throwable)e));
                    }
                }
            } else {
                IEditorStatusLine statusLine = (IEditorStatusLine)this.editor.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    statusLine.setMessage(true, "No cheat sheet available for the current markup language.", null);
                }
            }
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(null);
        }

        public @Nullable Point getSelection(IDocument document) {
            return null;
        }

        public @Nullable IContextInformation getContextInformation() {
            return null;
        }
    }
}

