/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.ast.Embedded;
import org.eclipse.statet.docmlet.tex.core.ast.LtxParser;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.model.build.LtxProblemReporter;
import org.eclipse.statet.docmlet.tex.core.model.build.LtxSourceUnitModelContainer;
import org.eclipse.statet.docmlet.tex.core.model.build.LtxSourceUnitModelContainerEmbeddedExtension;
import org.eclipse.statet.docmlet.tex.core.parser.NowebLtxLexer;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxModelManagerImpl;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxSourceUnitModelInfoImpl;
import org.eclipse.statet.internal.docmlet.tex.core.model.SourceAnalyzer;
import org.eclipse.statet.jcommons.string.InternStringCache;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstPrinter;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.core.SourceModelStamp;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.impl.BasicSourceModelStamp;

public class LtxReconciler {
    private static final boolean DEBUG_LOG_AST = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.docmlet.tex/debug/Reconciler/logAst"));
    private final LtxModelManagerImpl texManager;
    protected boolean stop = false;
    private final Object raLock = new Object();
    private final StringParserInput raInput = new StringParserInput(4096);
    private final NowebLtxLexer raLexer = new NowebLtxLexer();
    private final LtxParser raParser = new LtxParser(this.raLexer, (StringFactory)new InternStringCache(32));
    private AstPrinter raDebugAstPrinter;
    private final Object rmLock = new Object();
    private final SourceAnalyzer rmSourceAnalyzer = new SourceAnalyzer();
    private final Object rpLock = new Object();
    private final LtxProblemReporter rpReporter = new LtxProblemReporter();

    public LtxReconciler(LtxModelManagerImpl manager) {
        this.texManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(LtxSourceUnitModelContainer<?> adapter, int flags, IProgressMonitor monitor) {
        TexSourceUnit su = (TexSourceUnit)adapter.getSourceUnit();
        Data data = new Data(adapter, monitor);
        if (data.content == null) {
            return;
        }
        Object object = this.raLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            this.updateAst(data, flags, monitor);
        }
        if (this.stop || monitor.isCanceled() || (flags & 0xF) < 2) {
            return;
        }
        object = this.rmLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            boolean updated = this.updateModel(data, flags, monitor);
            if (updated) {
                this.texManager.getEventJob().addUpdate((LtkModelElement)su, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            ProblemRequestor problemRequestor = null;
            Object object2 = this.rpLock;
            synchronized (object2) {
                if (!this.stop && !monitor.isCanceled() && data.newModel == adapter.getCurrentModel() && (problemRequestor = adapter.createProblemRequestor()) != null) {
                    this.rpReporter.run(su, data.content, data.newModel, problemRequestor, flags, monitor);
                    if (data.embedded != null) {
                        data.embedded.reportEmbeddedProblems(data.content, data.newModel, problemRequestor, flags, monitor);
                    }
                }
                if (problemRequestor != null) {
                    problemRequestor.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags, IProgressMonitor monitor) {
        BasicSourceModelStamp stamp = new BasicSourceModelStamp(data.content.getStamp());
        data.ast = data.adapter.getCurrentAst();
        if (data.ast != null && !stamp.equals((Object)data.ast.getStamp())) {
            data.ast = null;
        }
        if (data.ast == null) {
            SourceComponent sourceNode;
            this.raInput.reset(data.content.getText());
            if (data.embedded != null) {
                this.raLexer.setNowebType(data.embedded.getNowebType());
                this.raParser.setCollectEmebeddedNodes(true);
                sourceNode = this.raParser.parse((TextParserInput)this.raInput.init(), data.texCoreAccess.getTexCommandSet());
                data.customCommands = this.raParser.getCustomCommandMap();
                data.customEnvs = this.raParser.getCustomEnvMap();
                List<Embedded> embeddedNodes = this.raParser.getEmbeddedNodes();
                data.embedded.reconcileEmbeddedAst(data.content, embeddedNodes, flags, monitor);
            } else {
                this.raLexer.setNowebType(null);
                this.raParser.setCollectEmebeddedNodes(false);
                sourceNode = this.raParser.parse((TextParserInput)this.raInput.init(), data.texCoreAccess.getTexCommandSet());
            }
            data.ast = new AstInfo(1, (SourceModelStamp)stamp, (AstNode)sourceNode);
            if (DEBUG_LOG_AST) {
                if (this.raDebugAstPrinter == null) {
                    this.raDebugAstPrinter = new AstPrinter((Writer)new StringWriter());
                }
                StringWriter out = (StringWriter)this.raDebugAstPrinter.getWriter();
                out.getBuffer().setLength(0);
                try {
                    out.append("====\nLtx AST:\n");
                    this.raDebugAstPrinter.print(data.ast.getRoot(), data.content.getText());
                    out.append("====\n");
                    System.out.println(out.toString());
                }
                catch (Exception e) {
                    System.out.println(out.toString());
                    e.printStackTrace();
                }
            }
            LtxSourceUnitModelContainer<?> ltxSourceUnitModelContainer = data.adapter;
            synchronized (ltxSourceUnitModelContainer) {
                data.adapter.setAst(data.ast);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags, IProgressMonitor monitor) {
        data.newModel = (LtxSourceUnitModelInfo)data.adapter.getCurrentModel();
        if (data.newModel != null && !data.ast.getStamp().equals(data.newModel.getStamp())) {
            data.newModel = null;
        }
        if (data.newModel == null) {
            boolean isOK;
            LtxSourceUnitModelInfoImpl model = this.rmSourceAnalyzer.createModel((TexSourceUnit)data.adapter.getSourceUnit(), data.content.getText(), data.ast, data.customCommands, data.customEnvs);
            boolean bl = isOK = model != null;
            if (data.embedded != null) {
                data.embedded.reconcileEmbeddedModel(data.content, model, this.rmSourceAnalyzer.getEmbeddedItems(), flags, monitor);
            }
            if (isOK) {
                LtxSourceUnitModelContainer<?> ltxSourceUnitModelContainer = data.adapter;
                synchronized (ltxSourceUnitModelContainer) {
                    data.oldModel = (LtxSourceUnitModelInfo)data.adapter.getCurrentModel();
                    data.adapter.setModel(model);
                }
                data.newModel = model;
                return true;
            }
        }
        return false;
    }

    void stop() {
        this.stop = true;
    }

    protected static class Data {
        public final LtxSourceUnitModelContainer<?> adapter;
        public final LtxSourceUnitModelContainerEmbeddedExtension embedded;
        public final SourceContent content;
        private final TexCoreAccess texCoreAccess;
        public int parseOffset;
        public AstInfo ast;
        public Map<String, TexCommand> customCommands;
        public Map<String, TexCommand> customEnvs;
        public LtxSourceUnitModelInfo oldModel;
        public LtxSourceUnitModelInfo newModel;

        public Data(LtxSourceUnitModelContainer<?> adapter, IProgressMonitor monitor) {
            this.adapter = adapter;
            this.embedded = adapter instanceof LtxSourceUnitModelContainerEmbeddedExtension ? (LtxSourceUnitModelContainerEmbeddedExtension)((Object)adapter) : null;
            this.content = adapter.getParseContent(monitor);
            this.texCoreAccess = ((TexSourceUnit)adapter.getSourceUnit()).getTexCoreAccess();
        }
    }
}

